/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.broadcast;

import java.io.IOException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public abstract class BroadcastOperationRequest<T extends BroadcastOperationRequest>
extends ActionRequest<T>
implements IndicesRequest.Replaceable {
    protected String[] indices;
    private IndicesOptions indicesOptions = IndicesOptions.strictExpandOpenAndForbidClosed();

    protected BroadcastOperationRequest() {
    }

    protected BroadcastOperationRequest(ActionRequest originalRequest) {
        super(originalRequest);
    }

    protected BroadcastOperationRequest(String[] indices) {
        this.indices = indices;
    }

    @Override
    public String[] indices() {
        return this.indices;
    }

    public final T indices(String ... indices) {
        this.indices = indices;
        return (T)this;
    }

    @Override
    public ActionRequestValidationException validate() {
        return null;
    }

    @Override
    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public final T indicesOptions(IndicesOptions indicesOptions) {
        this.indicesOptions = indicesOptions;
        return (T)this;
    }

    protected void beforeStart() {
    }

    protected void beforeLocalFork() {
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeStringArrayNullable(this.indices);
        if (out.getVersion().before(Version.V_1_2_0)) {
            out.writeByte((byte)2);
        }
        this.indicesOptions.writeIndicesOptions(out);
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        super.readFrom(in);
        this.indices = in.readStringArray();
        if (in.getVersion().before(Version.V_1_2_0)) {
            in.readByte();
        }
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
    }
}

