/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.single.shard;

import java.io.IOException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.TransportAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.single.shard.SingleShardOperationRequest;
import org.elasticsearch.cluster.ClusterService;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.BaseTransportRequestHandler;
import org.elasticsearch.transport.BaseTransportResponseHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public abstract class TransportShardSingleOperationAction<Request extends SingleShardOperationRequest, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected final ClusterService clusterService;
    protected final TransportService transportService;
    final String transportShardAction;
    final String executor;

    protected TransportShardSingleOperationAction(Settings settings, String actionName, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters) {
        super(settings, actionName, threadPool, actionFilters);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.transportShardAction = actionName + "[s]";
        this.executor = this.executor();
        if (!this.isSubAction()) {
            transportService.registerHandler(actionName, new TransportHandler());
        }
        transportService.registerHandler(this.transportShardAction, new ShardTransportHandler());
    }

    protected boolean isSubAction() {
        return false;
    }

    @Override
    protected void doExecute(Request request, ActionListener<Response> listener) {
        new AsyncSingleAction(this, (SingleShardOperationRequest)request, listener).start();
    }

    protected abstract String executor();

    protected abstract Response shardOperation(Request var1, ShardId var2) throws ElasticsearchException;

    protected abstract Request newRequest();

    protected abstract Response newResponse();

    protected abstract boolean resolveIndex();

    protected ClusterBlockException checkGlobalBlock(ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    protected ClusterBlockException checkRequestBlock(ClusterState state, InternalRequest request) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.READ, request.concreteIndex());
    }

    protected void resolveRequest(ClusterState state, InternalRequest request) {
    }

    protected abstract ShardIterator shards(ClusterState var1, InternalRequest var2) throws ElasticsearchException;

    protected static class InternalRequest {
        final Request request;
        final String concreteIndex;
        final /* synthetic */ TransportShardSingleOperationAction this$0;

        InternalRequest(Request request, String concreteIndex) {
            this.this$0 = var1_1;
            this.request = request;
            this.concreteIndex = concreteIndex;
        }

        public Request request() {
            return this.request;
        }

        public String concreteIndex() {
            return this.concreteIndex;
        }
    }

    class ShardSingleOperationRequest
    extends TransportRequest
    implements IndicesRequest {
        private Request request;
        private ShardId shardId;

        ShardSingleOperationRequest() {
        }

        ShardSingleOperationRequest(Request request, ShardId shardId) {
            super((TransportRequest)request);
            this.request = request;
            this.shardId = shardId;
        }

        public Request request() {
            return this.request;
        }

        public ShardId shardId() {
            return this.shardId;
        }

        @Override
        public String[] indices() {
            return ((SingleShardOperationRequest)this.request).indices();
        }

        @Override
        public IndicesOptions indicesOptions() {
            return ((SingleShardOperationRequest)this.request).indicesOptions();
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.request = TransportShardSingleOperationAction.this.newRequest();
            ((SingleShardOperationRequest)this.request).readFrom(in);
            this.shardId = in.getVersion().onOrAfter(Version.V_1_4_0_Beta1) ? ShardId.readShardId(in) : new ShardId(((SingleShardOperationRequest)this.request).index(), in.readVInt());
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            if (out.getVersion().before(Version.V_1_4_0_Beta1)) {
                ((SingleShardOperationRequest)this.request).index(this.shardId.getIndex());
            }
            ((SingleShardOperationRequest)this.request).writeTo(out);
            if (out.getVersion().onOrAfter(Version.V_1_4_0_Beta1)) {
                this.shardId.writeTo(out);
            } else {
                out.writeVInt(this.shardId.id());
            }
        }
    }

    private class ShardTransportHandler
    extends BaseTransportRequestHandler<ShardSingleOperationRequest> {
        private ShardTransportHandler() {
        }

        @Override
        public ShardSingleOperationRequest newInstance() {
            return new ShardSingleOperationRequest();
        }

        @Override
        public String executor() {
            return TransportShardSingleOperationAction.this.executor;
        }

        @Override
        public void messageReceived(ShardSingleOperationRequest request, TransportChannel channel) throws Exception {
            if (TransportShardSingleOperationAction.this.logger.isTraceEnabled()) {
                TransportShardSingleOperationAction.this.logger.trace("executing [{}] on shard [{}]", request.request(), request.shardId());
            }
            Object response = TransportShardSingleOperationAction.this.shardOperation(request.request(), request.shardId());
            channel.sendResponse((TransportResponse)response);
        }
    }

    private class TransportHandler
    extends BaseTransportRequestHandler<Request> {
        private TransportHandler() {
        }

        @Override
        public Request newInstance() {
            return TransportShardSingleOperationAction.this.newRequest();
        }

        @Override
        public String executor() {
            return "same";
        }

        @Override
        public void messageReceived(Request request, final TransportChannel channel) throws Exception {
            ((ActionRequest)request).listenerThreaded(false);
            ((SingleShardOperationRequest)request).operationThreaded(true);
            TransportShardSingleOperationAction.this.execute(request, new ActionListener<Response>(){

                @Override
                public void onResponse(Response result) {
                    try {
                        channel.sendResponse((TransportResponse)result);
                    }
                    catch (Throwable e) {
                        this.onFailure(e);
                    }
                }

                @Override
                public void onFailure(Throwable e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        TransportShardSingleOperationAction.this.logger.warn("failed to send response for get", e1, new Object[0]);
                    }
                }
            });
        }
    }

    static class AsyncSingleAction {
        private final ActionListener<Response> listener;
        private final ShardIterator shardIt;
        private final InternalRequest internalRequest;
        private final DiscoveryNodes nodes;
        private volatile Throwable lastFailure;
        final /* synthetic */ TransportShardSingleOperationAction this$0;

        private AsyncSingleAction(Request request, ActionListener<Response> listener) {
            this.this$0 = var1_1;
            this.listener = listener;
            ClusterState clusterState = var1_1.clusterService.state();
            if (((TransportShardSingleOperationAction)var1_1).logger.isTraceEnabled()) {
                ((TransportShardSingleOperationAction)var1_1).logger.trace("executing [{}] based on cluster state version [{}]", request, clusterState.version());
            }
            this.nodes = clusterState.nodes();
            ClusterBlockException blockException = var1_1.checkGlobalBlock(clusterState);
            if (blockException != null) {
                throw blockException;
            }
            String concreteSingleIndex = var1_1.resolveIndex() ? clusterState.metaData().concreteSingleIndex(((SingleShardOperationRequest)request).index(), ((SingleShardOperationRequest)request).indicesOptions()) : ((SingleShardOperationRequest)request).index();
            this.internalRequest = new InternalRequest((TransportShardSingleOperationAction)var1_1, request, concreteSingleIndex);
            var1_1.resolveRequest(clusterState, this.internalRequest);
            blockException = var1_1.checkRequestBlock(clusterState, this.internalRequest);
            if (blockException != null) {
                throw blockException;
            }
            this.shardIt = var1_1.shards(clusterState, this.internalRequest);
        }

        public void start() {
            this.perform(null);
        }

        private void onFailure(ShardRouting shardRouting, Throwable e) {
            if (this.this$0.logger.isTraceEnabled() && e != null) {
                this.this$0.logger.trace("{}: failed to execute [{}]", e, shardRouting, this.internalRequest.request());
            }
            this.perform(e);
        }

        private void perform(@Nullable Throwable currentFailure) {
            block13: {
                ShardRouting shardRouting;
                Throwable lastFailure = this.lastFailure;
                if (lastFailure == null || TransportActions.isReadOverrideException(currentFailure)) {
                    lastFailure = currentFailure;
                    this.lastFailure = currentFailure;
                }
                if ((shardRouting = this.shardIt.nextOrNull()) == null) {
                    Throwable failure = lastFailure;
                    if (failure == null || TransportActions.isShardNotAvailableException(failure)) {
                        failure = new NoShardAvailableActionException(this.shardIt.shardId(), null, failure);
                    } else if (this.this$0.logger.isDebugEnabled()) {
                        this.this$0.logger.debug("{}: failed to execute [{}]", failure, this.shardIt.shardId(), this.internalRequest.request());
                    }
                    this.listener.onFailure(failure);
                    return;
                }
                if (shardRouting.currentNodeId().equals(this.nodes.localNodeId())) {
                    if (this.this$0.logger.isTraceEnabled()) {
                        this.this$0.logger.trace("executing [{}] on shard [{}]", this.internalRequest.request(), shardRouting.shardId());
                    }
                    try {
                        if (((SingleShardOperationRequest)this.internalRequest.request()).operationThreaded()) {
                            ((SingleShardOperationRequest)this.internalRequest.request()).beforeLocalFork();
                            this.this$0.threadPool.executor(this.this$0.executor).execute(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        Object response = AsyncSingleAction.this.this$0.shardOperation(AsyncSingleAction.this.internalRequest.request(), shardRouting.shardId());
                                        AsyncSingleAction.this.listener.onResponse(response);
                                    }
                                    catch (Throwable e) {
                                        AsyncSingleAction.this.onFailure(shardRouting, e);
                                    }
                                }
                            });
                            break block13;
                        }
                        Object response = this.this$0.shardOperation(this.internalRequest.request(), shardRouting.shardId());
                        this.listener.onResponse(response);
                    }
                    catch (Throwable e) {
                        this.onFailure(shardRouting, e);
                    }
                } else {
                    DiscoveryNode node = this.nodes.get(shardRouting.currentNodeId());
                    if (node == null) {
                        this.onFailure(shardRouting, new NoShardAvailableActionException(this.shardIt.shardId()));
                    } else {
                        this.this$0.transportService.sendRequest(node, this.this$0.transportShardAction, new ShardSingleOperationRequest(this.this$0, this.internalRequest.request(), shardRouting.shardId()), new BaseTransportResponseHandler<Response>(){

                            @Override
                            public Response newInstance() {
                                return AsyncSingleAction.this.this$0.newResponse();
                            }

                            @Override
                            public String executor() {
                                return "same";
                            }

                            @Override
                            public void handleResponse(Response response) {
                                AsyncSingleAction.this.listener.onResponse(response);
                            }

                            @Override
                            public void handleException(TransportException exp) {
                                AsyncSingleAction.this.onFailure(shardRouting, exp);
                            }
                        });
                    }
                }
            }
        }
    }
}

