/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.support;

import java.util.ArrayList;
import org.elasticsearch.ElasticsearchIllegalStateException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesAction;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.alias.exists.AliasesExistAction;
import org.elasticsearch.action.admin.indices.alias.exists.AliasesExistRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.exists.AliasesExistResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesAction;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeAction;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeRequest;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeRequestBuilder;
import org.elasticsearch.action.admin.indices.analyze.AnalyzeResponse;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheAction;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequest;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheRequestBuilder;
import org.elasticsearch.action.admin.indices.cache.clear.ClearIndicesCacheResponse;
import org.elasticsearch.action.admin.indices.close.CloseIndexAction;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequest;
import org.elasticsearch.action.admin.indices.close.CloseIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.close.CloseIndexResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexAction;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexAction;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsAction;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequestBuilder;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsAction;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsRequest;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsRequestBuilder;
import org.elasticsearch.action.admin.indices.exists.types.TypesExistsResponse;
import org.elasticsearch.action.admin.indices.flush.FlushAction;
import org.elasticsearch.action.admin.indices.flush.FlushRequest;
import org.elasticsearch.action.admin.indices.flush.FlushRequestBuilder;
import org.elasticsearch.action.admin.indices.flush.FlushResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexAction;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingAction;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.delete.DeleteMappingResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsAction;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsAction;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingAction;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.admin.indices.open.OpenIndexAction;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequest;
import org.elasticsearch.action.admin.indices.open.OpenIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.open.OpenIndexResponse;
import org.elasticsearch.action.admin.indices.optimize.OptimizeAction;
import org.elasticsearch.action.admin.indices.optimize.OptimizeRequest;
import org.elasticsearch.action.admin.indices.optimize.OptimizeRequestBuilder;
import org.elasticsearch.action.admin.indices.optimize.OptimizeResponse;
import org.elasticsearch.action.admin.indices.recovery.RecoveryAction;
import org.elasticsearch.action.admin.indices.recovery.RecoveryRequest;
import org.elasticsearch.action.admin.indices.recovery.RecoveryRequestBuilder;
import org.elasticsearch.action.admin.indices.recovery.RecoveryResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshAction;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentResponse;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentsAction;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentsRequest;
import org.elasticsearch.action.admin.indices.segments.IndicesSegmentsRequestBuilder;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsAction;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequestBuilder;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsAction;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequestBuilder;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsResponse;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsAction;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequestBuilder;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.admin.indices.status.IndicesStatusAction;
import org.elasticsearch.action.admin.indices.status.IndicesStatusRequest;
import org.elasticsearch.action.admin.indices.status.IndicesStatusRequestBuilder;
import org.elasticsearch.action.admin.indices.status.IndicesStatusResponse;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateRequestBuilder;
import org.elasticsearch.action.admin.indices.template.delete.DeleteIndexTemplateResponse;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesAction;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequest;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesRequestBuilder;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequestBuilder;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateResponse;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryAction;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequest;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryRequestBuilder;
import org.elasticsearch.action.admin.indices.validate.query.ValidateQueryResponse;
import org.elasticsearch.action.admin.indices.warmer.delete.DeleteWarmerAction;
import org.elasticsearch.action.admin.indices.warmer.delete.DeleteWarmerRequest;
import org.elasticsearch.action.admin.indices.warmer.delete.DeleteWarmerRequestBuilder;
import org.elasticsearch.action.admin.indices.warmer.delete.DeleteWarmerResponse;
import org.elasticsearch.action.admin.indices.warmer.get.GetWarmersAction;
import org.elasticsearch.action.admin.indices.warmer.get.GetWarmersRequest;
import org.elasticsearch.action.admin.indices.warmer.get.GetWarmersRequestBuilder;
import org.elasticsearch.action.admin.indices.warmer.get.GetWarmersResponse;
import org.elasticsearch.action.admin.indices.warmer.put.PutWarmerAction;
import org.elasticsearch.action.admin.indices.warmer.put.PutWarmerRequest;
import org.elasticsearch.action.admin.indices.warmer.put.PutWarmerRequestBuilder;
import org.elasticsearch.action.admin.indices.warmer.put.PutWarmerResponse;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.util.concurrent.CountDown;
import org.elasticsearch.transport.ActionNotFoundTransportException;

public abstract class AbstractIndicesAdminClient
implements IndicesAdminClient {
    @Override
    public <Request extends ActionRequest, Response extends ActionResponse, RequestBuilder extends ActionRequestBuilder<Request, Response, RequestBuilder, IndicesAdminClient>> RequestBuilder prepareExecute(Action<Request, Response, RequestBuilder, IndicesAdminClient> action) {
        return action.newRequestBuilder(this);
    }

    @Override
    public ActionFuture<IndicesExistsResponse> exists(IndicesExistsRequest request) {
        return this.execute(IndicesExistsAction.INSTANCE, request);
    }

    @Override
    public void exists(IndicesExistsRequest request, ActionListener<IndicesExistsResponse> listener) {
        this.execute(IndicesExistsAction.INSTANCE, request, listener);
    }

    @Override
    public IndicesExistsRequestBuilder prepareExists(String ... indices) {
        return new IndicesExistsRequestBuilder(this, indices);
    }

    @Override
    public ActionFuture<TypesExistsResponse> typesExists(TypesExistsRequest request) {
        return this.execute(TypesExistsAction.INSTANCE, request);
    }

    @Override
    public void typesExists(TypesExistsRequest request, ActionListener<TypesExistsResponse> listener) {
        this.execute(TypesExistsAction.INSTANCE, request, listener);
    }

    @Override
    public TypesExistsRequestBuilder prepareTypesExists(String ... index) {
        return new TypesExistsRequestBuilder(this, index);
    }

    @Override
    public ActionFuture<IndicesAliasesResponse> aliases(IndicesAliasesRequest request) {
        return this.execute(IndicesAliasesAction.INSTANCE, request);
    }

    @Override
    public void aliases(IndicesAliasesRequest request, ActionListener<IndicesAliasesResponse> listener) {
        this.execute(IndicesAliasesAction.INSTANCE, request, listener);
    }

    @Override
    public IndicesAliasesRequestBuilder prepareAliases() {
        return new IndicesAliasesRequestBuilder(this);
    }

    @Override
    public ActionFuture<GetAliasesResponse> getAliases(GetAliasesRequest request) {
        return this.execute(GetAliasesAction.INSTANCE, request);
    }

    @Override
    public void getAliases(GetAliasesRequest request, ActionListener<GetAliasesResponse> listener) {
        this.execute(GetAliasesAction.INSTANCE, request, listener);
    }

    @Override
    public GetAliasesRequestBuilder prepareGetAliases(String ... aliases) {
        return new GetAliasesRequestBuilder(this, aliases);
    }

    @Override
    public ActionFuture<ClearIndicesCacheResponse> clearCache(ClearIndicesCacheRequest request) {
        return this.execute(ClearIndicesCacheAction.INSTANCE, request);
    }

    @Override
    public void aliasesExist(GetAliasesRequest request, ActionListener<AliasesExistResponse> listener) {
        this.execute(AliasesExistAction.INSTANCE, request, listener);
    }

    @Override
    public ActionFuture<AliasesExistResponse> aliasesExist(GetAliasesRequest request) {
        return this.execute(AliasesExistAction.INSTANCE, request);
    }

    @Override
    public AliasesExistRequestBuilder prepareAliasesExist(String ... aliases) {
        return new AliasesExistRequestBuilder(this, aliases);
    }

    @Override
    public ActionFuture<GetIndexResponse> getIndex(GetIndexRequest request) {
        return this.execute(GetIndexAction.INSTANCE, request);
    }

    @Override
    public void getIndex(final GetIndexRequest request, final ActionListener<GetIndexResponse> listener) {
        this.execute(GetIndexAction.INSTANCE, request, new ActionListener<GetIndexResponse>(){

            @Override
            public void onResponse(GetIndexResponse response) {
                listener.onResponse(response);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void onFailure(Throwable e) {
                Throwable rootCause = ExceptionsHelper.unwrapCause(e);
                if (rootCause instanceof ActionNotFoundTransportException) {
                    String[] features = request.features();
                    if (features == null || features.length == 0) {
                        throw new ElasticsearchIllegalStateException("no features selected for GetIndex");
                    }
                    try {
                        void var7_10;
                        final ArrayList<Object> builderList = new ArrayList<Object>();
                        String[] arr$ = features;
                        int len$ = arr$.length;
                        boolean bl = false;
                        while (var7_10 < len$) {
                            String feature;
                            switch (feature = arr$[var7_10]) {
                                case "_alias": 
                                case "_aliases": {
                                    builderList.add(((GetAliasesRequestBuilder)AbstractIndicesAdminClient.this.prepareGetAliases(new String[0]).addIndices(request.indices())).setIndicesOptions(request.indicesOptions()));
                                    break;
                                }
                                case "_mapping": 
                                case "_mappings": {
                                    builderList.add(AbstractIndicesAdminClient.this.prepareGetMappings(request.indices()).setIndicesOptions(request.indicesOptions()));
                                    break;
                                }
                                case "_settings": {
                                    builderList.add(AbstractIndicesAdminClient.this.prepareGetSettings(request.indices()).setIndicesOptions(request.indicesOptions()));
                                    break;
                                }
                                case "_warmer": 
                                case "_warmers": {
                                    builderList.add(AbstractIndicesAdminClient.this.prepareGetWarmers(request.indices()).setIndicesOptions(request.indicesOptions()));
                                    break;
                                }
                                default: {
                                    throw new ElasticsearchIllegalStateException("feature [" + feature + "] is not valid");
                                }
                            }
                            ++var7_10;
                        }
                        ActionListener<Object> actionListener = new ActionListener<Object>(){
                            final CountDown countDown;
                            volatile GetAliasesResponse aliasResponse;
                            volatile GetMappingsResponse mappingResponse;
                            volatile GetSettingsResponse settingsResponse;
                            volatile GetWarmersResponse warmerResponse;
                            {
                                this.countDown = new CountDown(builderList.size());
                                this.aliasResponse = null;
                                this.mappingResponse = null;
                                this.settingsResponse = null;
                                this.warmerResponse = null;
                            }

                            @Override
                            public void onResponse(Object o) {
                                if (o instanceof GetAliasesResponse) {
                                    this.aliasResponse = (GetAliasesResponse)o;
                                } else if (o instanceof GetMappingsResponse) {
                                    this.mappingResponse = (GetMappingsResponse)o;
                                } else if (o instanceof GetSettingsResponse) {
                                    this.settingsResponse = (GetSettingsResponse)o;
                                } else if (o instanceof GetWarmersResponse) {
                                    this.warmerResponse = (GetWarmersResponse)o;
                                } else assert (false) : "Unexpected response type: " + o.getClass();
                                if (this.countDown.countDown()) {
                                    GetIndexResponse response = GetIndexResponse.convertResponses(this.aliasResponse, this.mappingResponse, this.settingsResponse, this.warmerResponse);
                                    listener.onResponse(response);
                                }
                            }

                            @Override
                            public void onFailure(Throwable e) {
                                if (this.countDown.fastForward()) {
                                    listener.onFailure(e);
                                }
                            }
                        };
                        for (ActionRequestBuilder actionRequestBuilder : builderList) {
                            actionRequestBuilder.execute(actionListener);
                        }
                    }
                    catch (Throwable e1) {
                        listener.onFailure(e1);
                    }
                } else {
                    listener.onFailure(e);
                }
            }
        });
    }

    @Override
    public GetIndexRequestBuilder prepareGetIndex() {
        return new GetIndexRequestBuilder((IndicesAdminClient)this, new String[0]);
    }

    @Override
    public void clearCache(ClearIndicesCacheRequest request, ActionListener<ClearIndicesCacheResponse> listener) {
        this.execute(ClearIndicesCacheAction.INSTANCE, request, listener);
    }

    @Override
    public ClearIndicesCacheRequestBuilder prepareClearCache(String ... indices) {
        return (ClearIndicesCacheRequestBuilder)new ClearIndicesCacheRequestBuilder(this).setIndices(indices);
    }

    @Override
    public ActionFuture<CreateIndexResponse> create(CreateIndexRequest request) {
        return this.execute(CreateIndexAction.INSTANCE, request);
    }

    @Override
    public void create(CreateIndexRequest request, ActionListener<CreateIndexResponse> listener) {
        this.execute(CreateIndexAction.INSTANCE, request, listener);
    }

    @Override
    public CreateIndexRequestBuilder prepareCreate(String index) {
        return new CreateIndexRequestBuilder(this, index);
    }

    @Override
    public ActionFuture<DeleteIndexResponse> delete(DeleteIndexRequest request) {
        return this.execute(DeleteIndexAction.INSTANCE, request);
    }

    @Override
    public void delete(DeleteIndexRequest request, ActionListener<DeleteIndexResponse> listener) {
        this.execute(DeleteIndexAction.INSTANCE, request, listener);
    }

    @Override
    public DeleteIndexRequestBuilder prepareDelete(String ... indices) {
        return new DeleteIndexRequestBuilder(this, indices);
    }

    @Override
    public ActionFuture<CloseIndexResponse> close(CloseIndexRequest request) {
        return this.execute(CloseIndexAction.INSTANCE, request);
    }

    @Override
    public void close(CloseIndexRequest request, ActionListener<CloseIndexResponse> listener) {
        this.execute(CloseIndexAction.INSTANCE, request, listener);
    }

    @Override
    public CloseIndexRequestBuilder prepareClose(String ... indices) {
        return new CloseIndexRequestBuilder(this, indices);
    }

    @Override
    public ActionFuture<OpenIndexResponse> open(OpenIndexRequest request) {
        return this.execute(OpenIndexAction.INSTANCE, request);
    }

    @Override
    public void open(OpenIndexRequest request, ActionListener<OpenIndexResponse> listener) {
        this.execute(OpenIndexAction.INSTANCE, request, listener);
    }

    @Override
    public OpenIndexRequestBuilder prepareOpen(String ... indices) {
        return new OpenIndexRequestBuilder(this, indices);
    }

    @Override
    public ActionFuture<FlushResponse> flush(FlushRequest request) {
        return this.execute(FlushAction.INSTANCE, request);
    }

    @Override
    public void flush(FlushRequest request, ActionListener<FlushResponse> listener) {
        this.execute(FlushAction.INSTANCE, request, listener);
    }

    @Override
    public FlushRequestBuilder prepareFlush(String ... indices) {
        return (FlushRequestBuilder)new FlushRequestBuilder(this).setIndices(indices);
    }

    @Override
    public void getMappings(GetMappingsRequest request, ActionListener<GetMappingsResponse> listener) {
        this.execute(GetMappingsAction.INSTANCE, request, listener);
    }

    @Override
    public void getFieldMappings(GetFieldMappingsRequest request, ActionListener<GetFieldMappingsResponse> listener) {
        this.execute(GetFieldMappingsAction.INSTANCE, request, listener);
    }

    @Override
    public GetMappingsRequestBuilder prepareGetMappings(String ... indices) {
        return new GetMappingsRequestBuilder((IndicesAdminClient)this, indices);
    }

    @Override
    public ActionFuture<GetMappingsResponse> getMappings(GetMappingsRequest request) {
        return this.execute(GetMappingsAction.INSTANCE, request);
    }

    @Override
    public GetFieldMappingsRequestBuilder prepareGetFieldMappings(String ... indices) {
        return new GetFieldMappingsRequestBuilder(this, indices);
    }

    @Override
    public ActionFuture<GetFieldMappingsResponse> getFieldMappings(GetFieldMappingsRequest request) {
        return this.execute(GetFieldMappingsAction.INSTANCE, request);
    }

    @Override
    public ActionFuture<PutMappingResponse> putMapping(PutMappingRequest request) {
        return this.execute(PutMappingAction.INSTANCE, request);
    }

    @Override
    public void putMapping(PutMappingRequest request, ActionListener<PutMappingResponse> listener) {
        this.execute(PutMappingAction.INSTANCE, request, listener);
    }

    @Override
    public PutMappingRequestBuilder preparePutMapping(String ... indices) {
        return new PutMappingRequestBuilder(this).setIndices(indices);
    }

    @Override
    public ActionFuture<DeleteMappingResponse> deleteMapping(DeleteMappingRequest request) {
        return this.execute(DeleteMappingAction.INSTANCE, request);
    }

    @Override
    public void deleteMapping(DeleteMappingRequest request, ActionListener<DeleteMappingResponse> listener) {
        this.execute(DeleteMappingAction.INSTANCE, request, listener);
    }

    @Override
    public DeleteMappingRequestBuilder prepareDeleteMapping(String ... indices) {
        return new DeleteMappingRequestBuilder(this).setIndices(indices);
    }

    @Override
    public ActionFuture<OptimizeResponse> optimize(OptimizeRequest request) {
        return this.execute(OptimizeAction.INSTANCE, request);
    }

    @Override
    public void optimize(OptimizeRequest request, ActionListener<OptimizeResponse> listener) {
        this.execute(OptimizeAction.INSTANCE, request, listener);
    }

    @Override
    public OptimizeRequestBuilder prepareOptimize(String ... indices) {
        return (OptimizeRequestBuilder)new OptimizeRequestBuilder(this).setIndices(indices);
    }

    @Override
    public ActionFuture<RefreshResponse> refresh(RefreshRequest request) {
        return this.execute(RefreshAction.INSTANCE, request);
    }

    @Override
    public void refresh(RefreshRequest request, ActionListener<RefreshResponse> listener) {
        this.execute(RefreshAction.INSTANCE, request, listener);
    }

    @Override
    public RefreshRequestBuilder prepareRefresh(String ... indices) {
        return (RefreshRequestBuilder)new RefreshRequestBuilder(this).setIndices(indices);
    }

    @Override
    public ActionFuture<IndicesStatsResponse> stats(IndicesStatsRequest request) {
        return this.execute(IndicesStatsAction.INSTANCE, request);
    }

    @Override
    public void stats(IndicesStatsRequest request, ActionListener<IndicesStatsResponse> listener) {
        this.execute(IndicesStatsAction.INSTANCE, request, listener);
    }

    @Override
    public IndicesStatsRequestBuilder prepareStats(String ... indices) {
        return (IndicesStatsRequestBuilder)new IndicesStatsRequestBuilder(this).setIndices(indices);
    }

    @Override
    public ActionFuture<IndicesStatusResponse> status(IndicesStatusRequest request) {
        return this.execute(IndicesStatusAction.INSTANCE, request);
    }

    @Override
    public void status(IndicesStatusRequest request, ActionListener<IndicesStatusResponse> listener) {
        this.execute(IndicesStatusAction.INSTANCE, request, listener);
    }

    @Override
    public IndicesStatusRequestBuilder prepareStatus(String ... indices) {
        return new IndicesStatusRequestBuilder(this).setIndices(indices);
    }

    @Override
    public ActionFuture<RecoveryResponse> recoveries(RecoveryRequest request) {
        return this.execute(RecoveryAction.INSTANCE, request);
    }

    @Override
    public void recoveries(RecoveryRequest request, ActionListener<RecoveryResponse> listener) {
        this.execute(RecoveryAction.INSTANCE, request, listener);
    }

    @Override
    public RecoveryRequestBuilder prepareRecoveries(String ... indices) {
        return (RecoveryRequestBuilder)new RecoveryRequestBuilder(this).setIndices(indices);
    }

    @Override
    public ActionFuture<IndicesSegmentResponse> segments(IndicesSegmentsRequest request) {
        return this.execute(IndicesSegmentsAction.INSTANCE, request);
    }

    @Override
    public void segments(IndicesSegmentsRequest request, ActionListener<IndicesSegmentResponse> listener) {
        this.execute(IndicesSegmentsAction.INSTANCE, request, listener);
    }

    @Override
    public IndicesSegmentsRequestBuilder prepareSegments(String ... indices) {
        return (IndicesSegmentsRequestBuilder)new IndicesSegmentsRequestBuilder(this).setIndices(indices);
    }

    @Override
    public ActionFuture<UpdateSettingsResponse> updateSettings(UpdateSettingsRequest request) {
        return this.execute(UpdateSettingsAction.INSTANCE, request);
    }

    @Override
    public void updateSettings(UpdateSettingsRequest request, ActionListener<UpdateSettingsResponse> listener) {
        this.execute(UpdateSettingsAction.INSTANCE, request, listener);
    }

    @Override
    public UpdateSettingsRequestBuilder prepareUpdateSettings(String ... indices) {
        return new UpdateSettingsRequestBuilder(this, new String[0]).setIndices(indices);
    }

    @Override
    public ActionFuture<AnalyzeResponse> analyze(AnalyzeRequest request) {
        return this.execute(AnalyzeAction.INSTANCE, request);
    }

    @Override
    public void analyze(AnalyzeRequest request, ActionListener<AnalyzeResponse> listener) {
        this.execute(AnalyzeAction.INSTANCE, request, listener);
    }

    @Override
    public AnalyzeRequestBuilder prepareAnalyze(@Nullable String index, String text) {
        return new AnalyzeRequestBuilder(this, index, text);
    }

    @Override
    public AnalyzeRequestBuilder prepareAnalyze(String text) {
        return new AnalyzeRequestBuilder(this, null, text);
    }

    @Override
    public ActionFuture<PutIndexTemplateResponse> putTemplate(PutIndexTemplateRequest request) {
        return this.execute(PutIndexTemplateAction.INSTANCE, request);
    }

    @Override
    public void putTemplate(PutIndexTemplateRequest request, ActionListener<PutIndexTemplateResponse> listener) {
        this.execute(PutIndexTemplateAction.INSTANCE, request, listener);
    }

    @Override
    public PutIndexTemplateRequestBuilder preparePutTemplate(String name) {
        return new PutIndexTemplateRequestBuilder(this, name);
    }

    @Override
    public ActionFuture<GetIndexTemplatesResponse> getTemplates(GetIndexTemplatesRequest request) {
        return this.execute(GetIndexTemplatesAction.INSTANCE, request);
    }

    @Override
    public void getTemplates(GetIndexTemplatesRequest request, ActionListener<GetIndexTemplatesResponse> listener) {
        this.execute(GetIndexTemplatesAction.INSTANCE, request, listener);
    }

    @Override
    public GetIndexTemplatesRequestBuilder prepareGetTemplates(String ... names) {
        return new GetIndexTemplatesRequestBuilder(this, names);
    }

    @Override
    public ActionFuture<DeleteIndexTemplateResponse> deleteTemplate(DeleteIndexTemplateRequest request) {
        return this.execute(DeleteIndexTemplateAction.INSTANCE, request);
    }

    @Override
    public void deleteTemplate(DeleteIndexTemplateRequest request, ActionListener<DeleteIndexTemplateResponse> listener) {
        this.execute(DeleteIndexTemplateAction.INSTANCE, request, listener);
    }

    @Override
    public DeleteIndexTemplateRequestBuilder prepareDeleteTemplate(String name) {
        return new DeleteIndexTemplateRequestBuilder(this, name);
    }

    @Override
    public ActionFuture<ValidateQueryResponse> validateQuery(ValidateQueryRequest request) {
        return this.execute(ValidateQueryAction.INSTANCE, request);
    }

    @Override
    public void validateQuery(ValidateQueryRequest request, ActionListener<ValidateQueryResponse> listener) {
        this.execute(ValidateQueryAction.INSTANCE, request, listener);
    }

    @Override
    public ValidateQueryRequestBuilder prepareValidateQuery(String ... indices) {
        return (ValidateQueryRequestBuilder)new ValidateQueryRequestBuilder(this).setIndices(indices);
    }

    @Override
    public ActionFuture<PutWarmerResponse> putWarmer(PutWarmerRequest request) {
        return this.execute(PutWarmerAction.INSTANCE, request);
    }

    @Override
    public void putWarmer(PutWarmerRequest request, ActionListener<PutWarmerResponse> listener) {
        this.execute(PutWarmerAction.INSTANCE, request, listener);
    }

    @Override
    public PutWarmerRequestBuilder preparePutWarmer(String name) {
        return new PutWarmerRequestBuilder(this, name);
    }

    @Override
    public ActionFuture<DeleteWarmerResponse> deleteWarmer(DeleteWarmerRequest request) {
        return this.execute(DeleteWarmerAction.INSTANCE, request);
    }

    @Override
    public void deleteWarmer(DeleteWarmerRequest request, ActionListener<DeleteWarmerResponse> listener) {
        this.execute(DeleteWarmerAction.INSTANCE, request, listener);
    }

    @Override
    public DeleteWarmerRequestBuilder prepareDeleteWarmer() {
        return new DeleteWarmerRequestBuilder(this);
    }

    @Override
    public GetWarmersRequestBuilder prepareGetWarmers(String ... indices) {
        return new GetWarmersRequestBuilder((IndicesAdminClient)this, indices);
    }

    @Override
    public ActionFuture<GetWarmersResponse> getWarmers(GetWarmersRequest request) {
        return this.execute(GetWarmersAction.INSTANCE, request);
    }

    @Override
    public void getWarmers(GetWarmersRequest request, ActionListener<GetWarmersResponse> listener) {
        this.execute(GetWarmersAction.INSTANCE, request, listener);
    }

    @Override
    public GetSettingsRequestBuilder prepareGetSettings(String ... indices) {
        return new GetSettingsRequestBuilder(this, indices);
    }

    @Override
    public ActionFuture<GetSettingsResponse> getSettings(GetSettingsRequest request) {
        return this.execute(GetSettingsAction.INSTANCE, request);
    }

    @Override
    public void getSettings(GetSettingsRequest request, ActionListener<GetSettingsResponse> listener) {
        this.execute(GetSettingsAction.INSTANCE, request, listener);
    }
}

