/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.block;

import java.util.EnumSet;
import org.elasticsearch.ElasticsearchIllegalArgumentException;

public enum ClusterBlockLevel {
    READ(0),
    WRITE(1),
    METADATA(2);

    public static final EnumSet<ClusterBlockLevel> ALL;
    public static final EnumSet<ClusterBlockLevel> READ_WRITE;
    private final int id;

    private ClusterBlockLevel(int id) {
        this.id = id;
    }

    public int id() {
        return this.id;
    }

    public static ClusterBlockLevel fromId(int id) {
        if (id == 0) {
            return READ;
        }
        if (id == 1) {
            return WRITE;
        }
        if (id == 2) {
            return METADATA;
        }
        throw new ElasticsearchIllegalArgumentException("No cluster block level matching [" + id + "]");
    }

    static {
        ALL = EnumSet.of(READ, WRITE, METADATA);
        READ_WRITE = EnumSet.of(READ, WRITE);
    }
}

