/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.settings;

import org.elasticsearch.cluster.routing.allocation.decider.ClusterRebalanceAllocationDecider;
import org.elasticsearch.cluster.settings.ClusterDynamicSettings;
import org.elasticsearch.cluster.settings.DynamicSettings;
import org.elasticsearch.cluster.settings.Validator;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.script.groovy.GroovyScriptEngineService;

public class ClusterDynamicSettingsModule
extends AbstractModule {
    private final DynamicSettings clusterDynamicSettings = new DynamicSettings();

    public ClusterDynamicSettingsModule() {
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.awareness.attributes");
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.awareness.force.*");
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.balance.index", Validator.FLOAT);
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.balance.primary", Validator.FLOAT);
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.balance.shard", Validator.FLOAT);
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.balance.threshold", Validator.NON_NEGATIVE_FLOAT);
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.allow_rebalance", ClusterRebalanceAllocationDecider.ALLOCATION_ALLOW_REBALANCE_VALIDATOR);
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.cluster_concurrent_rebalance", Validator.INTEGER);
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.enable");
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.disable_new_allocation");
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.disable_allocation");
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.disable_replica_allocation");
        this.clusterDynamicSettings.addDynamicSetting("discovery.zen.rejoin_on_master_gone", Validator.BOOLEAN);
        this.clusterDynamicSettings.addDynamicSetting("discovery.zen.no_master_block");
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.include.*");
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.exclude.*");
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.require.*");
        this.clusterDynamicSettings.addDynamicSetting("indices.cache.filter.size");
        this.clusterDynamicSettings.addDynamicSetting("indices.cache.filter.expire", Validator.TIME);
        this.clusterDynamicSettings.addDynamicSetting("indices.cache.filter.concurrency_level", Validator.POSITIVE_INTEGER);
        this.clusterDynamicSettings.addDynamicSetting("indices.store.throttle.type");
        this.clusterDynamicSettings.addDynamicSetting("indices.store.throttle.max_bytes_per_sec", Validator.BYTES_SIZE);
        this.clusterDynamicSettings.addDynamicSetting("indices.ttl.interval", Validator.TIME);
        this.clusterDynamicSettings.addDynamicSetting("indices.mapping.additional_mapping_change_time", Validator.TIME);
        this.clusterDynamicSettings.addDynamicSetting("cluster.blocks.read_only");
        this.clusterDynamicSettings.addDynamicSetting("indices.recovery.file_chunk_size", Validator.BYTES_SIZE);
        this.clusterDynamicSettings.addDynamicSetting("indices.recovery.translog_ops", Validator.INTEGER);
        this.clusterDynamicSettings.addDynamicSetting("indices.recovery.translog_size", Validator.BYTES_SIZE);
        this.clusterDynamicSettings.addDynamicSetting("indices.recovery.compress");
        this.clusterDynamicSettings.addDynamicSetting("indices.recovery.concurrent_streams", Validator.POSITIVE_INTEGER);
        this.clusterDynamicSettings.addDynamicSetting("indices.recovery.concurrent_small_file_streams", Validator.POSITIVE_INTEGER);
        this.clusterDynamicSettings.addDynamicSetting("indices.recovery.max_bytes_per_sec", Validator.BYTES_SIZE);
        this.clusterDynamicSettings.addDynamicSetting("indices.recovery.retry_delay_state_sync", Validator.TIME_NON_NEGATIVE);
        this.clusterDynamicSettings.addDynamicSetting("indices.recovery.retry_delay_network", Validator.TIME_NON_NEGATIVE);
        this.clusterDynamicSettings.addDynamicSetting("indices.recovery.recovery_activity_timeout", Validator.TIME_NON_NEGATIVE);
        this.clusterDynamicSettings.addDynamicSetting("indices.recovery.internal_action_timeout", Validator.TIME_NON_NEGATIVE);
        this.clusterDynamicSettings.addDynamicSetting("indices.recovery.internal_action_long_timeout", Validator.TIME_NON_NEGATIVE);
        this.clusterDynamicSettings.addDynamicSetting("indices.recovery.max_size_per_sec", Validator.BYTES_SIZE);
        this.clusterDynamicSettings.addDynamicSetting("threadpool.*");
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.node_initial_primaries_recoveries", Validator.INTEGER);
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.node_concurrent_recoveries", Validator.INTEGER);
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.disk.watermark.low");
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.disk.watermark.high");
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.disk.threshold_enabled", Validator.BOOLEAN);
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.disk.include_relocations", Validator.BOOLEAN);
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.disk.reroute_interval", Validator.TIME_NON_NEGATIVE);
        this.clusterDynamicSettings.addDynamicSetting("cluster.info.update.interval", Validator.TIME_NON_NEGATIVE);
        this.clusterDynamicSettings.addDynamicSetting("cluster.info.update.timeout", Validator.TIME_NON_NEGATIVE);
        this.clusterDynamicSettings.addDynamicSetting("cluster.routing.allocation.snapshot.relocation_enabled");
        this.clusterDynamicSettings.addDynamicSetting("action.destructive_requires_name");
        this.clusterDynamicSettings.addDynamicSetting("discovery.zen.publish_timeout", Validator.TIME_NON_NEGATIVE);
        this.clusterDynamicSettings.addDynamicSetting("indices.breaker.total.limit", Validator.MEMORY_SIZE);
        this.clusterDynamicSettings.addDynamicSetting("indices.breaker.fielddata.limit", Validator.MEMORY_SIZE);
        this.clusterDynamicSettings.addDynamicSetting("indices.breaker.fielddata.overhead", Validator.NON_NEGATIVE_DOUBLE);
        this.clusterDynamicSettings.addDynamicSetting("indices.breaker.request.limit", Validator.MEMORY_SIZE);
        this.clusterDynamicSettings.addDynamicSetting("indices.breaker.request.overhead", Validator.NON_NEGATIVE_DOUBLE);
        this.clusterDynamicSettings.addDynamicSetting(GroovyScriptEngineService.GROOVY_SCRIPT_BLACKLIST_PATCH);
    }

    public void addDynamicSettings(String ... settings) {
        this.clusterDynamicSettings.addDynamicSettings(settings);
    }

    public void addDynamicSetting(String setting, Validator validator) {
        this.clusterDynamicSettings.addDynamicSetting(setting, validator);
    }

    @Override
    protected void configure() {
        this.bind(DynamicSettings.class).annotatedWith(ClusterDynamicSettings.class).toInstance(this.clusterDynamicSettings);
    }
}

