/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.base.Function;
import org.elasticsearch.common.collect.Collections2;
import org.elasticsearch.common.collect.CopyOnWriteHashMap;
import org.elasticsearch.common.collect.ForwardingSet;
import org.elasticsearch.common.collect.Maps;

public class CopyOnWriteHashSet<T>
extends ForwardingSet<T> {
    private final CopyOnWriteHashMap<T, Boolean> map;

    public static <T> CopyOnWriteHashSet<T> copyOf(Collection<? extends T> set) {
        if (set instanceof CopyOnWriteHashSet) {
            CopyOnWriteHashSet cowSet = (CopyOnWriteHashSet)set;
            return cowSet;
        }
        return new CopyOnWriteHashSet<T>().copyAndAddAll(set);
    }

    public CopyOnWriteHashSet() {
        this(new CopyOnWriteHashMap());
    }

    private CopyOnWriteHashSet(CopyOnWriteHashMap<T, Boolean> map) {
        this.map = map;
    }

    @Override
    protected Set<T> delegate() {
        return this.map.keySet();
    }

    public CopyOnWriteHashSet<T> copyAndAdd(T entry) {
        return new CopyOnWriteHashSet<T>(this.map.copyAndPut(entry, true));
    }

    public CopyOnWriteHashSet<T> copyAndAddAll(Collection<? extends T> entries) {
        Collection asMapEntries = Collections2.transform(entries, new Function<T, Map.Entry<T, Boolean>>(){

            @Override
            public Map.Entry<T, Boolean> apply(T input) {
                return Maps.immutableEntry(input, true);
            }
        });
        CopyOnWriteHashMap<T, Boolean> updated = this.map.copyAndPutAll(asMapEntries);
        return new CopyOnWriteHashSet<T>(updated);
    }

    public CopyOnWriteHashSet<T> copyAndRemove(Object entry) {
        CopyOnWriteHashMap<T, Boolean> updated = this.map.copyAndRemove(entry);
        if (updated == this.map) {
            return this;
        }
        return new CopyOnWriteHashSet<T>(updated);
    }

    public CopyOnWriteHashSet<T> copyAndRemoveAll(Collection<?> entries) {
        CopyOnWriteHashMap<T, Boolean> updated = this.map.copyAndRemoveAll(entries);
        if (updated == this.map) {
            return this;
        }
        return new CopyOnWriteHashSet<T>(updated);
    }
}

