/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.util.Iterator;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.hppc.ObjectIntOpenHashMap;
import org.elasticsearch.common.hppc.ObjectLookupContainer;
import org.elasticsearch.common.hppc.ObjectObjectOpenHashMap;
import org.elasticsearch.common.hppc.cursors.ObjectCursor;

public final class HppcMaps {
    private HppcMaps() {
    }

    public static <K, V> ObjectObjectOpenHashMap<K, V> newMap(int capacity) {
        return new ObjectObjectOpenHashMap(capacity);
    }

    public static <K, V> ObjectObjectOpenHashMap<K, V> newMap() {
        return HppcMaps.newMap(16);
    }

    public static <K, V> ObjectObjectOpenHashMap<K, V> newNoNullKeysMap() {
        return HppcMaps.ensureNoNullKeys(16);
    }

    public static <K, V> ObjectObjectOpenHashMap<K, V> newNoNullKeysMap(int capacity) {
        return HppcMaps.ensureNoNullKeys(capacity);
    }

    public static <K, V> ObjectObjectOpenHashMap<K, V> ensureNoNullKeys(int capacity) {
        return new ObjectObjectOpenHashMap<K, V>(capacity){

            @Override
            public V put(K key, V value) {
                if (key == null) {
                    throw new ElasticsearchIllegalArgumentException("Map key must not be null");
                }
                return super.put(key, value);
            }
        };
    }

    public static <T> Iterable<T> intersection(ObjectLookupContainer<T> container1, final ObjectLookupContainer<T> container2) {
        assert (container1 != null && container2 != null);
        final Iterator iterator = container1.iterator();
        final Iterator intersection = new Iterator<T>(){
            T current;

            @Override
            public boolean hasNext() {
                if (iterator.hasNext()) {
                    do {
                        java.lang.Object next;
                        if (!container2.contains(next = ((ObjectCursor)iterator.next()).value)) continue;
                        this.current = next;
                        return true;
                    } while (iterator.hasNext());
                }
                return false;
            }

            @Override
            public T next() {
                return this.current;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return intersection;
            }
        };
    }

    public static final class Object {

        public static final class Integer {
            public static <V> ObjectIntOpenHashMap<V> ensureNoNullKeys(int capacity, float loadFactor) {
                return new ObjectIntOpenHashMap<V>(capacity, loadFactor){

                    @Override
                    public int put(V key, int value) {
                        if (key == null) {
                            throw new ElasticsearchIllegalArgumentException("Map key must not be null");
                        }
                        return super.put(key, value);
                    }
                };
            }
        }
    }
}

