/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.collect;

import java.util.Comparator;
import java.util.Iterator;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.collect.PeekingIterator;
import org.elasticsearch.common.collect.UnmodifiableIterator;

public enum Iterators2 {


    public static <T> Iterator<T> deduplicateSorted(Iterator<? extends T> iterator, final Comparator<? super T> comparator) {
        final PeekingIterator<? extends T> it = Iterators.peekingIterator(iterator);
        return new UnmodifiableIterator<T>(){

            @Override
            public boolean hasNext() {
                return it.hasNext();
            }

            @Override
            public T next() {
                Object ret = it.next();
                while (it.hasNext() && comparator.compare(ret, it.peek()) == 0) {
                    it.next();
                }
                assert (!it.hasNext() || comparator.compare(ret, it.peek()) < 0) : "iterator is not sorted: " + ret + " > " + it.peek();
                return ret;
            }
        };
    }

    public static <T> Iterator<T> mergeSorted(Iterable<Iterator<? extends T>> iterators, Comparator<? super T> comparator, boolean deduplicate) {
        Iterator<? super T> it = Iterators.mergeSorted(iterators, comparator);
        if (deduplicate) {
            it = Iterators2.deduplicateSorted(it, comparator);
        }
        return it;
    }
}

