/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.jna;

import com.sun.jna.Native;
import java.util.Locale;
import org.apache.lucene.util.Constants;
import org.elasticsearch.common.jna.CLibrary;
import org.elasticsearch.common.jna.Kernel32Library;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;

public class Natives {
    private static ESLogger logger = Loggers.getLogger(Natives.class);
    public static boolean LOCAL_MLOCKALL = false;

    public static void tryMlockall() {
        int errno = Integer.MIN_VALUE;
        try {
            int result = CLibrary.mlockall(1);
            if (result != 0) {
                errno = Native.getLastError();
            } else {
                LOCAL_MLOCKALL = true;
            }
        }
        catch (UnsatisfiedLinkError e) {
            return;
        }
        if (errno != Integer.MIN_VALUE) {
            if (errno == 12 && System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("linux")) {
                logger.warn("Unable to lock JVM memory (ENOMEM). This can result in part of the JVM being swapped out. Increase RLIMIT_MEMLOCK (ulimit).", new Object[0]);
            } else if (!System.getProperty("os.name").toLowerCase(Locale.ROOT).contains("mac")) {
                logger.warn("Unknown mlockall error " + errno, new Object[0]);
            }
        }
    }

    public static void addConsoleCtrlHandler(Kernel32Library.ConsoleCtrlHandler handler) {
        if (Constants.WINDOWS) {
            try {
                boolean result = Kernel32Library.getInstance().addConsoleCtrlHandler(handler);
                if (result) {
                    logger.debug("console ctrl handler correctly set", new Object[0]);
                } else {
                    logger.warn("unknown error " + Native.getLastError() + " when adding console ctrl handler:", new Object[0]);
                }
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                // empty catch block
            }
        }
    }
}

