/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.joda;

import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.elasticsearch.common.joda.time.DateTimeZone;
import org.elasticsearch.common.joda.time.MutableDateTime;
import org.elasticsearch.common.joda.time.format.DateTimeFormatter;

public class DateMathParser {
    private final FormatDateTimeFormatter dateTimeFormatter;
    private final TimeUnit timeUnit;

    public DateMathParser(FormatDateTimeFormatter dateTimeFormatter, TimeUnit timeUnit) {
        this.dateTimeFormatter = dateTimeFormatter;
        this.timeUnit = timeUnit;
    }

    public long parse(String text, Callable<Long> now) {
        return this.parse(text, now, false, null);
    }

    public long parse(String text, Callable<Long> now, boolean roundCeil, DateTimeZone timeZone) {
        String mathString;
        long time;
        if (text.startsWith("now")) {
            try {
                time = now.call();
            }
            catch (Exception e) {
                throw new ElasticsearchParseException("Could not read the current timestamp", e);
            }
            mathString = text.substring("now".length());
        } else {
            String parseString;
            int index = text.indexOf("||");
            if (index == -1) {
                parseString = text;
                mathString = "";
            } else {
                parseString = text.substring(0, index);
                mathString = text.substring(index + 2);
            }
            time = roundCeil ? this.parseRoundCeilStringValue(parseString, timeZone) : this.parseStringValue(parseString, timeZone);
        }
        if (mathString.isEmpty()) {
            return time;
        }
        return this.parseMath(mathString, time, roundCeil, timeZone);
    }

    private long parseMath(String mathString, long time, boolean roundUp, DateTimeZone timeZone) throws ElasticsearchParseException {
        if (timeZone == null) {
            timeZone = DateTimeZone.UTC;
        }
        MutableDateTime dateTime = new MutableDateTime(time, timeZone);
        int i = 0;
        while (i < mathString.length()) {
            int num;
            int sign;
            boolean round;
            char c;
            if ((c = mathString.charAt(i++)) == '/') {
                round = true;
                sign = 1;
            } else {
                round = false;
                if (c == '+') {
                    sign = 1;
                } else if (c == '-') {
                    sign = -1;
                } else {
                    throw new ElasticsearchParseException("operator not supported for date math [" + mathString + "]");
                }
            }
            if (i >= mathString.length()) {
                throw new ElasticsearchParseException("truncated date math [" + mathString + "]");
            }
            if (!Character.isDigit(mathString.charAt(i))) {
                num = 1;
            } else {
                int numFrom = i;
                while (i < mathString.length() && Character.isDigit(mathString.charAt(i))) {
                    ++i;
                }
                if (i >= mathString.length()) {
                    throw new ElasticsearchParseException("truncated date math [" + mathString + "]");
                }
                num = Integer.parseInt(mathString.substring(numFrom, i));
            }
            if (round && num != 1) {
                throw new ElasticsearchParseException("rounding `/` can only be used on single unit types [" + mathString + "]");
            }
            char unit = mathString.charAt(i++);
            MutableDateTime.Property propertyToRound = null;
            switch (unit) {
                case 'y': {
                    if (round) {
                        propertyToRound = dateTime.yearOfCentury();
                        break;
                    }
                    dateTime.addYears(sign * num);
                    break;
                }
                case 'M': {
                    if (round) {
                        propertyToRound = dateTime.monthOfYear();
                        break;
                    }
                    dateTime.addMonths(sign * num);
                    break;
                }
                case 'w': {
                    if (round) {
                        propertyToRound = dateTime.weekOfWeekyear();
                        break;
                    }
                    dateTime.addWeeks(sign * num);
                    break;
                }
                case 'd': {
                    if (round) {
                        propertyToRound = dateTime.dayOfMonth();
                        break;
                    }
                    dateTime.addDays(sign * num);
                    break;
                }
                case 'H': 
                case 'h': {
                    if (round) {
                        propertyToRound = dateTime.hourOfDay();
                        break;
                    }
                    dateTime.addHours(sign * num);
                    break;
                }
                case 'm': {
                    if (round) {
                        propertyToRound = dateTime.minuteOfHour();
                        break;
                    }
                    dateTime.addMinutes(sign * num);
                    break;
                }
                case 's': {
                    if (round) {
                        propertyToRound = dateTime.secondOfMinute();
                        break;
                    }
                    dateTime.addSeconds(sign * num);
                    break;
                }
                default: {
                    throw new ElasticsearchParseException("unit [" + unit + "] not supported for date math [" + mathString + "]");
                }
            }
            if (propertyToRound == null) continue;
            if (roundUp) {
                propertyToRound.roundCeiling();
                dateTime.addMillis(-1);
                continue;
            }
            propertyToRound.roundFloor();
        }
        return dateTime.getMillis();
    }

    public static DateTimeFormatter getDateTimeFormatterParser(FormatDateTimeFormatter dateTimeFormatter, DateTimeZone timeZone) {
        if (dateTimeFormatter == null) {
            return null;
        }
        DateTimeFormatter parser = dateTimeFormatter.parser();
        if (timeZone != null) {
            parser = parser.withZone(timeZone);
        }
        return parser;
    }

    private long parseStringValue(String value, DateTimeZone timeZone) {
        try {
            DateTimeFormatter parser = DateMathParser.getDateTimeFormatterParser(this.dateTimeFormatter, timeZone);
            return parser.parseMillis(value);
        }
        catch (RuntimeException e) {
            try {
                long time = Long.parseLong(value);
                return this.timeUnit.toMillis(time);
            }
            catch (NumberFormatException e1) {
                throw new ElasticsearchParseException("failed to parse date field [" + value + "], tried both date format [" + this.dateTimeFormatter.format() + "], and timestamp number", e);
            }
        }
    }

    private long parseRoundCeilStringValue(String value, DateTimeZone timeZone) {
        try {
            MutableDateTime dateTime = new MutableDateTime(1970, 1, 1, 23, 59, 59, 999, DateTimeZone.UTC);
            DateTimeFormatter parser = DateMathParser.getDateTimeFormatterParser(this.dateTimeFormatter, timeZone);
            int location = parser.parseInto(dateTime, value, 0);
            if (location == value.length()) {
                return dateTime.getMillis();
            }
            if (location <= 0 || dateTime.getYear() > 5000) {
                try {
                    long time = Long.parseLong(value);
                    return this.timeUnit.toMillis(time);
                }
                catch (NumberFormatException e1) {
                    throw new ElasticsearchParseException("failed to parse date field [" + value + "], tried both date format [" + this.dateTimeFormatter.format() + "], and timestamp number");
                }
            }
            return dateTime.getMillis();
        }
        catch (RuntimeException e) {
            try {
                long time = Long.parseLong(value);
                return this.timeUnit.toMillis(time);
            }
            catch (NumberFormatException e1) {
                throw new ElasticsearchParseException("failed to parse date field [" + value + "], tried both date format [" + this.dateTimeFormatter.format() + "], and timestamp number", e);
            }
        }
    }

    public static DateTimeZone parseZone(String text) throws IOException {
        int index = text.indexOf(58);
        if (index != -1) {
            int beginIndex = text.charAt(0) == '+' ? 1 : 0;
            return DateTimeZone.forOffsetHoursMinutes(Integer.parseInt(text.substring(beginIndex, index)), Integer.parseInt(text.substring(index + 1)));
        }
        return DateTimeZone.forID(text);
    }
}

