/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.deletionpolicy;

import org.apache.lucene.index.IndexDeletionPolicy;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.name.Names;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.deletionpolicy.KeepOnlyLastDeletionPolicy;
import org.elasticsearch.index.deletionpolicy.SnapshotDeletionPolicy;

public class DeletionPolicyModule
extends AbstractModule {
    private final Settings settings;

    public DeletionPolicyModule(Settings settings) {
        this.settings = settings;
    }

    @Override
    protected void configure() {
        this.bind(IndexDeletionPolicy.class).annotatedWith(Names.named("actual")).to(this.settings.getAsClass("index.deletionpolicy.type", KeepOnlyLastDeletionPolicy.class)).asEagerSingleton();
        this.bind(SnapshotDeletionPolicy.class).asEagerSingleton();
    }

    public static class DeletionPolicySettings {
        public static final String TYPE = "index.deletionpolicy.type";
    }
}

