/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.network;

import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.monitor.network.NetworkInfo;
import org.elasticsearch.monitor.network.NetworkProbe;
import org.elasticsearch.monitor.network.NetworkStats;
import org.elasticsearch.monitor.sigar.SigarService;
import org.hyperic.sigar.NetFlags;
import org.hyperic.sigar.NetInterfaceConfig;
import org.hyperic.sigar.NetInterfaceStat;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.Tcp;

public class SigarNetworkProbe
extends AbstractComponent
implements NetworkProbe {
    private final SigarService sigarService;

    @Inject
    public SigarNetworkProbe(Settings settings, SigarService sigarService) {
        super(settings);
        this.sigarService = sigarService;
    }

    @Override
    public NetworkInfo networkInfo() {
        Sigar sigar = this.sigarService.sigar();
        NetworkInfo networkInfo = new NetworkInfo();
        try {
            NetInterfaceConfig netInterfaceConfig = sigar.getNetInterfaceConfig(null);
            networkInfo.primary = new NetworkInfo.Interface(netInterfaceConfig.getName(), netInterfaceConfig.getAddress(), netInterfaceConfig.getHwaddr());
        }
        catch (SigarException sigarException) {
            // empty catch block
        }
        return networkInfo;
    }

    @Override
    public synchronized NetworkStats networkStats() {
        Sigar sigar = this.sigarService.sigar();
        NetworkStats stats = new NetworkStats();
        stats.timestamp = System.currentTimeMillis();
        try {
            Tcp tcp = sigar.getTcp();
            stats.tcp = new NetworkStats.Tcp();
            stats.tcp.activeOpens = tcp.getActiveOpens();
            stats.tcp.passiveOpens = tcp.getPassiveOpens();
            stats.tcp.attemptFails = tcp.getAttemptFails();
            stats.tcp.estabResets = tcp.getEstabResets();
            stats.tcp.currEstab = tcp.getCurrEstab();
            stats.tcp.inSegs = tcp.getInSegs();
            stats.tcp.outSegs = tcp.getOutSegs();
            stats.tcp.retransSegs = tcp.getRetransSegs();
            stats.tcp.inErrs = tcp.getInErrs();
            stats.tcp.outRsts = tcp.getOutRsts();
        }
        catch (SigarException sigarException) {
            // empty catch block
        }
        return stats;
    }

    @Override
    public String ifconfig() {
        Sigar sigar = this.sigarService.sigar();
        StringBuilder sb = new StringBuilder();
        try {
            for (String ifname : sigar.getNetInterfaceList()) {
                NetInterfaceConfig ifconfig = null;
                try {
                    ifconfig = sigar.getNetInterfaceConfig(ifname);
                }
                catch (SigarException e) {
                    sb.append(ifname + "\t" + "Not Avaialbe [" + e.getMessage() + "]");
                    continue;
                }
                long flags = ifconfig.getFlags();
                String hwaddr = "";
                if (!"00:00:00:00:00:00".equals(ifconfig.getHwaddr())) {
                    hwaddr = " HWaddr " + ifconfig.getHwaddr();
                }
                if (!ifconfig.getName().equals(ifconfig.getDescription())) {
                    sb.append(ifconfig.getDescription()).append('\n');
                }
                sb.append(ifconfig.getName() + "\t" + "Link encap:" + ifconfig.getType() + hwaddr).append('\n');
                String ptp = "";
                if ((flags & 0x10L) > 0L) {
                    ptp = "  P-t-P:" + ifconfig.getDestination();
                }
                String bcast = "";
                if ((flags & 2L) > 0L) {
                    bcast = "  Bcast:" + ifconfig.getBroadcast();
                }
                sb.append("\tinet addr:" + ifconfig.getAddress() + ptp + bcast + "  Mask:" + ifconfig.getNetmask()).append('\n');
                sb.append("\t" + NetFlags.getIfFlagsString((long)flags) + " MTU:" + ifconfig.getMtu() + "  Metric:" + ifconfig.getMetric()).append('\n');
                try {
                    NetInterfaceStat ifstat = sigar.getNetInterfaceStat(ifname);
                    sb.append("\tRX packets:" + ifstat.getRxPackets() + " errors:" + ifstat.getRxErrors() + " dropped:" + ifstat.getRxDropped() + " overruns:" + ifstat.getRxOverruns() + " frame:" + ifstat.getRxFrame()).append('\n');
                    sb.append("\tTX packets:" + ifstat.getTxPackets() + " errors:" + ifstat.getTxErrors() + " dropped:" + ifstat.getTxDropped() + " overruns:" + ifstat.getTxOverruns() + " carrier:" + ifstat.getTxCarrier()).append('\n');
                    sb.append("\tcollisions:" + ifstat.getTxCollisions()).append('\n');
                    long rxBytes = ifstat.getRxBytes();
                    long txBytes = ifstat.getTxBytes();
                    sb.append("\tRX bytes:" + rxBytes + " (" + Sigar.formatSize((long)rxBytes) + ")" + "  " + "TX bytes:" + txBytes + " (" + Sigar.formatSize((long)txBytes) + ")").append('\n');
                }
                catch (SigarException sigarException) {
                    // empty catch block
                }
            }
            return sb.toString();
        }
        catch (SigarException e) {
            return "NA";
        }
    }
}

