/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.river.cluster;

import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.river.RiverName;

public class RiverNodeHelper {
    public static boolean isRiverNode(DiscoveryNode node) {
        if (node.clientNode()) {
            return false;
        }
        String river = node.attributes().get("river");
        if (river == null) {
            return true;
        }
        return !"_none_".equals(river);
    }

    public static boolean isRiverNode(DiscoveryNode node, RiverName riverName) {
        if (!RiverNodeHelper.isRiverNode(node)) {
            return false;
        }
        String river = node.attributes().get("river");
        return river == null || river.contains(riverName.type()) || river.contains(riverName.name());
    }
}

