/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.range;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.collect.Lists;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.ValuesSourceAggregationBuilder;
import org.elasticsearch.search.builder.SearchSourceBuilderException;

public abstract class AbstractRangeBuilder<B extends AbstractRangeBuilder<B>>
extends ValuesSourceAggregationBuilder<B> {
    protected List<Range> ranges = Lists.newArrayList();

    protected AbstractRangeBuilder(String name, String type) {
        super(name, type);
    }

    @Override
    protected XContentBuilder doInternalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.ranges.isEmpty()) {
            throw new SearchSourceBuilderException("at least one range must be defined for range aggregation [" + this.getName() + "]");
        }
        builder.startArray("ranges");
        for (Range range : this.ranges) {
            range.toXContent(builder, params);
        }
        return builder.endArray();
    }

    protected static class Range
    implements ToXContent {
        private String key;
        private Object from;
        private Object to;

        public Range(String key, Object from, Object to) {
            this.key = key;
            this.from = from;
            this.to = to;
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.key != null) {
                builder.field("key", this.key);
            }
            if (this.from != null) {
                builder.field("from", this.from);
            }
            if (this.to != null) {
                builder.field("to", this.to);
            }
            return builder.endObject();
        }
    }
}

