/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.facet.terms.longs;

import java.io.IOException;
import java.util.Arrays;
import java.util.Set;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.cache.recycler.CacheRecycler;
import org.elasticsearch.common.collect.BoundedTreeSet;
import org.elasticsearch.common.collect.ImmutableList;
import org.elasticsearch.common.collect.ImmutableSet;
import org.elasticsearch.common.hppc.LongIntOpenHashMap;
import org.elasticsearch.common.hppc.LongOpenHashSet;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.script.SearchScript;
import org.elasticsearch.search.facet.FacetExecutor;
import org.elasticsearch.search.facet.InternalFacet;
import org.elasticsearch.search.facet.LongFacetAggregatorBase;
import org.elasticsearch.search.facet.terms.TermsFacet;
import org.elasticsearch.search.facet.terms.longs.InternalLongTermsFacet;
import org.elasticsearch.search.facet.terms.support.EntryPriorityQueue;
import org.elasticsearch.search.internal.SearchContext;

public class TermsLongFacetExecutor
extends FacetExecutor {
    private final IndexNumericFieldData indexFieldData;
    private final TermsFacet.ComparatorType comparatorType;
    private final int shardSize;
    private final int size;
    private final SearchScript script;
    private final ImmutableSet<BytesRef> excluded;
    final Recycler.V<LongIntOpenHashMap> facets;
    long missing;
    long total;

    public TermsLongFacetExecutor(IndexNumericFieldData indexFieldData, int size, int shardSize, TermsFacet.ComparatorType comparatorType, boolean allTerms, SearchContext context, ImmutableSet<BytesRef> excluded, SearchScript script, CacheRecycler cacheRecycler) {
        this.indexFieldData = indexFieldData;
        this.size = size;
        this.shardSize = shardSize;
        this.comparatorType = comparatorType;
        this.script = script;
        this.excluded = excluded;
        this.facets = cacheRecycler.longIntMap(-1);
        if (allTerms) {
            for (AtomicReaderContext readerContext : context.searcher().getTopReaderContext().leaves()) {
                int maxDoc = readerContext.reader().maxDoc();
                SortedNumericDocValues values = ((AtomicNumericFieldData)indexFieldData.load(readerContext)).getLongValues();
                for (int docId = 0; docId < maxDoc; ++docId) {
                    values.setDocument(docId);
                    int numValues = values.count();
                    LongIntOpenHashMap v = this.facets.v();
                    for (int i = 0; i < numValues; ++i) {
                        v.putIfAbsent(values.valueAt(i), 0);
                    }
                }
            }
        }
    }

    @Override
    public Collector collector() {
        return new Collector();
    }

    @Override
    public InternalFacet buildFacet(String facetName) {
        if (this.facets.v().isEmpty()) {
            this.facets.close();
            return new InternalLongTermsFacet(facetName, this.comparatorType, this.size, ImmutableList.of(), this.missing, this.total);
        }
        LongIntOpenHashMap facetEntries = this.facets.v();
        boolean[] states = this.facets.v().allocated;
        long[] keys = this.facets.v().keys;
        int[] values = this.facets.v().values;
        if (this.size < 5000) {
            EntryPriorityQueue ordered = new EntryPriorityQueue(this.shardSize, this.comparatorType.comparator());
            for (int i = 0; i < states.length; ++i) {
                if (!states[i]) continue;
                ordered.insertWithOverflow(new InternalLongTermsFacet.LongEntry(keys[i], values[i]));
            }
            InternalLongTermsFacet.LongEntry[] list = new InternalLongTermsFacet.LongEntry[ordered.size()];
            for (int i = ordered.size() - 1; i >= 0; --i) {
                list[i] = (InternalLongTermsFacet.LongEntry)ordered.pop();
            }
            this.facets.close();
            return new InternalLongTermsFacet(facetName, this.comparatorType, this.size, Arrays.asList(list), this.missing, this.total);
        }
        BoundedTreeSet<TermsFacet.Entry> ordered = new BoundedTreeSet<TermsFacet.Entry>(this.comparatorType.comparator(), this.shardSize);
        for (int i = 0; i < states.length; ++i) {
            if (!states[i]) continue;
            ordered.add(new InternalLongTermsFacet.LongEntry(keys[i], values[i]));
        }
        this.facets.close();
        return new InternalLongTermsFacet(facetName, this.comparatorType, this.size, ordered, this.missing, this.total);
    }

    public static class StaticAggregatorValueProc
    extends LongFacetAggregatorBase {
        private final LongIntOpenHashMap facets;

        public StaticAggregatorValueProc(LongIntOpenHashMap facets) {
            this.facets = facets;
        }

        @Override
        public void onValue(int docId, long value) {
            this.facets.addTo(value, 1);
        }

        public final LongIntOpenHashMap facets() {
            return this.facets;
        }
    }

    public static class AggregatorValueProc
    extends StaticAggregatorValueProc {
        private final SearchScript script;
        private final LongOpenHashSet excluded;

        public AggregatorValueProc(LongIntOpenHashMap facets, Set<BytesRef> excluded, SearchScript script) {
            super(facets);
            this.script = script;
            if (excluded == null || excluded.isEmpty()) {
                this.excluded = null;
            } else {
                this.excluded = new LongOpenHashSet(excluded.size());
                for (BytesRef s : excluded) {
                    this.excluded.add(Long.parseLong(s.utf8ToString()));
                }
            }
        }

        @Override
        public void onValue(int docId, long value) {
            if (this.excluded != null && this.excluded.contains(value)) {
                return;
            }
            if (this.script != null) {
                this.script.setNextDocId(docId);
                this.script.setNextVar("term", value);
                Object scriptValue = this.script.run();
                if (scriptValue == null) {
                    return;
                }
                if (scriptValue instanceof Boolean) {
                    if (!((Boolean)scriptValue).booleanValue()) {
                        return;
                    }
                } else {
                    value = ((Number)scriptValue).longValue();
                }
            }
            super.onValue(docId, value);
        }
    }

    class Collector
    extends FacetExecutor.Collector {
        private final StaticAggregatorValueProc aggregator;
        private SortedNumericDocValues values;

        public Collector() {
            this.aggregator = TermsLongFacetExecutor.this.script == null && TermsLongFacetExecutor.this.excluded.isEmpty() ? new StaticAggregatorValueProc(TermsLongFacetExecutor.this.facets.v()) : new AggregatorValueProc(TermsLongFacetExecutor.this.facets.v(), TermsLongFacetExecutor.this.excluded, TermsLongFacetExecutor.this.script);
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            if (TermsLongFacetExecutor.this.script != null) {
                TermsLongFacetExecutor.this.script.setScorer(scorer);
            }
        }

        public void setNextReader(AtomicReaderContext context) throws IOException {
            this.values = ((AtomicNumericFieldData)TermsLongFacetExecutor.this.indexFieldData.load(context)).getLongValues();
            if (TermsLongFacetExecutor.this.script != null) {
                TermsLongFacetExecutor.this.script.setNextReader(context);
            }
        }

        public void collect(int doc) throws IOException {
            this.aggregator.onDoc(doc, this.values);
        }

        @Override
        public void postCollection() {
            TermsLongFacetExecutor.this.missing = this.aggregator.missing();
            TermsLongFacetExecutor.this.total = this.aggregator.total();
        }
    }
}

