/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.local.LocalTransport;
import org.elasticsearch.transport.netty.NettyTransport;

public class TransportModule
extends AbstractModule {
    public static final String TRANSPORT_TYPE_KEY = "transport.type";
    public static final String TRANSPORT_SERVICE_TYPE_KEY = "transport.service.type";
    private final ESLogger logger;
    private final Settings settings;
    private Class<? extends TransportService> configuredTransportService;
    private Class<? extends Transport> configuredTransport;
    private String configuredTransportServiceSource;
    private String configuredTransportSource;

    public TransportModule(Settings settings) {
        this.settings = settings;
        this.logger = Loggers.getLogger(this.getClass(), settings, new String[0]);
    }

    @Override
    protected void configure() {
        if (this.configuredTransportService != null) {
            this.logger.info("Using [{}] as transport service, overridden by [{}]", this.configuredTransportService.getName(), this.configuredTransportServiceSource);
            this.bind(TransportService.class).to(this.configuredTransportService).asEagerSingleton();
        } else {
            Class<TransportService> defaultTransportService = TransportService.class;
            Class<TransportService> transportService = this.settings.getAsClass(TRANSPORT_SERVICE_TYPE_KEY, defaultTransportService, "org.elasticsearch.transport.", "TransportService");
            if (!TransportService.class.equals(transportService)) {
                this.bind(TransportService.class).to(transportService).asEagerSingleton();
            } else {
                this.bind(TransportService.class).asEagerSingleton();
            }
        }
        if (this.configuredTransport != null) {
            this.logger.info("Using [{}] as transport, overridden by [{}]", this.configuredTransport.getName(), this.configuredTransportSource);
            this.bind(Transport.class).to(this.configuredTransport).asEagerSingleton();
        } else {
            Class defaultTransport = DiscoveryNode.localNode(this.settings) ? LocalTransport.class : NettyTransport.class;
            Class<LocalTransport> transport = this.settings.getAsClass(TRANSPORT_TYPE_KEY, defaultTransport, "org.elasticsearch.transport.", "Transport");
            this.bind(Transport.class).to(transport).asEagerSingleton();
        }
    }

    public void setTransportService(Class<? extends TransportService> transportService, String source) {
        Preconditions.checkNotNull(transportService, "Configured transport service may not be null");
        Preconditions.checkNotNull(source, "Plugin, that changes transport service may not be null");
        this.configuredTransportService = transportService;
        this.configuredTransportServiceSource = source;
    }

    public void setTransport(Class<? extends Transport> transport, String source) {
        Preconditions.checkNotNull(transport, "Configured transport may not be null");
        Preconditions.checkNotNull(source, "Plugin, that changes transport may not be null");
        this.configuredTransport = transport;
        this.configuredTransportSource = source;
    }
}

