/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.services;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.automation.core.util.Paginable;
import org.nuxeo.ecm.automation.core.util.Properties;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.platform.audit.api.AuditPageProvider;
import org.nuxeo.ecm.platform.audit.api.LogEntry;
import org.nuxeo.ecm.platform.audit.api.LogEntryList;
import org.nuxeo.ecm.platform.query.api.PageProvider;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.core.GenericPageProviderDescriptor;

@Operation(id="Audit.QueryWithPageProvider", category="Fetch", label="Audit Query With Page Provider", description="Perform a query or a named provider query against Audit logs. Result is paginated. The query result will become the input for the next operation. If no query or provider name is given, a query based on default Audit page provider will be executed.", addToStudio=false, aliases={"Audit.PageProvider"})
public class AuditPageProviderOperation {
    public static final String ID = "Audit.QueryWithPageProvider";
    public static final String CURRENT_USERID_PATTERN = "$currentUser";
    public static final String CURRENT_REPO_PATTERN = "$currentRepository";
    private static final String SORT_PARAMETER_SEPARATOR = " ";
    public static final String DESC = "DESC";
    public static final String ASC = "ASC";
    @Context
    protected OperationContext context;
    @Context
    protected CoreSession session;
    @Context
    protected PageProviderService ppService;
    @Param(name="providerName", required=false)
    protected String providerName;
    @Param(name="query", required=false)
    protected String query;
    @Param(name="language", required=false, widget="Option", values={"NXQL"})
    protected String lang = "NXQL";
    @Param(name="page", required=false)
    @Deprecated
    protected Integer page;
    @Param(name="currentPageIndex", required=false)
    protected Integer currentPageIndex;
    @Param(name="pageSize", required=false)
    protected Integer pageSize;
    @Deprecated
    @Param(name="sortInfo", required=false)
    protected StringList sortInfoAsStringList;
    @Param(name="queryParams", required=false)
    protected StringList strParameters;
    @Param(name="namedQueryParams", required=false)
    protected Properties namedQueryParams;
    @Deprecated
    @Param(name="maxResults", required=false)
    protected Integer maxResults = 100;
    @Param(name="sortBy", required=false, description="Sort by properties (separated by comma)")
    protected String sortBy;
    @Param(name="sortOrder", required=false, description="Sort order, ASC or DESC", widget="Option", values={"ASC", "DESC"})
    protected String sortOrder;

    @OperationMethod
    public Paginable<LogEntry> run() throws IOException {
        ArrayList<SortInfo> sortInfos = null;
        if (this.sortInfoAsStringList != null) {
            sortInfos = new ArrayList<SortInfo>();
            for (String sortInfoDesc : this.sortInfoAsStringList) {
                SortInfo sortInfo;
                if (sortInfoDesc.contains(SORT_PARAMETER_SEPARATOR)) {
                    String[] parts = sortInfoDesc.split(SORT_PARAMETER_SEPARATOR);
                    sortInfo = new SortInfo(parts[0], Boolean.parseBoolean(parts[1]));
                } else {
                    sortInfo = new SortInfo(sortInfoDesc, true);
                }
                sortInfos.add(sortInfo);
            }
        } else if (!StringUtils.isBlank((String)this.sortBy)) {
            sortInfos = new ArrayList();
            String[] sorts = this.sortBy.split(",");
            String[] orders = null;
            if (!StringUtils.isBlank((String)this.sortOrder)) {
                orders = this.sortOrder.split(",");
            }
            for (int i = 0; i < sorts.length; ++i) {
                String sort = sorts[i];
                boolean sortAscending = orders != null && orders.length > i && "asc".equals(orders[i].toLowerCase());
                sortInfos.add(new SortInfo(sort, sortAscending));
            }
        }
        Object[] parameters = null;
        if (this.strParameters != null && !this.strParameters.isEmpty()) {
            parameters = this.strParameters.toArray((Object[])new String[this.strParameters.size()]);
            for (int idx = 0; idx < parameters.length; ++idx) {
                String value = (String)parameters[idx];
                if (value.equals(CURRENT_USERID_PATTERN)) {
                    parameters[idx] = this.session.getPrincipal().getName();
                    continue;
                }
                if (!value.equals(CURRENT_REPO_PATTERN)) continue;
                parameters[idx] = this.session.getRepositoryName();
            }
        }
        if (parameters == null) {
            parameters = new Object[]{};
        }
        HashMap<String, Serializable> props = new HashMap<String, Serializable>();
        props.put("coreSession", (Serializable)this.session);
        if (this.query == null && (this.providerName == null || this.providerName.length() == 0)) {
            this.providerName = "AUDIT_BROWSER";
        }
        Long targetPage = null;
        if (this.page != null) {
            targetPage = this.page.longValue();
        }
        if (this.currentPageIndex != null) {
            targetPage = this.currentPageIndex.longValue();
        }
        Long targetPageSize = null;
        if (this.pageSize != null) {
            targetPageSize = this.pageSize.longValue();
        }
        if (this.query != null) {
            AuditPageProvider app = new AuditPageProvider();
            app.setProperties(props);
            GenericPageProviderDescriptor desc = new GenericPageProviderDescriptor();
            desc.setPattern(this.query);
            app.setParameters(parameters);
            app.setDefinition((PageProviderDefinition)desc);
            app.setSortInfos(sortInfos);
            app.setPageSize(targetPageSize.longValue());
            app.setCurrentPage(targetPage.longValue());
            return new LogEntryList((PageProvider)app);
        }
        DocumentModel searchDoc = null;
        if (this.namedQueryParams != null && this.namedQueryParams.size() > 0) {
            String docType = this.ppService.getPageProviderDefinition(this.providerName).getWhereClause().getDocType();
            searchDoc = this.session.createDocumentModel(docType);
            DocumentHelper.setProperties((CoreSession)this.session, (DocumentModel)searchDoc, (Properties)this.namedQueryParams);
        }
        PageProvider pp = this.ppService.getPageProvider(this.providerName, searchDoc, sortInfos, targetPageSize, targetPage, props, parameters);
        return new LogEntryList(pp);
    }
}

