/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.el;

import java.io.Serializable;
import java.util.List;
import javax.el.BeanELResolver;
import javax.el.ELContext;
import javax.el.PropertyNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ArrayProperty;
import org.nuxeo.ecm.core.api.model.impl.ComplexProperty;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.platform.el.DocumentPropertyContext;
import org.nuxeo.ecm.platform.el.FieldAdapterManager;

public class DocumentModelResolver
extends BeanELResolver {
    private static final Log log = LogFactory.getLog(DocumentModelResolver.class);

    public Class<?> getType(ELContext context, Object base, Object property) {
        Class<List> type = null;
        if (base instanceof DocumentModel) {
            try {
                type = super.getType(context, base, property);
            }
            catch (PropertyNotFoundException e) {
                type = DocumentPropertyContext.class;
                context.setPropertyResolved(true);
            }
        } else if (base instanceof DocumentPropertyContext || base instanceof Property) {
            type = Object.class;
            if (base instanceof DocumentPropertyContext) {
                DocumentPropertyContext ctx = (DocumentPropertyContext)base;
                try {
                    Property docProperty = DocumentModelResolver.getDocumentProperty(ctx, property);
                    if (docProperty.isContainer()) {
                        Property subProperty = DocumentModelResolver.getDocumentProperty(docProperty, property);
                        if (subProperty.isList()) {
                            type = List.class;
                        }
                    } else if (docProperty instanceof ArrayProperty) {
                        type = List.class;
                    }
                }
                catch (PropertyException pe) {
                    log.warn((Object)pe.toString());
                }
            } else if (base instanceof Property) {
                try {
                    Property docProperty = (Property)base;
                    Property subProperty = DocumentModelResolver.getDocumentProperty(docProperty, property);
                    if (subProperty.isList()) {
                        type = List.class;
                    }
                }
                catch (PropertyException pe) {
                    try {
                        type = super.getType(context, base, property);
                    }
                    catch (PropertyNotFoundException e) {
                        log.warn((Object)pe.toString());
                    }
                }
            }
            context.setPropertyResolved(true);
        }
        return type;
    }

    public Object getValue(ELContext context, Object base, Object property) {
        Object value = null;
        if (base instanceof DocumentModel) {
            try {
                value = super.getValue(context, base, property);
            }
            catch (PropertyNotFoundException e) {
                value = new DocumentPropertyContext((DocumentModel)base, (String)property);
                context.setPropertyResolved(true);
            }
        } else if (base instanceof DocumentPropertyContext) {
            try {
                DocumentPropertyContext ctx = (DocumentPropertyContext)base;
                Property docProperty = DocumentModelResolver.getDocumentProperty(ctx, property);
                value = DocumentModelResolver.getDocumentPropertyValue(docProperty);
            }
            catch (PropertyException pe) {
                log.warn((Object)pe.toString());
            }
            context.setPropertyResolved(true);
        } else if (base instanceof Property) {
            try {
                Property docProperty = (Property)base;
                Property subProperty = DocumentModelResolver.getDocumentProperty(docProperty, property);
                value = DocumentModelResolver.getDocumentPropertyValue(subProperty);
            }
            catch (PropertyException pe) {
                try {
                    value = super.getValue(context, base, property);
                }
                catch (PropertyNotFoundException e) {
                    log.warn((Object)pe.toString());
                }
            }
            context.setPropertyResolved(true);
        }
        return value;
    }

    private static String getDocumentPropertyName(DocumentPropertyContext ctx, Object propertyValue) {
        return ctx.schema + ":" + propertyValue;
    }

    private static Property getDocumentProperty(DocumentPropertyContext ctx, Object propertyValue) throws PropertyException {
        return ctx.doc.getProperty(DocumentModelResolver.getDocumentPropertyName(ctx, propertyValue));
    }

    private static Property getDocumentProperty(Property docProperty, Object propertyValue) throws PropertyException {
        Property subProperty = null;
        if ((docProperty instanceof ArrayProperty || docProperty instanceof ListProperty) && propertyValue instanceof Long) {
            subProperty = docProperty.get(((Long)propertyValue).intValue());
        } else if ((docProperty instanceof ArrayProperty || docProperty instanceof ListProperty) && propertyValue instanceof Integer) {
            Integer idx = (Integer)propertyValue;
            if (idx < docProperty.size()) {
                subProperty = docProperty.get(((Integer)propertyValue).intValue());
            }
        } else if (docProperty instanceof ComplexProperty && propertyValue instanceof String) {
            subProperty = docProperty.get((String)propertyValue);
        }
        if (subProperty == null) {
            throw new PropertyException(String.format("Could not resolve subproperty '%s' under '%s'", propertyValue, docProperty.getPath()));
        }
        return subProperty;
    }

    private static Object getDocumentPropertyValue(Property docProperty) throws PropertyException {
        if (docProperty == null) {
            throw new PropertyException("Null property");
        }
        Object value = docProperty;
        if (!docProperty.isContainer()) {
            value = docProperty.getValue();
            value = FieldAdapterManager.getValueForDisplay(value);
        }
        return value;
    }

    public boolean isReadOnly(ELContext context, Object base, Object property) {
        boolean readOnly;
        block3: {
            readOnly = false;
            try {
                readOnly = super.isReadOnly(context, base, property);
            }
            catch (PropertyNotFoundException e) {
                if (base instanceof DocumentModel || base instanceof DocumentPropertyContext) {
                    readOnly = false;
                    context.setPropertyResolved(true);
                }
                if (!(base instanceof Property)) break block3;
                readOnly = ((Property)base).isReadOnly();
                context.setPropertyResolved(true);
            }
        }
        return readOnly;
    }

    public void setValue(ELContext context, Object base, Object property, Object value) {
        if (base instanceof DocumentModel) {
            try {
                super.setValue(context, base, property, value);
            }
            catch (PropertyNotFoundException propertyNotFoundException) {}
        } else if (base instanceof DocumentPropertyContext) {
            DocumentPropertyContext ctx = (DocumentPropertyContext)base;
            value = FieldAdapterManager.getValueForStorage(value);
            try {
                ctx.doc.setPropertyValue(DocumentModelResolver.getDocumentPropertyName(ctx, property), (Serializable)value);
            }
            catch (PropertyException e) {
                log.warn((Object)e.toString());
            }
            context.setPropertyResolved(true);
        } else if (base instanceof Property) {
            try {
                Property docProperty = (Property)base;
                Property subProperty = DocumentModelResolver.getDocumentProperty(docProperty, property);
                value = FieldAdapterManager.getValueForStorage(value);
                subProperty.setValue(value);
            }
            catch (PropertyException pe) {
                try {
                    super.setValue(context, base, property, value);
                }
                catch (PropertyNotFoundException e) {
                    log.warn((Object)pe.toString());
                }
            }
            context.setPropertyResolved(true);
        }
    }
}

