/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.audit.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.platform.audit.api.AuditLogger;
import org.nuxeo.runtime.api.Framework;

public class AuditEventLogger
implements PostCommitFilteringEventListener {
    private static final Log log = LogFactory.getLog(AuditEventLogger.class);

    public boolean acceptEvent(Event event) {
        AuditLogger logger = (AuditLogger)Framework.getLocalService(AuditLogger.class);
        if (logger == null) {
            return false;
        }
        return logger.getAuditableEventNames().contains(event.getName());
    }

    public void handleEvent(EventBundle events) {
        AuditLogger logger = (AuditLogger)Framework.getLocalService(AuditLogger.class);
        if (logger != null) {
            logger.logEvents(events);
        } else {
            log.error((Object)"Can not reach AuditLogger");
        }
    }
}

