/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.group.processor;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.cache.CacheStrategy;
import ro.isdc.wro.cache.factory.CacheKeyFactory;
import ro.isdc.wro.config.Context;
import ro.isdc.wro.config.ReadOnlyContext;
import ro.isdc.wro.config.jmx.WroConfiguration;
import ro.isdc.wro.config.metadata.MetaDataFactory;
import ro.isdc.wro.manager.ResourceBundleProcessor;
import ro.isdc.wro.manager.WroManager;
import ro.isdc.wro.manager.callback.LifecycleCallbackRegistry;
import ro.isdc.wro.manager.factory.SimpleWroManagerFactory;
import ro.isdc.wro.manager.factory.WroManagerFactory;
import ro.isdc.wro.model.factory.WroModelFactory;
import ro.isdc.wro.model.group.GroupExtractor;
import ro.isdc.wro.model.group.processor.GroupsProcessor;
import ro.isdc.wro.model.group.processor.Injector;
import ro.isdc.wro.model.group.processor.PreProcessorExecutor;
import ro.isdc.wro.model.resource.locator.factory.InjectableUriLocatorFactoryDecorator;
import ro.isdc.wro.model.resource.locator.factory.UriLocatorFactory;
import ro.isdc.wro.model.resource.locator.support.DispatcherStreamLocator;
import ro.isdc.wro.model.resource.processor.factory.ProcessorsFactory;
import ro.isdc.wro.model.resource.support.ResourceAuthorizationManager;
import ro.isdc.wro.model.resource.support.change.ResourceChangeDetector;
import ro.isdc.wro.model.resource.support.change.ResourceWatcher;
import ro.isdc.wro.model.resource.support.hash.HashStrategy;
import ro.isdc.wro.model.resource.support.naming.NamingStrategy;
import ro.isdc.wro.util.ObjectFactory;
import ro.isdc.wro.util.ProxyFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InjectorBuilder {
    private static final Logger LOG = LoggerFactory.getLogger(InjectorBuilder.class);
    private final GroupsProcessor groupsProcessor = new GroupsProcessor();
    private final PreProcessorExecutor preProcessorExecutor = new PreProcessorExecutor();
    private final ResourceChangeDetector resourceChangeDetector = new ResourceChangeDetector();
    private final ResourceBundleProcessor bundleProcessor = new ResourceBundleProcessor();
    private ResourceWatcher resourceWatcher = new ResourceWatcher();
    private DispatcherStreamLocator dispatcherLocator = new DispatcherStreamLocator();
    private Injector injector;
    private final Map<Class<?>, Object> map = new HashMap();
    private WroManagerFactory managerFactory;

    public InjectorBuilder() {
    }

    public static InjectorBuilder create(WroManagerFactory managerFactory) {
        return new InjectorBuilder(managerFactory);
    }

    public static InjectorBuilder create(WroManager manager) {
        return new InjectorBuilder(new SimpleWroManagerFactory(manager));
    }

    public InjectorBuilder(WroManagerFactory managerFactory) {
        Validate.notNull((Object)managerFactory);
        this.managerFactory = managerFactory;
    }

    private void initMap() {
        this.map.put(PreProcessorExecutor.class, this.createPreProcessorExecutorProxy());
        this.map.put(GroupsProcessor.class, this.createGroupsProcessorProxy());
        this.map.put(LifecycleCallbackRegistry.class, this.createCallbackRegistryProxy());
        this.map.put(GroupExtractor.class, this.createGroupExtractorProxy());
        this.map.put(Injector.class, this.createInjectorProxy());
        this.map.put(UriLocatorFactory.class, this.createLocatorFactoryProxy());
        this.map.put(ProcessorsFactory.class, this.createProcessorFactoryProxy());
        this.map.put(WroModelFactory.class, this.createModelFactoryProxy());
        this.map.put(NamingStrategy.class, this.createNamingStrategyProxy());
        this.map.put(HashStrategy.class, this.createHashStrategyProxy());
        this.map.put(ReadOnlyContext.class, this.createReadOnlyContextProxy());
        this.map.put(WroConfiguration.class, this.createConfigProxy());
        this.map.put(CacheStrategy.class, this.createCacheStrategyProxy());
        this.map.put(ResourceAuthorizationManager.class, this.createResourceAuthorizationManagerProxy());
        this.map.put(MetaDataFactory.class, this.createMetaDataFactoryProxy());
        this.map.put(ResourceBundleProcessor.class, this.createResourceBundleProcessorProxy());
        this.map.put(CacheKeyFactory.class, this.createCacheKeyFactoryProxy());
        this.map.put(ResourceChangeDetector.class, this.createResourceChangeDetectorProxy());
        this.map.put(ResourceWatcher.class, this.createResourceWatcherProxy());
        this.map.put(DispatcherStreamLocator.class, this.createDispatcherLocatorProxy());
    }

    private Object createDispatcherLocatorProxy() {
        return new InjectorObjectFactory<DispatcherStreamLocator>(){

            @Override
            public DispatcherStreamLocator create() {
                InjectorBuilder.this.dispatcherLocator.setTimeout(Context.get().getConfig().getConnectionTimeout());
                return InjectorBuilder.this.dispatcherLocator;
            }
        };
    }

    private Object createResourceBundleProcessorProxy() {
        return new InjectorObjectFactory<ResourceBundleProcessor>(){

            @Override
            public ResourceBundleProcessor create() {
                return InjectorBuilder.this.bundleProcessor;
            }
        };
    }

    private Object createMetaDataFactoryProxy() {
        return new InjectorObjectFactory<MetaDataFactory>(){

            @Override
            public MetaDataFactory create() {
                return ((WroManager)InjectorBuilder.this.managerFactory.create()).getMetaDataFactory();
            }
        };
    }

    private InjectorObjectFactory<WroConfiguration> createConfigProxy() {
        return new InjectorObjectFactory<WroConfiguration>(){

            @Override
            public WroConfiguration create() {
                LOG.warn("Do not @Inject WroConfiguration. Prefer using @Inject ReadOnlyContext context; (and context.getConfig()).");
                return Context.get().getConfig();
            }
        };
    }

    private InjectorObjectFactory<PreProcessorExecutor> createPreProcessorExecutorProxy() {
        return new InjectorObjectFactory<PreProcessorExecutor>(){

            @Override
            public PreProcessorExecutor create() {
                return InjectorBuilder.this.preProcessorExecutor;
            }
        };
    }

    private InjectorObjectFactory<GroupsProcessor> createGroupsProcessorProxy() {
        return new InjectorObjectFactory<GroupsProcessor>(){

            @Override
            public GroupsProcessor create() {
                return InjectorBuilder.this.groupsProcessor;
            }
        };
    }

    private InjectorObjectFactory<LifecycleCallbackRegistry> createCallbackRegistryProxy() {
        return new InjectorObjectFactory<LifecycleCallbackRegistry>(){

            @Override
            public LifecycleCallbackRegistry create() {
                return ((WroManager)InjectorBuilder.this.managerFactory.create()).getCallbackRegistry();
            }
        };
    }

    private InjectorObjectFactory<Injector> createInjectorProxy() {
        return new InjectorObjectFactory<Injector>(){

            @Override
            public Injector create() {
                Validate.isTrue((InjectorBuilder.this.injector != null ? 1 : 0) != 0);
                return InjectorBuilder.this.injector;
            }
        };
    }

    private Object createGroupExtractorProxy() {
        return new InjectorObjectFactory<GroupExtractor>(){

            @Override
            public GroupExtractor create() {
                return ((WroManager)InjectorBuilder.this.managerFactory.create()).getGroupExtractor();
            }
        };
    }

    private Object createProcessorFactoryProxy() {
        return new InjectorObjectFactory<ProcessorsFactory>(){

            @Override
            public ProcessorsFactory create() {
                return ((WroManager)InjectorBuilder.this.managerFactory.create()).getProcessorsFactory();
            }
        };
    }

    private Object createLocatorFactoryProxy() {
        return new InjectorObjectFactory<UriLocatorFactory>(){

            @Override
            public UriLocatorFactory create() {
                return new InjectableUriLocatorFactoryDecorator(((WroManager)InjectorBuilder.this.managerFactory.create()).getUriLocatorFactory());
            }
        };
    }

    private Object createResourceAuthorizationManagerProxy() {
        return new InjectorObjectFactory<ResourceAuthorizationManager>(){

            @Override
            public ResourceAuthorizationManager create() {
                return ((WroManager)InjectorBuilder.this.managerFactory.create()).getResourceAuthorizationManager();
            }
        };
    }

    private Object createModelFactoryProxy() {
        return new InjectorObjectFactory<WroModelFactory>(){

            @Override
            public WroModelFactory create() {
                return ((WroManager)InjectorBuilder.this.managerFactory.create()).getModelFactory();
            }
        };
    }

    private Object createNamingStrategyProxy() {
        return new InjectorObjectFactory<NamingStrategy>(){

            @Override
            public NamingStrategy create() {
                return ((WroManager)InjectorBuilder.this.managerFactory.create()).getNamingStrategy();
            }
        };
    }

    private Object createHashStrategyProxy() {
        return new InjectorObjectFactory<HashStrategy>(){

            @Override
            public HashStrategy create() {
                return ((WroManager)InjectorBuilder.this.managerFactory.create()).getHashStrategy();
            }
        };
    }

    private Object createCacheStrategyProxy() {
        return new InjectorObjectFactory<CacheStrategy>(){

            @Override
            public CacheStrategy create() {
                return ((WroManager)InjectorBuilder.this.managerFactory.create()).getCacheStrategy();
            }
        };
    }

    private Object createReadOnlyContextProxy() {
        return ProxyFactory.proxy(new ProxyFactory.TypedObjectFactory<ReadOnlyContext>(){

            @Override
            public ReadOnlyContext create() {
                return Context.get();
            }

            @Override
            public Class<? extends ReadOnlyContext> getObjectClass() {
                return Context.class;
            }
        }, ReadOnlyContext.class);
    }

    private Object createCacheKeyFactoryProxy() {
        return new InjectorObjectFactory<CacheKeyFactory>(){

            @Override
            public CacheKeyFactory create() {
                return ((WroManager)InjectorBuilder.this.managerFactory.create()).getCacheKeyFactory();
            }
        };
    }

    private Object createResourceChangeDetectorProxy() {
        return new InjectorObjectFactory<ResourceChangeDetector>(){

            @Override
            public ResourceChangeDetector create() {
                return InjectorBuilder.this.resourceChangeDetector;
            }
        };
    }

    private Object createResourceWatcherProxy() {
        return new InjectorObjectFactory<ResourceWatcher>(){

            @Override
            public ResourceWatcher create() {
                return InjectorBuilder.this.resourceWatcher;
            }
        };
    }

    public InjectorBuilder setResourceWatcher(ResourceWatcher resourceWatcher) {
        Validate.notNull((Object)resourceWatcher);
        this.resourceWatcher = resourceWatcher;
        return this;
    }

    public InjectorBuilder setDispatcherLocator(DispatcherStreamLocator dispatcherLocator) {
        Validate.notNull((Object)dispatcherLocator);
        this.dispatcherLocator = dispatcherLocator;
        return this;
    }

    public Injector build() {
        this.initMap();
        this.injector = new Injector(Collections.unmodifiableMap(this.map));
        return this.injector;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface InjectorObjectFactory<T>
    extends ObjectFactory<T> {
    }
}

