/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.picture.api.adapters;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.Blobs;
import org.nuxeo.ecm.core.api.PropertyException;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.blobholder.SimpleBlobHolder;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.platform.picture.api.ImageInfo;
import org.nuxeo.ecm.platform.picture.api.ImagingService;
import org.nuxeo.ecm.platform.picture.api.PictureConversion;
import org.nuxeo.ecm.platform.picture.api.PictureView;
import org.nuxeo.ecm.platform.picture.api.adapters.AbstractPictureAdapter;
import org.nuxeo.runtime.api.Framework;

public class DefaultPictureAdapter
extends AbstractPictureAdapter {
    private static final Log log = LogFactory.getLog(DefaultPictureAdapter.class);
    private static final String VIEW_XPATH = "picture:views/item[%d]/";
    private static final String TITLE_PROPERTY = "title";
    private static final String FILENAME_PROPERTY = "filename";

    @Override
    public boolean createPicture(Blob blob, String filename, String title, ArrayList<Map<String, Object>> pictureConversions) throws IOException {
        return this.fillPictureViews(blob, filename, title, pictureConversions);
    }

    @Override
    public boolean fillPictureViews(Blob blob, String filename, String title, ArrayList<Map<String, Object>> pictureConversions) throws IOException {
        if (blob == null) {
            this.clearViews();
            return true;
        }
        File file = blob.getFile();
        if (file == null) {
            file = File.createTempFile("nuxeoImage", ".jpg");
            Framework.trackFile((File)file, (Object)this);
            blob.transferTo(file);
            String digest = blob.getDigest();
            blob = Blobs.createBlob((File)file, (String)blob.getMimeType(), (String)blob.getEncoding(), (String)blob.getFilename());
            blob.setDigest(digest);
        }
        this.fileContent = blob;
        this.type = blob.getMimeType();
        if (this.type == null || this.type.equals("application/octet-stream")) {
            this.type = this.getImagingService().getImageMimeType(file);
            blob.setMimeType(this.type);
        }
        if (this.type == null || this.type.equals("application/octet-stream")) {
            return false;
        }
        ImageInfo imageInfo = this.getImageInfo();
        if (imageInfo != null) {
            this.doc.setPropertyValue("picture:info", (Serializable)((Object)imageInfo.toMap()));
        }
        if (imageInfo != null) {
            this.width = imageInfo.getWidth();
            this.height = imageInfo.getHeight();
            this.depth = imageInfo.getDepth();
        }
        if (this.width != null && this.height != null) {
            this.clearViews();
            this.addViews(pictureConversions, filename, title);
        }
        return true;
    }

    @Override
    public void preFillPictureViews(Blob blob, List<Map<String, Object>> pictureConversions, ImageInfo imageInfo) throws IOException {
        List<PictureView> pictureViews;
        ImagingService imagingService = this.getImagingService();
        if (pictureConversions != null) {
            ArrayList<PictureConversion> conversions = new ArrayList<PictureConversion>(pictureConversions.size());
            for (Map<String, Object> template : pictureConversions) {
                conversions.add(new PictureConversion((String)template.get(TITLE_PROPERTY), (String)template.get("description"), (String)template.get("tag"), 0));
            }
            pictureViews = imagingService.computeViewsFor(blob, conversions, imageInfo, false);
        } else {
            pictureViews = imagingService.computeViewsFor(this.doc, blob, imageInfo, false);
        }
        this.addPictureViews(pictureViews, true);
    }

    @Override
    public void doRotate(int angle) {
        int size = this.doc.getProperty("picture:views").size();
        for (int i = 0; i < size; ++i) {
            String xpath = "picture:views/view[" + i + "]/";
            SimpleBlobHolder blob = new SimpleBlobHolder((Blob)this.doc.getProperty(xpath + "content").getValue(Blob.class));
            String type = blob.getBlob().getMimeType();
            if (type == "image/png") continue;
            HashMap<String, Integer> options = new HashMap<String, Integer>();
            options.put("angle", angle);
            blob = this.getConversionService().convert("pictureRotation", (BlobHolder)blob, options);
            this.doc.getProperty(xpath + "content").setValue((Object)blob.getBlob());
            Long height = (Long)this.doc.getProperty(xpath + "height").getValue();
            Long width = (Long)this.doc.getProperty(xpath + "width").getValue();
            this.doc.getProperty(xpath + "height").setValue((Object)width);
            this.doc.getProperty(xpath + "width").setValue((Object)height);
        }
    }

    @Override
    public void doCrop(String coords) {
        this.doc.setPropertyValue("picture:cropCoords", (Serializable)((Object)coords));
    }

    @Override
    public Blob getPictureFromTitle(String title) throws PropertyException {
        if (title == null) {
            return null;
        }
        Collection views = this.doc.getProperty("picture:views").getChildren();
        for (Property property : views) {
            if (!title.equals(property.getValue(TITLE_PROPERTY))) continue;
            Blob blob = (Blob)property.getValue("content");
            if (blob != null) {
                blob.setFilename((String)((Object)property.getValue(FILENAME_PROPERTY)));
            }
            return blob;
        }
        return null;
    }

    @Override
    public String getFirstViewXPath() {
        return this.getViewXPathFor(0);
    }

    @Override
    public String getViewXPath(String viewName) {
        Property views = this.doc.getProperty("picture:views");
        for (int i = 0; i < views.size(); ++i) {
            if (!views.get(i).getValue(TITLE_PROPERTY).equals(viewName)) continue;
            return this.getViewXPathFor(i);
        }
        return null;
    }

    protected String getViewXPathFor(int index) {
        return String.format(VIEW_XPATH, index);
    }
}

