/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.tokenauth.service;

import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.directory.BaseSession;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.tokenauth.TokenAuthenticationException;
import org.nuxeo.ecm.tokenauth.service.TokenAuthenticationService;
import org.nuxeo.runtime.api.Framework;

public class TokenAuthenticationServiceImpl
implements TokenAuthenticationService {
    private static final long serialVersionUID = 35041039370298705L;
    private static final Log log = LogFactory.getLog(TokenAuthenticationServiceImpl.class);
    protected static final String DIRECTORY_NAME = "authTokens";
    protected static final String DIRECTORY_SCHEMA = "authtoken";
    protected static final String USERNAME_FIELD = "userName";
    protected static final String TOKEN_FIELD = "token";
    protected static final String APPLICATION_NAME_FIELD = "applicationName";
    protected static final String DEVICE_ID_FIELD = "deviceId";
    protected static final String DEVICE_DESCRIPTION_FIELD = "deviceDescription";
    protected static final String PERMISSION_FIELD = "permission";
    protected static final String CREATION_DATE_FIELD = "creationDate";

    /*
     * Loose catch block
     */
    @Override
    public String acquireToken(String userName, String applicationName, String deviceId, String deviceDescription, String permission) throws TokenAuthenticationException {
        LoginContext lc;
        String token = this.getToken(userName, applicationName, deviceId);
        if (token != null) {
            return token;
        }
        if (StringUtils.isEmpty((String)permission)) {
            throw new TokenAuthenticationException("The permission parameter is mandatory to acquire an authentication token.");
        }
        try {
            lc = Framework.login();
        }
        catch (LoginException e) {
            throw new NuxeoException("Cannot log in as system user", (Throwable)e);
        }
        try {
            try (Session session = ((DirectoryService)Framework.getService(DirectoryService.class)).open(DIRECTORY_NAME);){
                UUID uuid = UUID.randomUUID();
                token = uuid.toString();
                DocumentModel entry = this.getBareAuthTokenModel((DirectoryService)Framework.getService(DirectoryService.class));
                entry.setProperty(DIRECTORY_SCHEMA, TOKEN_FIELD, (Object)token);
                entry.setProperty(DIRECTORY_SCHEMA, USERNAME_FIELD, (Object)userName);
                entry.setProperty(DIRECTORY_SCHEMA, APPLICATION_NAME_FIELD, (Object)applicationName);
                entry.setProperty(DIRECTORY_SCHEMA, DEVICE_ID_FIELD, (Object)deviceId);
                if (!StringUtils.isEmpty((String)deviceDescription)) {
                    entry.setProperty(DIRECTORY_SCHEMA, DEVICE_DESCRIPTION_FIELD, (Object)deviceDescription);
                }
                entry.setProperty(DIRECTORY_SCHEMA, PERMISSION_FIELD, (Object)permission);
                Calendar creationDate = Calendar.getInstance();
                creationDate.setTimeInMillis(System.currentTimeMillis());
                entry.setProperty(DIRECTORY_SCHEMA, CREATION_DATE_FIELD, (Object)creationDate);
                session.createEntry(entry);
                log.debug((Object)String.format("Generated unique token for the (userName, applicationName, deviceId) triplet: ('%s', '%s', '%s'), returning it.", userName, applicationName, deviceId));
                String string = token;
                return string;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                if (lc != null) {
                    lc.logout();
                }
            }
            catch (LoginException e) {
                throw new NuxeoException("Cannot log out system user", (Throwable)e);
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public String getToken(String userName, String applicationName, String deviceId) throws TokenAuthenticationException {
        LoginContext lc;
        if (StringUtils.isEmpty((String)userName) || StringUtils.isEmpty((String)applicationName) || StringUtils.isEmpty((String)deviceId)) {
            throw new TokenAuthenticationException("The following parameters are mandatory to get an authentication token: userName, applicationName, deviceId.");
        }
        try {
            lc = Framework.login();
        }
        catch (LoginException e) {
            throw new NuxeoException("Cannot log in as system user", (Throwable)e);
        }
        try {
            String string;
            try (Session session = ((DirectoryService)Framework.getService(DirectoryService.class)).open(DIRECTORY_NAME);){
                HashMap<String, String> filter = new HashMap<String, String>();
                filter.put(USERNAME_FIELD, userName);
                filter.put(APPLICATION_NAME_FIELD, applicationName);
                filter.put(DEVICE_ID_FIELD, deviceId);
                DocumentModelList tokens = session.query(filter);
                if (!tokens.isEmpty()) {
                    if (tokens.size() > 1) {
                        throw new NuxeoException(String.format("Found multiple tokens for the (userName, applicationName, deviceId) triplet: ('%s', '%s', '%s'), this is inconsistent.", userName, applicationName, deviceId));
                    }
                    log.debug((Object)String.format("Found token for the (userName, applicationName, deviceId) triplet: ('%s', '%s', '%s'), returning it.", userName, applicationName, deviceId));
                    DocumentModel tokenModel = (DocumentModel)tokens.get(0);
                    String string2 = tokenModel.getId();
                    return string2;
                }
                log.debug((Object)String.format("No token found for the (userName, applicationName, deviceId) triplet: ('%s', '%s', '%s'), returning null.", userName, applicationName, deviceId));
                string = null;
            }
            return string;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                if (lc != null) {
                    lc.logout();
                }
            }
            catch (LoginException e) {
                throw new NuxeoException("Cannot log out system user", (Throwable)e);
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public String getUserName(String token) {
        LoginContext lc;
        try {
            lc = Framework.login();
        }
        catch (LoginException e) {
            throw new NuxeoException("Cannot log in as system user", (Throwable)e);
        }
        try {
            String string;
            try (Session session = ((DirectoryService)Framework.getService(DirectoryService.class)).open(DIRECTORY_NAME);){
                DocumentModel entry = session.getEntry(token);
                if (entry == null) {
                    log.debug((Object)String.format("Found no user name bound to the token: '%s', returning null.", token));
                    String string2 = null;
                    return string2;
                }
                log.debug((Object)String.format("Found a user name bound to the token: '%s', returning it.", token));
                string = (String)entry.getProperty(DIRECTORY_SCHEMA, USERNAME_FIELD);
            }
            return string;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                if (lc != null) {
                    lc.logout();
                }
            }
            catch (LoginException e) {
                throw new NuxeoException("Cannot log out system user", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revokeToken(String token) {
        LoginContext lc;
        try {
            lc = Framework.login();
        }
        catch (LoginException e) {
            throw new NuxeoException("Cannot log in as system user", (Throwable)e);
        }
        try (Session session = ((DirectoryService)Framework.getService(DirectoryService.class)).open(DIRECTORY_NAME);){
            session.deleteEntry(token);
            log.info((Object)String.format("Deleted token: '%s' from the back-end.", token));
        }
        finally {
            try {
                if (lc != null) {
                    lc.logout();
                }
            }
            catch (LoginException e) {
                throw new NuxeoException("Cannot log out system user", (Throwable)e);
            }
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public DocumentModelList getTokenBindings(String userName) {
        LoginContext lc;
        try {
            lc = Framework.login();
        }
        catch (LoginException e) {
            throw new NuxeoException("Cannot log in as system user", (Throwable)e);
        }
        try {
            try (Session session = ((DirectoryService)Framework.getService(DirectoryService.class)).open(DIRECTORY_NAME);){
                HashMap<String, String> filter = new HashMap<String, String>();
                filter.put(USERNAME_FIELD, userName);
                HashMap<String, String> orderBy = new HashMap<String, String>();
                orderBy.put(CREATION_DATE_FIELD, "desc");
                DocumentModelList documentModelList = session.query(filter, Collections.emptySet(), orderBy);
                return documentModelList;
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                if (lc != null) {
                    lc.logout();
                }
            }
            catch (LoginException e) {
                throw new NuxeoException("Cannot log out system user", (Throwable)e);
            }
        }
    }

    protected DocumentModel getBareAuthTokenModel(DirectoryService directoryService) {
        String directorySchema = directoryService.getDirectorySchema(DIRECTORY_NAME);
        return BaseSession.createEntryModel(null, (String)directorySchema, null, null);
    }
}

