/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.faces;

import java.io.Serializable;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.contexts.Contexts;
import org.jboss.seam.core.Init;
import org.jboss.seam.core.Manager;
import org.jboss.seam.pageflow.Pageflow;
import org.jboss.seam.web.Session;

@Name(value="org.jboss.seam.faces.facesPage")
@BypassInterceptors
@Install(precedence=0, classDependencies={"javax.faces.context.FacesContext"})
@Scope(value=ScopeType.PAGE)
public class FacesPage
implements Serializable {
    private static final long serialVersionUID = 4807114041808347239L;
    private String pageflowName;
    private Integer pageflowCounter;
    private String pageflowNodeName;
    private String conversationId;
    private boolean conversationIsLongRunning;

    public String getConversationId() {
        return this.conversationId;
    }

    public void discardTemporaryConversation() {
        this.conversationId = null;
        this.conversationIsLongRunning = false;
    }

    public void discardNestedConversation(String outerConversationId) {
        this.conversationId = outerConversationId;
        this.conversationIsLongRunning = true;
    }

    public void storeConversation(String conversationId) {
        this.conversationId = conversationId;
        this.conversationIsLongRunning = true;
    }

    public void storePageflow() {
        if (Init.instance().isJbpmInstalled()) {
            Pageflow pageflow = Pageflow.instance();
            if (pageflow.isInProcess() && Manager.instance().isLongRunningConversation()) {
                this.pageflowName = pageflow.getSubProcessInstance().getProcessDefinition().getName();
                this.pageflowNodeName = pageflow.getNode().getName();
                this.pageflowCounter = pageflow.getPageflowCounter();
            } else {
                this.pageflowName = null;
                this.pageflowNodeName = null;
                this.pageflowCounter = null;
            }
        }
    }

    public static FacesPage instance() {
        if (!Contexts.isPageContextActive()) {
            throw new IllegalStateException("No page context active");
        }
        return (FacesPage)Component.getInstance(FacesPage.class, ScopeType.PAGE);
    }

    public boolean isConversationLongRunning() {
        return this.conversationIsLongRunning;
    }

    public Integer getPageflowCounter() {
        return this.pageflowCounter;
    }

    public String getPageflowName() {
        return this.pageflowName;
    }

    public String getPageflowNodeName() {
        return this.pageflowNodeName;
    }

    public void storeConversation() {
        boolean sessionInvalid;
        Manager manager = Manager.instance();
        Session session = Session.getInstance();
        boolean bl = sessionInvalid = session != null && session.isInvalid();
        if (!sessionInvalid && manager.isLongRunningConversation()) {
            this.storeConversation(manager.getCurrentConversationId());
        } else if (!sessionInvalid && manager.isNestedConversation()) {
            this.discardNestedConversation(manager.getParentConversationId());
        } else {
            this.discardTemporaryConversation();
        }
    }
}

