/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.routing;

import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.core.api.DocumentRoutingEngineService;
import org.nuxeo.ecm.platform.routing.core.impl.jsongraph.JsonGraphRoute;
import org.nuxeo.ecm.restapi.server.jaxrs.routing.model.WorkflowRequest;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.ecm.webengine.model.impl.DefaultObject;
import org.nuxeo.runtime.api.Framework;

@WebObject(type="workflow")
@Produces(value={"application/json"})
public class WorkflowObject
extends DefaultObject {
    private static Log log = LogFactory.getLog(WorkflowObject.class);
    private DocumentRoutingService documentRoutingService;

    protected void initialize(Object ... args) {
        this.documentRoutingService = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
    }

    @POST
    @Consumes(value={"application/json", "application/json+nxentity"})
    @Produces(value={"application/json"})
    public Response createWorkflowInstance(WorkflowRequest workflowRequest) {
        String workflowInstanceId = this.documentRoutingService.createNewInstance(workflowRequest.getWorkflowModelName(), workflowRequest.getAttachedDocumentIds(), this.ctx.getCoreSession(), true);
        DocumentModel workflowInstance = this.getContext().getCoreSession().getDocument((DocumentRef)new IdRef(workflowInstanceId));
        DocumentRoute route = (DocumentRoute)workflowInstance.getAdapter(DocumentRoute.class);
        return Response.ok((Object)route).status(Response.Status.CREATED).build();
    }

    @GET
    @Path(value="{workflowInstanceId}")
    public DocumentRoute getWorkflowInstance(@PathParam(value="workflowInstanceId") String workflowInstanceId) {
        try {
            DocumentModel workflowInstance = this.getContext().getCoreSession().getDocument((DocumentRef)new IdRef(workflowInstanceId));
            return (DocumentRoute)workflowInstance.getAdapter(DocumentRoute.class);
        }
        catch (NuxeoException e) {
            e.addInfo("Can not get workflow instance with id: " + workflowInstanceId);
            throw e;
        }
    }

    @GET
    @Path(value="{workflowInstanceId}/graph")
    public JsonGraphRoute getWorkflowGraph(@PathParam(value="workflowInstanceId") String workflowInstanceId) {
        try {
            return new JsonGraphRoute(this.getContext().getCoreSession(), workflowInstanceId, this.getContext().getLocale());
        }
        catch (NuxeoException e) {
            e.addInfo("Can not get workflow instance graph with id: " + workflowInstanceId);
            throw e;
        }
    }

    @DELETE
    @Path(value="{workflowInstanceId}")
    public Response cancelWorkflowInstance(@PathParam(value="workflowInstanceId") String workflowInstanceId) {
        DocumentRoute route;
        try {
            DocumentModel workflowInstance = this.getContext().getCoreSession().getDocument((DocumentRef)new IdRef(workflowInstanceId));
            route = (DocumentRoute)workflowInstance.getAdapter(DocumentRoute.class);
            this.checkCancelGuards(route);
        }
        catch (NuxeoException e) {
            e.addInfo("Can not get workflow instance with id: " + workflowInstanceId);
            throw e;
        }
        ((DocumentRoutingEngineService)Framework.getService(DocumentRoutingEngineService.class)).cancel(route, this.getContext().getCoreSession());
        return Response.ok().status(Response.Status.NO_CONTENT).build();
    }

    protected void checkCancelGuards(DocumentRoute route) {
        NuxeoPrincipal currentUser = (NuxeoPrincipal)this.getContext().getCoreSession().getPrincipal();
        if (currentUser.isAdministrator() || currentUser.isMemberOf("powerusers")) {
            return;
        }
        try {
            if (currentUser.getName().equals(route.getInitiator())) {
                return;
            }
            throw new WebSecurityException("You don't have the permission to cancel this workflow");
        }
        catch (NuxeoException e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @GET
    public List<DocumentRoute> getRunningWorkflowInstancesLaunchedByCurrentUser(@QueryParam(value="workflowModelName") String worflowModelName) {
        return this.documentRoutingService.getRunningWorkflowInstancesLaunchedByCurrentUser(this.getContext().getCoreSession(), worflowModelName);
    }
}

