/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.routing.io;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.nuxeo.ecm.automation.jaxrs.io.EntityListWriter;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.restapi.server.jaxrs.routing.io.DocumentRouteWriter;

@Provider
@Produces(value={"application/json+nxentity", "application/json"})
public class DocumentRouteListWriter
extends EntityListWriter<DocumentRoute> {
    private static final Log log = LogFactory.getLog(DocumentRouteListWriter.class);
    @Context
    JsonFactory factory;
    @Context
    protected HttpHeaders headers;
    @Context
    protected HttpServletRequest request;
    @Context
    UriInfo uriInfo;

    protected String getEntityType() {
        return "workflows";
    }

    protected void writeItem(JsonGenerator jg, DocumentRoute item) throws IOException {
    }

    public void writeTo(List<DocumentRoute> docRoutes, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        try {
            JsonGenerator jg = this.factory.createJsonGenerator(entityStream, JsonEncoding.UTF8);
            jg.writeStartObject();
            jg.writeStringField("entity-type", "worflows");
            jg.writeArrayFieldStart("entries");
            for (DocumentRoute docRoute : docRoutes) {
                jg.writeStartObject();
                jg.writeStringField("entity-type", "workflow");
                DocumentRouteWriter.writeDocumentRoute(jg, docRoute, this.request, this.uriInfo);
                jg.writeEndObject();
            }
            jg.writeEndArray();
            jg.writeEndObject();
            jg.flush();
        }
        catch (IOException e) {
            log.error((Object)"Failed to serialize document route list", (Throwable)e);
            throw new WebApplicationException(500);
        }
    }
}

