/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.routing.io;

import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;
import javax.el.ELContext;
import javax.el.ExpressionFactory;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.jboss.el.ExpressionFactoryImpl;
import org.nuxeo.ecm.automation.jaxrs.io.EntityWriter;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.nuxeo.ecm.platform.actions.ActionContext;
import org.nuxeo.ecm.platform.actions.ELActionContext;
import org.nuxeo.ecm.platform.actions.ejb.ActionManager;
import org.nuxeo.ecm.platform.el.ExpressionContext;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRoute;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskComment;
import org.nuxeo.ecm.restapi.server.jaxrs.routing.io.NodeAccessRunner;
import org.nuxeo.ecm.restapi.server.jaxrs.routing.io.util.JsonEncodeDecodeUtils;
import org.nuxeo.ecm.webengine.jaxrs.session.SessionFactory;
import org.nuxeo.runtime.api.Framework;

@Provider
@Produces(value={"application/json", "application/json+nxentity"})
public class TaskWriter
extends EntityWriter<Task> {
    public static final String ENTITY_TYPE = "task";
    @Context
    HttpServletRequest request;
    @Context
    UriInfo uriInfo;

    protected void writeEntityBody(JsonGenerator jg, Task item) throws IOException {
        TaskWriter.writeTask(jg, item, this.request, this.uriInfo);
    }

    public static void writeTask(JsonGenerator jg, Task item, HttpServletRequest request, UriInfo uriInfo) throws JsonGenerationException, IOException {
        CoreSession session = null;
        GraphRoute workflowInstance = null;
        GraphNode node = null;
        String workflowInstanceId = item.getProcessId();
        String nodeId = item.getVariable("nodeId");
        if (request != null) {
            session = SessionFactory.getSession((HttpServletRequest)request);
        }
        if (session != null && StringUtils.isNotBlank((String)workflowInstanceId)) {
            NodeAccessRunner nodeAccessRunner = new NodeAccessRunner(session, workflowInstanceId, nodeId);
            nodeAccessRunner.runUnrestricted();
            workflowInstance = nodeAccessRunner.workflowInstance;
            node = nodeAccessRunner.node;
        }
        jg.writeStringField("id", item.getDocument().getId());
        jg.writeStringField("name", item.getName());
        jg.writeStringField("workflowInstanceId", workflowInstanceId);
        if (workflowInstance != null) {
            jg.writeStringField("workflowModelName", workflowInstance.getModelName());
        }
        jg.writeStringField("state", item.getDocument().getCurrentLifeCycleState());
        jg.writeStringField("directive", item.getDirective());
        jg.writeStringField("created", DateParser.formatW3CDateTime((Date)item.getCreated()));
        jg.writeStringField("dueDate", DateParser.formatW3CDateTime((Date)item.getDueDate()));
        jg.writeStringField("nodeName", item.getVariable("nodeId"));
        jg.writeArrayFieldStart("targetDocumentIds");
        for (String string : item.getTargetDocumentsIds()) {
            jg.writeStartObject();
            jg.writeStringField("id", string);
            jg.writeEndObject();
        }
        jg.writeEndArray();
        jg.writeArrayFieldStart("actors");
        for (String string : item.getActors()) {
            jg.writeStartObject();
            jg.writeStringField("id", string);
            jg.writeEndObject();
        }
        jg.writeEndArray();
        jg.writeArrayFieldStart("comments");
        for (TaskComment taskComment : item.getComments()) {
            jg.writeStartObject();
            jg.writeStringField("author", taskComment.getAuthor());
            jg.writeStringField("text", taskComment.getText());
            jg.writeStringField("date", DateParser.formatW3CDateTime((Date)taskComment.getCreationDate().getTime()));
            jg.writeEndObject();
        }
        jg.writeEndArray();
        jg.writeFieldName("variables");
        jg.writeStartObject();
        for (Map.Entry entry : node.getVariables().entrySet()) {
            JsonEncodeDecodeUtils.encodeVariableEntry(node.getDocument(), "rnode:variablesFacet", entry, jg, request);
        }
        if (workflowInstance != null) {
            String transientSchemaName = "var_global_" + node.getId();
            SchemaManager schemaManager = (SchemaManager)Framework.getService(SchemaManager.class);
            Schema transientSchema = schemaManager.getSchema(transientSchemaName);
            for (Map.Entry<String, Serializable> entry : workflowInstance.getVariables().entrySet()) {
                if (transientSchema != null && !transientSchema.hasField((String)entry.getKey())) continue;
                JsonEncodeDecodeUtils.encodeVariableEntry(workflowInstance.getDocument(), "docri:variablesFacet", entry, jg, request);
            }
        }
        jg.writeEndObject();
        if (session != null) {
            jg.writeFieldName("taskInfo");
            jg.writeStartObject();
            ActionManager actionManager = (ActionManager)Framework.getService(ActionManager.class);
            jg.writeArrayFieldStart("taskActions");
            for (GraphNode.Button button : node.getTaskButtons()) {
                if (!StringUtils.isBlank((String)button.getFilter()) && !actionManager.checkFilter(button.getFilter(), TaskWriter.createActionContext(session))) continue;
                jg.writeStartObject();
                jg.writeStringField("name", button.getName());
                jg.writeStringField("url", uriInfo.getBaseUri() + "api/v1/task" + item.getDocument().getId() + "/" + button.getName());
                jg.writeStringField("label", button.getLabel());
                jg.writeEndObject();
            }
            jg.writeEndArray();
            jg.writeFieldName("layoutResource");
            jg.writeStartObject();
            jg.writeStringField("name", node.getTaskLayout());
            jg.writeStringField("url", uriInfo.getBaseUri() + "/layout-manager/layouts/?layoutName=" + node.getTaskLayout());
            jg.writeEndObject();
            jg.writeArrayFieldStart("schemas");
            for (String string : node.getDocument().getSchemas()) {
                jg.writeStartObject();
                jg.writeStringField("name", string);
                jg.writeStringField("url", uriInfo.getBaseUri() + "api/v1/config/schemas/" + string);
                jg.writeEndObject();
            }
            jg.writeEndArray();
            jg.writeEndObject();
        }
    }

    protected static ActionContext createActionContext(CoreSession session) {
        ELActionContext actionContext = new ELActionContext((ELContext)new ExpressionContext(), (ExpressionFactory)new ExpressionFactoryImpl());
        actionContext.setDocumentManager(session);
        actionContext.setCurrentPrincipal((NuxeoPrincipal)session.getPrincipal());
        return actionContext;
    }

    protected String getEntityType() {
        return ENTITY_TYPE;
    }
}

