/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.packages;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.nuxeo.connect.data.DownloadablePackage;
import org.nuxeo.connect.packages.PackageSource;
import org.nuxeo.connect.update.PackageType;

public abstract class AbstractPackageSource
implements PackageSource {
    protected String id;
    protected String name;

    @Override
    public List<DownloadablePackage> listPackages(PackageType type) {
        List<DownloadablePackage> all = this.listPackages();
        if (type == null) {
            return all;
        }
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        for (DownloadablePackage pkg : all) {
            if (!type.equals((Object)pkg.getType())) continue;
            result.add(pkg);
        }
        return result;
    }

    @Override
    public void flushCache() {
    }

    @Override
    public Collection<? extends DownloadablePackage> listPackagesByName(String packageName) {
        ArrayList<DownloadablePackage> result = new ArrayList<DownloadablePackage>();
        for (DownloadablePackage pkg : this.listPackages()) {
            if (!packageName.equals(pkg.getName())) continue;
            result.add(pkg);
        }
        return result;
    }

    @Override
    public List<DownloadablePackage> listStudioPackages() {
        return this.listPackages(PackageType.STUDIO);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }
}

