/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.aggregate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.TermsFilterBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsBuilder;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.query.api.AggregateDefinition;
import org.nuxeo.ecm.platform.query.core.BucketTerm;
import org.nuxeo.elasticsearch.aggregate.AggregateEsBase;

public class TermAggregate
extends AggregateEsBase<BucketTerm> {
    public TermAggregate(AggregateDefinition definition, DocumentModel searchDocument) {
        super(definition, searchDocument);
    }

    @JsonIgnore
    public TermsBuilder getEsAggregate() {
        TermsBuilder ret = (TermsBuilder)AggregationBuilders.terms((String)this.getId()).field(this.getField());
        Map props = this.getProperties();
        if (props.containsKey("size")) {
            ret.size(Integer.parseInt((String)props.get("size")));
        }
        if (props.containsKey("minDocCount")) {
            ret.minDocCount(Long.parseLong((String)props.get("minDocCount")));
        }
        if (props.containsKey("exclude")) {
            ret.exclude((String)props.get("exclude"));
        }
        if (props.containsKey("include")) {
            ret.include((String)props.get("include"));
        }
        if (props.containsKey("order")) {
            switch (((String)props.get("order")).toLowerCase()) {
                case "count desc": {
                    ret.order(Terms.Order.count((boolean)false));
                    break;
                }
                case "count asc": {
                    ret.order(Terms.Order.count((boolean)true));
                    break;
                }
                case "term desc": {
                    ret.order(Terms.Order.term((boolean)false));
                    break;
                }
                case "term asc": {
                    ret.order(Terms.Order.term((boolean)true));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid order: " + (String)props.get("order"));
                }
            }
        }
        return ret;
    }

    @JsonIgnore
    public TermsFilterBuilder getEsFilter() {
        if (this.getSelection().isEmpty()) {
            return null;
        }
        return FilterBuilders.termsFilter((String)this.getField(), (Iterable)this.getSelection());
    }

    @Override
    @JsonIgnore
    public void parseEsBuckets(Collection<? extends MultiBucketsAggregation.Bucket> buckets) {
        ArrayList<BucketTerm> nxBuckets = new ArrayList<BucketTerm>(buckets.size());
        for (MultiBucketsAggregation.Bucket bucket : buckets) {
            nxBuckets.add(new BucketTerm(bucket.getKey(), bucket.getDocCount()));
        }
        this.buckets = nxBuckets;
    }
}

