/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.elasticsearch.query;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.AndFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.filter.FilterAggregationBuilder;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortOrder;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.security.SecurityService;
import org.nuxeo.ecm.platform.query.api.Aggregate;
import org.nuxeo.ecm.platform.query.api.Bucket;
import org.nuxeo.elasticsearch.aggregate.AggregateEsBase;
import org.nuxeo.elasticsearch.fetcher.EsFetcher;
import org.nuxeo.elasticsearch.fetcher.Fetcher;
import org.nuxeo.elasticsearch.fetcher.VcsFetcher;
import org.nuxeo.elasticsearch.query.NxqlQueryConverter;
import org.nuxeo.runtime.api.Framework;

public class NxQueryBuilder {
    private static final int DEFAULT_LIMIT = 10;
    private int limit = 10;
    private static final String AGG_FILTER_SUFFIX = "_filter";
    private final CoreSession session;
    private final List<SortInfo> sortInfos = new ArrayList<SortInfo>();
    private final List<String> repositories = new ArrayList<String>();
    private final List<AggregateEsBase<? extends Bucket>> aggregates = new ArrayList<AggregateEsBase<? extends Bucket>>();
    private int offset = 0;
    private String nxql;
    private QueryBuilder esQueryBuilder;
    private boolean fetchFromElasticsearch = false;
    private boolean searchOnAllRepo = false;
    private String[] selectFields = new String[]{"_id"};
    private Map<String, Type> selectFieldsAndTypes;
    private boolean returnsDocuments = true;
    private boolean esOnly = false;

    public NxQueryBuilder(CoreSession coreSession) {
        this.session = coreSession;
        this.repositories.add(coreSession.getRepositoryName());
        this.fetchFromElasticsearch = Boolean.parseBoolean(Framework.getProperty((String)"elasticsearch.fetchDocFromEs", (String)"false"));
    }

    public static String getAggregateFilterId(Aggregate agg) {
        return agg.getId() + AGG_FILTER_SUFFIX;
    }

    public NxQueryBuilder limit(int limit) {
        if (limit < 0) {
            limit = Integer.MAX_VALUE;
        }
        this.limit = limit;
        return this;
    }

    public NxQueryBuilder offset(int offset) {
        this.offset = offset;
        return this;
    }

    public NxQueryBuilder addSort(SortInfo sortInfo) {
        this.sortInfos.add(sortInfo);
        return this;
    }

    public NxQueryBuilder addSort(SortInfo[] sortInfos) {
        if (sortInfos != null && sortInfos.length > 0) {
            Collections.addAll(this.sortInfos, sortInfos);
        }
        return this;
    }

    public NxQueryBuilder nxql(String nxql) {
        this.nxql = nxql;
        this.esQueryBuilder = null;
        return this;
    }

    public NxQueryBuilder esQuery(QueryBuilder queryBuilder) {
        this.esQueryBuilder = queryBuilder;
        this.nxql = null;
        return this;
    }

    public NxQueryBuilder fetchFromElasticsearch() {
        this.fetchFromElasticsearch = true;
        return this;
    }

    public NxQueryBuilder fetchFromDatabase() {
        this.fetchFromElasticsearch = false;
        return this;
    }

    public NxQueryBuilder onlyElasticsearchResponse() {
        this.esOnly = true;
        return this;
    }

    public NxQueryBuilder addAggregate(AggregateEsBase<? extends Bucket> aggregate) {
        this.aggregates.add(aggregate);
        return this;
    }

    public NxQueryBuilder addAggregates(List<AggregateEsBase<? extends Bucket>> aggregates) {
        if (aggregates != null && !aggregates.isEmpty()) {
            this.aggregates.addAll(aggregates);
        }
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public List<SortInfo> getSortInfos() {
        return this.sortInfos;
    }

    public String getNxql() {
        return this.nxql;
    }

    public boolean isFetchFromElasticsearch() {
        return this.fetchFromElasticsearch;
    }

    public CoreSession getSession() {
        return this.session;
    }

    public QueryBuilder makeQuery() {
        if (this.esQueryBuilder == null && this.nxql != null) {
            this.esQueryBuilder = NxqlQueryConverter.toESQueryBuilder(this.nxql, this.session);
            if (this.nxql.toLowerCase().contains("order by")) {
                List<SortInfo> builtInSortInfos = NxqlQueryConverter.getSortInfo(this.nxql);
                this.sortInfos.addAll(builtInSortInfos);
            }
            if (this.nxqlHasSelectClause(this.nxql)) {
                this.selectFieldsAndTypes = NxqlQueryConverter.getSelectClauseFields(this.nxql);
                Set<String> keySet = this.selectFieldsAndTypes.keySet();
                this.selectFields = keySet.toArray(new String[keySet.size()]);
                this.returnsDocuments = false;
            }
            this.esQueryBuilder = this.addSecurityFilter(this.esQueryBuilder);
        }
        return this.esQueryBuilder;
    }

    protected boolean nxqlHasSelectClause(String nxql) {
        String lowerNxql = nxql.toLowerCase();
        return lowerNxql.startsWith("select") && !lowerNxql.startsWith("select * from");
    }

    public SortBuilder[] getSortBuilders() {
        if (this.sortInfos.isEmpty()) {
            return new SortBuilder[0];
        }
        SortBuilder[] ret = new SortBuilder[this.sortInfos.size()];
        int i = 0;
        for (SortInfo sortInfo : this.sortInfos) {
            ret[i++] = new FieldSortBuilder(sortInfo.getSortColumn()).order(sortInfo.getSortAscending() ? SortOrder.ASC : SortOrder.DESC);
        }
        return ret;
    }

    protected FilterBuilder getAggregateFilter() {
        boolean hasFilter = false;
        AndFilterBuilder ret = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[0]);
        for (AggregateEsBase<? extends Bucket> agg : this.aggregates) {
            FilterBuilder filter = agg.getEsFilter();
            if (filter == null) continue;
            ret.add(filter);
            hasFilter = true;
        }
        if (!hasFilter) {
            return null;
        }
        return ret;
    }

    protected FilterBuilder getAggregateFilterExceptFor(String id) {
        boolean hasFilter = false;
        AndFilterBuilder ret = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[0]);
        for (AggregateEsBase<? extends Bucket> agg : this.aggregates) {
            FilterBuilder filter;
            if (agg.getId().equals(id) || (filter = agg.getEsFilter()) == null) continue;
            ret.add(filter);
            hasFilter = true;
        }
        if (!hasFilter) {
            return FilterBuilders.matchAllFilter();
        }
        return ret;
    }

    public List<AggregateEsBase<? extends Bucket>> getAggregates() {
        return this.aggregates;
    }

    public List<FilterAggregationBuilder> getEsAggregates() {
        ArrayList<FilterAggregationBuilder> ret = new ArrayList<FilterAggregationBuilder>(this.aggregates.size());
        for (AggregateEsBase<? extends Bucket> agg : this.aggregates) {
            FilterAggregationBuilder fagg = new FilterAggregationBuilder(NxQueryBuilder.getAggregateFilterId(agg));
            fagg.filter(this.getAggregateFilterExceptFor(agg.getId()));
            fagg.subAggregation((AbstractAggregationBuilder)agg.getEsAggregate());
            ret.add(fagg);
        }
        return ret;
    }

    public void updateRequest(SearchRequestBuilder request) {
        request.setFrom(this.getOffset()).setSize(this.getLimit());
        request.setQuery(this.makeQuery());
        for (SortBuilder sortBuilder : this.getSortBuilders()) {
            request.addSort(sortBuilder);
        }
        for (AbstractAggregationBuilder abstractAggregationBuilder : this.getEsAggregates()) {
            request.addAggregation(abstractAggregationBuilder);
        }
        FilterBuilder aggFilter = this.getAggregateFilter();
        if (aggFilter != null) {
            request.setPostFilter(aggFilter);
        }
        if (!this.isFetchFromElasticsearch()) {
            request.addFields(this.getSelectFields());
        }
    }

    protected QueryBuilder addSecurityFilter(QueryBuilder query) {
        Principal principal = this.session.getPrincipal();
        if (principal == null || principal instanceof NuxeoPrincipal && ((NuxeoPrincipal)principal).isAdministrator()) {
            return query;
        }
        String[] principals = SecurityService.getPrincipalsToCheck((Principal)principal);
        AndFilterBuilder aclFilter = FilterBuilders.andFilter((FilterBuilder[])new FilterBuilder[]{FilterBuilders.inFilter((String)"ecm:acl", (String[])principals), FilterBuilders.notFilter((FilterBuilder)FilterBuilders.inFilter((String)"ecm:acl", (String[])new String[]{"_UNSUPPORTED_ACL_"}))});
        return QueryBuilders.filteredQuery((QueryBuilder)query, (FilterBuilder)aclFilter);
    }

    public NxQueryBuilder addSearchRepository(String repositoryName) {
        this.repositories.add(repositoryName);
        return this;
    }

    public NxQueryBuilder searchOnAllRepositories() {
        this.searchOnAllRepo = true;
        return this;
    }

    public List<String> getSearchRepositories() {
        if (this.searchOnAllRepo) {
            return Collections.emptyList();
        }
        return this.repositories;
    }

    public Fetcher getFetcher(SearchResponse response, Map<String, String> repoNames) {
        if (this.isFetchFromElasticsearch()) {
            return new EsFetcher(this.session, response, repoNames);
        }
        return new VcsFetcher(this.session, response, repoNames);
    }

    public String[] getSelectFields() {
        return this.selectFields;
    }

    public Map<String, Type> getSelectFieldsAndTypes() {
        return this.selectFieldsAndTypes;
    }

    public boolean returnsDocuments() {
        if (this.esOnly) {
            return false;
        }
        return this.returnsDocuments;
    }

    public boolean returnsRows() {
        if (this.esOnly) {
            return false;
        }
        return !this.returnsDocuments;
    }
}

