/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.permissions;

import java.io.Serializable;
import java.util.List;
import org.nuxeo.ecm.core.api.CoreInstance;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventBundle;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.PostCommitFilteringEventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.permissions.PermissionHelper;
import org.nuxeo.runtime.api.Framework;

public class ACEStatusUpdatedListener
implements PostCommitFilteringEventListener {
    public void handleEvent(EventBundle events) {
        for (Event event : events) {
            this.handleEvent(event);
        }
    }

    protected void handleEvent(Event event) {
        EventContext ctx = event.getContext();
        String repositoryName = (String)((Object)ctx.getProperty("repositoryName"));
        List docRefs = (List)((Object)ctx.getProperty("documentRefs"));
        if (repositoryName == null || docRefs == null) {
            return;
        }
        try (CoreSession session = CoreInstance.openCoreSessionSystem((String)repositoryName);){
            docRefs.stream().filter(arg_0 -> ((CoreSession)session).exists(arg_0)).forEach(ref -> {
                DocumentModel doc = session.getDocument(ref);
                this.checkForEffectiveACE(session, doc);
            });
        }
    }

    protected void checkForEffectiveACE(CoreSession session, DocumentModel doc) {
        DirectoryService directoryService = (DirectoryService)Framework.getService(DirectoryService.class);
        ACP acp = doc.getACP();
        for (ACL acl : acp.getACLs()) {
            String aclName = acl.getName();
            if ("inherited".equals(aclName)) continue;
            for (ACE ace : acl) {
                if (!ace.isGranted() || !ace.isEffective()) continue;
                Session dirSession = directoryService.open("aceinfo");
                Throwable throwable = null;
                try {
                    String id = PermissionHelper.computeDirectoryId(doc, acl.getName(), ace.getId());
                    DocumentModel entry = dirSession.getEntry(id);
                    if (entry == null) continue;
                    boolean notify = (Boolean)entry.getPropertyValue("aceinfo:notify");
                    String comment = (String)((Object)entry.getPropertyValue("aceinfo:comment"));
                    if (!notify) continue;
                    ace.putContextData("comment", (Serializable)((Object)comment));
                    this.firePermissionNotificationEvent(session, doc, aclName, ace);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (dirSession == null) continue;
                    if (throwable != null) {
                        try {
                            dirSession.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    dirSession.close();
                }
            }
        }
    }

    protected void firePermissionNotificationEvent(CoreSession session, DocumentModel doc, String aclName, ACE ace) {
        DocumentEventContext docCtx = new DocumentEventContext(session, session.getPrincipal(), doc);
        docCtx.setProperty("ace", (Serializable)ace);
        docCtx.setProperty("aclName", (Serializable)((Object)aclName));
        EventService eventService = (EventService)Framework.getService(EventService.class);
        eventService.fireEvent("permissionNotification", (EventContext)docCtx);
    }

    public boolean acceptEvent(Event event) {
        return "ACEStatusUpdated".equals(event.getName());
    }
}

