/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.ra;

import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.cci.ConnectionMetaData;
import javax.resource.cci.Interaction;
import javax.resource.cci.LocalTransaction;
import javax.resource.cci.ResultSetInfo;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.model.LockManager;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.Node;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.SessionImpl;
import org.nuxeo.ecm.core.storage.sql.ra.ManagedConnectionImpl;

public class ConnectionImpl
implements Session {
    private ManagedConnectionImpl managedConnection;
    private SessionImpl session;
    protected Throwable closeTrace;
    protected final Set<QueryResultContextException> queryResults = new HashSet<QueryResultContextException>();

    public ConnectionImpl(ManagedConnectionImpl managedConnection) {
        this.managedConnection = managedConnection;
    }

    protected ManagedConnectionImpl getManagedConnection() {
        return this.managedConnection;
    }

    protected void setManagedConnection(ManagedConnectionImpl managedConnection) {
        this.managedConnection = managedConnection;
    }

    protected void associate(SessionImpl session) {
        this.session = session;
    }

    protected void disassociate() {
        this.closeStillOpenQueryResults();
        this.session = null;
    }

    public void close() throws ResourceException {
        if (this.managedConnection == null) {
            IllegalStateException error = new IllegalStateException("connection already closed " + this);
            error.addSuppressed(this.closeTrace);
            throw error;
        }
        try {
            this.managedConnection.close(this);
        }
        finally {
            this.closeTrace = new Throwable("close stack trace");
            this.managedConnection = null;
        }
    }

    public Interaction createInteraction() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public ConnectionMetaData getMetaData() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    public ResultSetInfo getResultSetInfo() throws ResourceException {
        throw new UnsupportedOperationException();
    }

    private Session getSession() {
        if (this.session == null) {
            throw new NuxeoException("Cannot use closed connection handle: " + this);
        }
        return this.session;
    }

    public Mapper getMapper() {
        return this.getSession().getMapper();
    }

    public boolean isLive() {
        return this.session != null && this.session.isLive();
    }

    public boolean isStateSharedByAllThreadSessions() {
        return true;
    }

    public String getRepositoryName() {
        return this.getSession().getRepositoryName();
    }

    public Model getModel() {
        return this.getSession().getModel();
    }

    public void save() {
        this.getSession().save();
    }

    public Node getRootNode() {
        return this.getSession().getRootNode();
    }

    public Node getNodeById(Serializable id) {
        return this.getSession().getNodeById(id);
    }

    public List<Node> getNodesByIds(List<Serializable> ids) {
        return this.getSession().getNodesByIds(ids);
    }

    public Node getNodeByPath(String path, Node node) {
        return this.getSession().getNodeByPath(path, node);
    }

    public boolean addMixinType(Node node, String mixin) {
        return this.getSession().addMixinType(node, mixin);
    }

    public boolean removeMixinType(Node node, String mixin) {
        return this.getSession().removeMixinType(node, mixin);
    }

    public boolean hasChildNode(Node parent, String name, boolean complexProp) {
        return this.getSession().hasChildNode(parent, name, complexProp);
    }

    public Node getChildNode(Node parent, String name, boolean complexProp) {
        return this.getSession().getChildNode(parent, name, complexProp);
    }

    public boolean hasChildren(Node parent, boolean complexProp) {
        return this.getSession().hasChildren(parent, complexProp);
    }

    public List<Node> getChildren(Node parent, String name, boolean complexProp) {
        return this.getSession().getChildren(parent, name, complexProp);
    }

    public Node addChildNode(Node parent, String name, Long pos, String typeName, boolean complexProp) {
        return this.getSession().addChildNode(parent, name, pos, typeName, complexProp);
    }

    public Node addChildNode(Serializable id, Node parent, String name, Long pos, String typeName, boolean complexProp) {
        return this.getSession().addChildNode(id, parent, name, pos, typeName, complexProp);
    }

    public void removeNode(Node node) {
        this.getSession().removeNode(node);
    }

    public void removePropertyNode(Node node) {
        this.getSession().removePropertyNode(node);
    }

    public Node getParentNode(Node node) {
        return this.getSession().getParentNode(node);
    }

    public String getPath(Node node) {
        return this.getSession().getPath(node);
    }

    public void orderBefore(Node node, Node src, Node dest) {
        this.getSession().orderBefore(node, src, dest);
    }

    public Node move(Node source, Node parent, String name) {
        return this.getSession().move(source, parent, name);
    }

    public Node copy(Node source, Node parent, String name) {
        return this.getSession().copy(source, parent, name);
    }

    public Node checkIn(Node node, String label, String checkinComment) {
        return this.getSession().checkIn(node, label, checkinComment);
    }

    public void checkOut(Node node) {
        this.getSession().checkOut(node);
    }

    public void restore(Node node, Node version) {
        this.getSession().restore(node, version);
    }

    public Node getVersionByLabel(Serializable versionSeriesId, String label) {
        return this.getSession().getVersionByLabel(versionSeriesId, label);
    }

    public List<Node> getVersions(Serializable versionSeriesId) {
        return this.getSession().getVersions(versionSeriesId);
    }

    public Node getLastVersion(Serializable versionSeriesId) {
        return this.getSession().getLastVersion(versionSeriesId);
    }

    public List<Node> getProxies(Node document, Node parent) {
        return this.getSession().getProxies(document, parent);
    }

    public void setProxyTarget(Node proxy, Serializable targetId) {
        this.getSession().setProxyTarget(proxy, targetId);
    }

    public Node addProxy(Serializable targetId, Serializable versionSeriesId, Node parent, String name, Long pos) {
        return this.getSession().addProxy(targetId, versionSeriesId, parent, name, pos);
    }

    public PartialList<Serializable> query(String query, QueryFilter queryFilter, boolean countTotal) {
        return this.getSession().query(query, queryFilter, countTotal);
    }

    public PartialList<Serializable> query(String query, String queryType, QueryFilter queryFilter, long countUpTo) {
        return this.getSession().query(query, queryType, queryFilter, countUpTo);
    }

    public IterableQueryResult queryAndFetch(String query, String queryType, QueryFilter queryFilter, Object ... params) {
        IterableQueryResult result = this.getSession().queryAndFetch(query, queryType, queryFilter, params);
        this.noteQueryResult(result);
        return result;
    }

    protected void noteQueryResult(IterableQueryResult result) {
        this.queryResults.add(new QueryResultContextException(result));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeStillOpenQueryResults() {
        for (QueryResultContextException context : this.queryResults) {
            if (!context.queryResult.isLife()) continue;
            try {
                context.queryResult.close();
            }
            catch (RuntimeException e) {
                LogFactory.getLog(ConnectionImpl.class).error((Object)"Cannot close query result", (Throwable)e);
            }
            finally {
                LogFactory.getLog(ConnectionImpl.class).warn((Object)"Closing a query results for you, check stack trace for allocating point", (Throwable)context);
            }
        }
        this.queryResults.clear();
    }

    public LockManager getLockManager() {
        return this.getSession().getLockManager();
    }

    public void requireReadAclsUpdate() {
        if (this.session != null) {
            this.session.requireReadAclsUpdate();
        }
    }

    public void updateReadAcls() {
        this.getSession().updateReadAcls();
    }

    public void rebuildReadAcls() {
        this.getSession().rebuildReadAcls();
    }

    public Map<String, String> getBinaryFulltext(Serializable id) {
        return this.getSession().getBinaryFulltext(id);
    }

    public static class QueryResultContextException
    extends Exception {
        private static final long serialVersionUID = 1L;
        public final IterableQueryResult queryResult;

        public QueryResultContextException(IterableQueryResult queryResult) {
            super("queryAndFetch call context");
            this.queryResult = queryResult;
        }
    }
}

