/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.ra;

import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;
import javax.resource.ResourceException;
import javax.resource.cci.Connection;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.collections.ListenerList;
import org.nuxeo.ecm.core.storage.sql.SessionImpl;
import org.nuxeo.ecm.core.storage.sql.ra.ConnectionImpl;
import org.nuxeo.ecm.core.storage.sql.ra.ManagedConnectionFactoryImpl;

public class ManagedConnectionImpl
implements ManagedConnection,
ManagedConnectionMetaData {
    private static final Log log = LogFactory.getLog(ManagedConnectionImpl.class);
    private PrintWriter out;
    private final ManagedConnectionFactoryImpl managedConnectionFactory;
    private final Set<ConnectionImpl> connections;
    private final SessionImpl session;
    private final XAResource xaresource;
    private final ListenerList listeners;

    public ManagedConnectionImpl(ManagedConnectionFactoryImpl managedConnectionFactory) throws ResourceException {
        log.debug((Object)("construct: " + this));
        if (log.isTraceEnabled()) {
            log.trace((Object)"debug stack trace", (Throwable)new Exception());
        }
        this.out = managedConnectionFactory.getLogWriter();
        this.managedConnectionFactory = managedConnectionFactory;
        this.connections = new HashSet<ConnectionImpl>();
        this.listeners = new ListenerList();
        this.session = managedConnectionFactory.getConnection();
        this.xaresource = this.session.getXAResource();
    }

    public synchronized Connection getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        log.debug((Object)("getConnection: " + this));
        ConnectionImpl connection = new ConnectionImpl(this);
        this.addConnection(connection);
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanup() {
        log.debug((Object)("cleanup: " + this));
        if (log.isTraceEnabled()) {
            log.trace((Object)"debug stack trace", (Throwable)new Exception());
        }
        Set<ConnectionImpl> set = this.connections;
        synchronized (set) {
            this.connections.clear();
        }
    }

    public void destroy() throws ResourceException {
        log.debug((Object)("destroy: " + this));
        this.cleanup();
        this.session.close();
    }

    public void associateConnection(Object object) throws ResourceException {
        ConnectionImpl connection = (ConnectionImpl)object;
        log.debug((Object)("associateConnection: " + this + ", connection: " + connection));
        ManagedConnectionImpl other = connection.getManagedConnection();
        if (other != this) {
            log.debug((Object)("associateConnection other: " + other));
            other.removeConnection(connection);
            this.addConnection(connection);
        }
    }

    public XAResource getXAResource() {
        return this.xaresource;
    }

    public LocalTransaction getLocalTransaction() {
        throw new UnsupportedOperationException("Local transactions not supported");
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove((Object)listener);
    }

    public ManagedConnectionMetaData getMetaData() {
        return this;
    }

    public void setLogWriter(PrintWriter out) {
        this.out = out;
    }

    public PrintWriter getLogWriter() {
        return this.out;
    }

    public String getEISProductName() {
        return "Nuxeo Core SQL Storage";
    }

    public String getEISProductVersion() {
        return "1.0.0";
    }

    public int getMaxConnections() {
        return Integer.MAX_VALUE;
    }

    public String getUserName() throws ResourceException {
        return null;
    }

    private void addConnection(ConnectionImpl connection) {
        log.debug((Object)("addConnection: " + connection));
        if (!this.connections.add(connection)) {
            throw new IllegalStateException("already known connection " + connection + " in " + this);
        }
        connection.setManagedConnection(this);
        connection.associate(this.session);
    }

    private void removeConnection(ConnectionImpl connection) {
        log.debug((Object)("removeConnection: " + connection));
        if (!this.connections.remove(connection)) {
            throw new IllegalStateException("unknown connection " + connection + " in " + this);
        }
        connection.setManagedConnection(null);
        connection.disassociate();
    }

    protected void close(ConnectionImpl connection) {
        this.removeConnection(connection);
        this.sendClosedEvent(connection);
    }

    protected ManagedConnectionFactoryImpl getManagedConnectionFactory() {
        return this.managedConnectionFactory;
    }

    private void sendClosedEvent(ConnectionImpl connection) {
        log.debug((Object)("closing a connection " + connection));
        this.sendEvent(1, connection, null);
    }

    protected void sendTxStartedEvent(ConnectionImpl connection) {
        this.sendEvent(2, connection, null);
    }

    protected void sendTxCommittedEvent(ConnectionImpl connection) {
        this.sendEvent(3, connection, null);
    }

    protected void sendTxRolledbackEvent(ConnectionImpl connection) {
        this.sendEvent(4, connection, null);
    }

    protected void sendErrorEvent(ConnectionImpl connection, Exception cause) {
        this.sendEvent(5, connection, cause);
    }

    private void sendEvent(int type, ConnectionImpl connection, Exception cause) {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, type, cause);
        if (connection != null) {
            event.setConnectionHandle((Object)connection);
        }
        this.sendEvent(event);
    }

    private void sendEvent(ConnectionEvent event) {
        block7: for (Object object : this.listeners.getListeners()) {
            ConnectionEventListener listener = (ConnectionEventListener)object;
            switch (event.getId()) {
                case 1: {
                    listener.connectionClosed(event);
                    continue block7;
                }
                case 2: {
                    listener.localTransactionStarted(event);
                    continue block7;
                }
                case 3: {
                    listener.localTransactionCommitted(event);
                    continue block7;
                }
                case 4: {
                    listener.localTransactionRolledback(event);
                    continue block7;
                }
                case 5: {
                    listener.connectionErrorOccurred(event);
                }
            }
        }
    }
}

