/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.admin.permissions;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.SortInfo;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.work.AbstractWork;
import org.nuxeo.ecm.platform.query.api.PageProviderDefinition;
import org.nuxeo.ecm.platform.query.api.PageProviderService;
import org.nuxeo.ecm.platform.query.api.WhereClauseDefinition;
import org.nuxeo.ecm.platform.query.nxql.NXQLQueryBuilder;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionRuntimeException;

public class PermissionsPurgeWork
extends AbstractWork {
    private static final long serialVersionUID = 1L;
    public static final int DEFAULT_BATCH_SIZE = 20;
    public static final String CATEGORY = "permissionsPurge";
    protected DocumentModel searchDocument;
    protected int batchSize = 20;

    public PermissionsPurgeWork(DocumentModel searchDocument) {
        this.searchDocument = searchDocument;
    }

    public String getTitle() {
        return String.format("Permissions purge for: %s, %s", this.searchDocument.getPropertyValue("rs:ace_username"), this.searchDocument.getPropertyValue("rs:ecm_path"));
    }

    public String getCategory() {
        return CATEGORY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void work() {
        this.setStatus("Purging");
        this.initSession();
        PageProviderService pageProviderService = (PageProviderService)Framework.getService(PageProviderService.class);
        PageProviderDefinition def = pageProviderService.getPageProviderDefinition("permissions_purge");
        String query = NXQLQueryBuilder.getQuery((DocumentModel)this.searchDocument, (WhereClauseDefinition)def.getWhereClause(), null, (SortInfo[])new SortInfo[0]);
        ArrayList<String> docIds = new ArrayList<String>();
        try (IterableQueryResult result = this.session.queryAndFetch(query, "NXQL", new Object[0]);){
            for (Map map : result) {
                docIds.add((String)map.get("ecm:uuid"));
            }
        }
        List usernames = (List)((Object)this.searchDocument.getPropertyValue("rs:ace_username"));
        int acpUpdatedCount = 0;
        for (String docId : docIds) {
            IdRef ref = new IdRef(docId);
            ACP acp = this.session.getACP((DocumentRef)ref);
            boolean changed = false;
            for (String username : usernames) {
                for (ACL acl : acp.getACLs()) {
                    for (ACE ace : acl) {
                        if (!username.equals(ace.getUsername())) continue;
                        GregorianCalendar now = new GregorianCalendar();
                        ace.setEnd((Calendar)now);
                        changed = true;
                    }
                }
            }
            try {
                if (!changed) continue;
                this.session.setACP((DocumentRef)ref, acp, true);
                if (++acpUpdatedCount % this.batchSize != 0) continue;
                this.commitOrRollbackTransaction();
                this.startTransaction();
            }
            catch (TransactionRuntimeException e) {
                if (e.getMessage().contains("Transaction timeout")) {
                    this.batchSize = 1;
                }
                throw e;
            }
        }
        this.setStatus(null);
    }

    public int getRetryCount() {
        return 10;
    }
}

