/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.jsf;

import com.sun.faces.util.FacesLogger;
import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.application.FacesMessage;
import javax.faces.application.ProjectStage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.ListenerFor;
import javax.faces.event.PostAddToViewEvent;
import javax.faces.render.Renderer;
import org.apache.commons.lang.StringUtils;

@ListenerFor(systemEventClass=PostAddToViewEvent.class)
public abstract class ScriptStyleBaseRenderer
extends Renderer
implements ComponentSystemEventListener {
    private static final String COMP_KEY = ScriptStyleBaseRenderer.class.getName() + "_COMPOSITE_COMPONENT";
    protected static final Logger logger = FacesLogger.RENDERKIT.getLogger();

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        UIComponent component = event.getComponent();
        FacesContext context = FacesContext.getCurrentInstance();
        String target = this.verifyTarget((String)component.getAttributes().get("target"));
        if (target != null) {
            UIComponent cc = UIComponent.getCurrentCompositeComponent((FacesContext)context);
            if (cc != null) {
                component.getAttributes().put(COMP_KEY, cc.getClientId(context));
            }
            context.getViewRoot().addComponentResource(context, component, target);
        }
    }

    public final void decode(FacesContext context, UIComponent component) {
    }

    public final boolean getRendersChildren() {
        return true;
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        String ccID = (String)component.getAttributes().get(COMP_KEY);
        if (ccID != null) {
            component.popComponentFromEL(context);
            component.popComponentFromEL(context);
            component.pushComponentToEL(context, component);
        }
    }

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        UIComponent curCC;
        UIComponent cc;
        String ccID = (String)component.getAttributes().get(COMP_KEY);
        if (null != ccID && (cc = context.getViewRoot().findComponent(':' + ccID)) != (curCC = UIComponent.getCurrentCompositeComponent((FacesContext)context))) {
            component.popComponentFromEL(context);
            component.pushComponentToEL(context, cc);
            component.pushComponentToEL(context, component);
        }
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
        this.encodeChildren(context, component, false);
    }

    public final void encodeChildren(FacesContext context, UIComponent component, boolean warnOnChildren) throws IOException {
        boolean renderChildren;
        int childCount = component.getChildCount();
        boolean bl = renderChildren = 0 < childCount;
        if (warnOnChildren) {
            boolean hasSrc;
            Map attributes = component.getAttributes();
            boolean hasName = attributes.get("name") != null;
            boolean bl2 = hasSrc = attributes.get("src") != null;
            if (!hasName && !hasSrc) {
                if (0 == childCount) {
                    if (context.isProjectStage(ProjectStage.Development)) {
                        FacesMessage message = new FacesMessage(FacesMessage.SEVERITY_WARN, "outputScript with no library, no name, and no body content", "Is body content intended?");
                        context.addMessage(component.getClientId(context), message);
                    }
                    renderChildren = false;
                }
            } else if (0 < childCount) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.info("outputScript with \"name\" attribute and nested content.  Ignoring nested content.");
                }
                renderChildren = false;
            }
        }
        if (renderChildren) {
            ResponseWriter writer = context.getResponseWriter();
            this.startElement(writer, component);
            super.encodeChildren(context, component);
            this.endElement(writer);
        }
    }

    protected abstract void startElement(ResponseWriter var1, UIComponent var2) throws IOException;

    protected abstract void endElement(ResponseWriter var1) throws IOException;

    protected String verifyTarget(String toVerify) {
        if (StringUtils.isBlank((String)toVerify)) {
            return null;
        }
        FacesContext context = FacesContext.getCurrentInstance();
        boolean ajaxRequest = context.getPartialViewContext().isAjaxRequest();
        if (ajaxRequest) {
            return null;
        }
        return toVerify;
    }
}

