/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.web.resources.jsf.handler;

import com.sun.faces.facelets.tag.jsf.html.ScriptResourceHandler;
import com.sun.faces.facelets.tag.jsf.html.StylesheetResourceHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import javax.faces.component.UIComponent;
import javax.faces.view.facelets.ComponentConfig;
import javax.faces.view.facelets.FaceletContext;
import javax.faces.view.facelets.FaceletHandler;
import javax.faces.view.facelets.TagAttribute;
import javax.faces.view.facelets.TagConfig;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.platform.ui.web.tag.handler.LeafFaceletHandler;
import org.nuxeo.ecm.web.resources.api.Resource;
import org.nuxeo.ecm.web.resources.api.ResourceType;
import org.nuxeo.ecm.web.resources.api.service.WebResourceManager;
import org.nuxeo.ecm.web.resources.jsf.handler.PageResourceHandler;
import org.nuxeo.runtime.api.Framework;

public class ResourceBundleHandler
extends PageResourceHandler {
    private static final Log log = LogFactory.getLog(ResourceBundleHandler.class);
    protected final TagAttribute items = this.getAttribute("items");

    public ResourceBundleHandler(TagConfig config) {
        super(config);
    }

    @Override
    public void apply(FaceletContext ctx, UIComponent parent) throws IOException {
        String bundleName;
        ResourceType rtype;
        String typeValue = null;
        if (this.type != null) {
            typeValue = this.type.getValue(ctx);
        }
        if ((rtype = this.resolveType(typeValue)) == null) {
            log.error((Object)String.format("Unsupported type '%s' on tag nxr:resourceBundle at %s", typeValue, this.tag.getLocation()));
            return;
        }
        ArrayList<String> bundles = new ArrayList<String>();
        if (this.name != null && !StringUtils.isBlank((String)(bundleName = this.name.getValue(ctx)))) {
            bundles.add(bundleName);
        }
        if (this.items != null) {
            Object itemsValue = this.items.getObject(ctx);
            if (itemsValue instanceof Collection) {
                bundles.addAll((Collection)itemsValue);
            } else if (itemsValue instanceof Object[]) {
                bundles.addAll(Arrays.asList((String[])itemsValue));
            } else if (itemsValue instanceof String) {
                bundles.add((String)itemsValue);
            } else {
                log.error((Object)String.format("Unsupported value '%s' for attribute 'items' on tag nxr:resourceBundle at %s", itemsValue, this.tag.getLocation()));
            }
        }
        if (bundles.isEmpty()) {
            return;
        }
        String flavorValue = null;
        if (this.flavor != null) {
            flavorValue = this.flavor.getValue(ctx);
        }
        String targetValue = null;
        if (this.target != null) {
            targetValue = this.target.getValue(ctx);
        }
        WebResourceManager wrm = (WebResourceManager)Framework.getService(WebResourceManager.class);
        LeafFaceletHandler leaf = new LeafFaceletHandler();
        if (rtype == ResourceType.any) {
            String cssTarget = targetValue;
            String jsTarget = targetValue;
            String htmlTarget = targetValue;
            if (this.vars != null) {
                for (TagAttribute var : this.vars) {
                    String val;
                    if ("target_css".equalsIgnoreCase(var.getLocalName())) {
                        val = this.resolveAttribute(ctx, var);
                        if (val == null) continue;
                        cssTarget = val;
                        continue;
                    }
                    if ("target_js".equalsIgnoreCase(var.getLocalName())) {
                        val = this.resolveAttribute(ctx, var);
                        if (val == null) continue;
                        jsTarget = val;
                        continue;
                    }
                    if (!"target_html".equalsIgnoreCase(var.getLocalName()) || (val = this.resolveAttribute(ctx, var)) == null) continue;
                    htmlTarget = val;
                }
            }
            for (String bundle : bundles) {
                this.applyBundle(ctx, parent, wrm, bundle, ResourceType.jsfcss, flavorValue, cssTarget, (FaceletHandler)leaf);
                this.applyBundle(ctx, parent, wrm, bundle, ResourceType.jsfjs, flavorValue, jsTarget, (FaceletHandler)leaf);
                this.applyBundle(ctx, parent, wrm, bundle, ResourceType.xhtmlfirst, flavorValue, null, (FaceletHandler)leaf);
                this.applyBundle(ctx, parent, wrm, bundle, ResourceType.css, flavorValue, cssTarget, this.nextHandler);
                this.applyBundle(ctx, parent, wrm, bundle, ResourceType.js, flavorValue, jsTarget, this.nextHandler);
                this.applyBundle(ctx, parent, wrm, bundle, ResourceType.html, flavorValue, htmlTarget, this.nextHandler);
                this.applyBundle(ctx, parent, wrm, bundle, ResourceType.xhtml, flavorValue, null, (FaceletHandler)leaf);
            }
        } else {
            for (String bundle : bundles) {
                this.applyBundle(ctx, parent, wrm, bundle, rtype, flavorValue, targetValue, (FaceletHandler)leaf);
            }
        }
    }

    protected void applyBundle(FaceletContext ctx, UIComponent parent, WebResourceManager wrm, String bundle, ResourceType type, String flavor, String targetValue, FaceletHandler nextHandler) throws IOException {
        switch (type) {
            case jsfjs: {
                Iterator<Resource> iterator = this.retrieveResources(wrm, bundle, type).iterator();
                while (iterator.hasNext()) {
                    Resource r;
                    String rtarget = (r = iterator.next()).getTarget();
                    ComponentConfig config = this.getJSFResourceComponentConfig(r, "javax.faces.resource.Script", rtarget == null ? targetValue : rtarget, nextHandler);
                    new ScriptResourceHandler(config).apply(ctx, parent);
                }
                break;
            }
            case jsfcss: {
                Iterator<Resource> iterator = this.retrieveResources(wrm, bundle, type).iterator();
                while (iterator.hasNext()) {
                    Resource r;
                    String rtarget = (r = iterator.next()).getTarget();
                    ComponentConfig config = this.getJSFResourceComponentConfig(r, "javax.faces.resource.Stylesheet", rtarget == null ? targetValue : rtarget, nextHandler);
                    new StylesheetResourceHandler(config).apply(ctx, parent);
                }
                break;
            }
            case xhtmlfirst: {
                this.includeXHTML(ctx, parent, this.retrieveResources(wrm, bundle, type), nextHandler);
                break;
            }
            case xhtml: {
                this.includeXHTML(ctx, parent, this.retrieveResources(wrm, bundle, type), nextHandler);
                break;
            }
            case js: {
                this.includeResourceBundle(ctx, parent, bundle, type, flavor, targetValue, nextHandler);
                break;
            }
            case css: {
                this.includeResourceBundle(ctx, parent, bundle, type, flavor, targetValue, nextHandler);
                break;
            }
            case html: {
                this.includeResourceBundle(ctx, parent, bundle, type, flavor, targetValue, nextHandler);
                break;
            }
        }
    }
}

