/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.connect.update.standalone;

import groovy.lang.GroovyClassLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import org.nuxeo.connect.update.PackageData;
import org.nuxeo.connect.update.PackageException;

public class LocalPackageData
implements PackageData {
    protected File root;
    protected GroovyClassLoader loader;

    public LocalPackageData(ClassLoader parent, File file) throws IOException {
        this.root = file.getCanonicalFile();
        if (parent == null && (parent = Thread.currentThread().getContextClassLoader()) == null) {
            parent = this.getClass().getClassLoader();
        }
        try {
            this.loader = new GroovyClassLoader(parent);
            this.loader.addURL(this.root.toURI().toURL());
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Failed to create package class loader. Invalid package root: " + this.root, e);
        }
    }

    public void setRoot(File file) {
        this.root = file;
    }

    public ClassLoader getLoader() {
        return this.loader;
    }

    public File getEntry(String path) {
        return new File(this.root, path);
    }

    public InputStream getEntryAsStream(String path) throws IOException {
        return new FileInputStream(this.getEntry(path));
    }

    public File getManifest() {
        return this.getEntry("package.xml");
    }

    public File getRoot() {
        return this.root;
    }

    public Class<?> loadClass(String name) throws PackageException {
        try {
            return this.loader.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new PackageException("Failed to load class " + name + " from package: " + this.root.getName());
        }
    }
}

