/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs;

import java.io.Serializable;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.VersioningOption;
import org.nuxeo.ecm.core.io.marshallers.json.document.DocumentModelJsonReader;
import org.nuxeo.ecm.core.rest.DocumentObject;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.Resource;
import org.nuxeo.ecm.webengine.model.WebObject;

@WebObject(type="Document")
@Produces(value={"application/json+nxentity", "application/json+esentity", "application/json"})
public class JSONDocumentObject
extends DocumentObject {
    private static final String APPLICATION_JSON_NXENTITY = "application/json+nxentity";
    protected static final Log log = LogFactory.getLog(JSONDocumentObject.class);
    private boolean isVersioning;

    @GET
    public DocumentModel doGet() {
        return this.doc;
    }

    @PUT
    @Consumes(value={"application/json+nxentity", "application/json"})
    public DocumentModel doPut(DocumentModel inputDoc, @Context HttpHeaders headers) {
        DocumentModelJsonReader.applyPropertyValues((DocumentModel)inputDoc, (DocumentModel)this.doc);
        CoreSession session = this.ctx.getCoreSession();
        this.versioningDocFromHeaderIfExists(headers);
        this.doc = session.saveDocument(this.doc);
        session.save();
        return this.isVersioning ? session.getLastDocumentVersion(this.doc.getRef()) : this.doc;
    }

    @POST
    @Consumes(value={"application/json+nxentity", "application/json"})
    public Response doPost(DocumentModel inputDoc) {
        CoreSession session = this.ctx.getCoreSession();
        if (StringUtils.isBlank((String)inputDoc.getType()) || StringUtils.isBlank((String)inputDoc.getName())) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)"type or name property is missing").build();
        }
        DocumentModel createdDoc = session.createDocumentModel(this.doc.getPathAsString(), inputDoc.getName(), inputDoc.getType());
        DocumentModelJsonReader.applyPropertyValues((DocumentModel)inputDoc, (DocumentModel)createdDoc);
        createdDoc = session.createDocument(createdDoc);
        session.save();
        return Response.ok((Object)createdDoc).status(Response.Status.CREATED).build();
    }

    @DELETE
    @Consumes(value={"application/json+nxentity", "application/json"})
    public Response doDeleteJson() {
        super.doDelete();
        return Response.noContent().build();
    }

    @Path(value="@search")
    public Object search() {
        return this.ctx.newAdapter((Resource)this, "search", new Object[0]);
    }

    public DocumentObject newDocument(String path) {
        try {
            PathRef pathRef = new PathRef(this.doc.getPath().append(path).toString());
            DocumentModel doc = this.ctx.getCoreSession().getDocument((DocumentRef)pathRef);
            return (DocumentObject)this.ctx.newObject("Document", new Object[]{doc});
        }
        catch (NuxeoException e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    public DocumentObject newDocument(DocumentRef ref) {
        try {
            DocumentModel doc = this.ctx.getCoreSession().getDocument(ref);
            return (DocumentObject)this.ctx.newObject("Document", new Object[]{doc});
        }
        catch (NuxeoException e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    public DocumentObject newDocument(DocumentModel doc) {
        return (DocumentObject)this.ctx.newObject("Document", new Object[]{doc});
    }

    private void versioningDocFromHeaderIfExists(HttpHeaders headers) {
        VersioningOption versioningOption;
        this.isVersioning = false;
        List versionHeader = headers.getRequestHeader("X-Versioning-Option");
        if (versionHeader != null && versionHeader.size() != 0 && (versioningOption = VersioningOption.valueOf((String)((String)versionHeader.get(0)).toUpperCase())) != null && !versioningOption.equals((Object)VersioningOption.NONE)) {
            this.doc.putContextData("VersioningOption", (Serializable)versioningOption);
            this.isVersioning = true;
        }
    }
}

