/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.restapi.server.jaxrs.usermanager;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.ecm.restapi.server.jaxrs.PaginableObject;
import org.nuxeo.ecm.webengine.WebException;
import org.nuxeo.ecm.webengine.model.exceptions.WebResourceNotFoundException;
import org.nuxeo.ecm.webengine.model.exceptions.WebSecurityException;
import org.nuxeo.runtime.api.Framework;

public abstract class AbstractUMRootObject<T>
extends PaginableObject<T> {
    protected String query;
    protected UserManager um;

    @Override
    protected void initialize(Object ... args) {
        super.initialize(args);
        this.um = (UserManager)Framework.getLocalService(UserManager.class);
        HttpServletRequest request = this.ctx.getRequest();
        this.query = request.getParameter("q");
    }

    @Path(value="{artName}")
    public Object getArtifactWebObject(@PathParam(value="artName") String artName) {
        try {
            T artifact = this.getArtifact(artName);
            if (artifact == null) {
                throw new WebResourceNotFoundException(this.getArtifactType() + " does not exist");
            }
            return this.newObject(this.getArtifactType(), new Object[]{artifact});
        }
        catch (NuxeoException e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @POST
    public Response createNew(T artifact) {
        try {
            this.checkPrecondition(artifact);
            artifact = this.createArtifact(artifact);
            return Response.status((Response.Status)Response.Status.CREATED).entity(artifact).build();
        }
        catch (NuxeoException e) {
            throw WebException.wrap((Throwable)e);
        }
    }

    @GET
    @Path(value="search")
    public List<T> search() {
        return this.getPaginableEntries();
    }

    @Override
    protected Object[] getParams() {
        return new Object[]{this.query};
    }

    protected abstract T getArtifact(String var1);

    protected abstract String getArtifactType();

    protected abstract void checkPrecondition(T var1);

    protected abstract T createArtifact(T var1);

    protected void checkCurrentUserCanCreateArtifact(T artifact) {
        NuxeoPrincipal currentUser = (NuxeoPrincipal)this.getContext().getCoreSession().getPrincipal();
        if (!(currentUser.isAdministrator() || currentUser.isMemberOf("powerusers") && this.isAPowerUserEditableArtifact(artifact))) {
            throw new WebSecurityException("Cannot create artifact");
        }
    }

    abstract boolean isAPowerUserEditableArtifact(T var1);
}

