/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.automation.scripting.internals;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.commons.io.IOUtils;
import org.nuxeo.automation.scripting.api.AutomationScriptingService;
import org.nuxeo.automation.scripting.internals.AutomationMapper;
import org.nuxeo.automation.scripting.internals.ScriptOperationContext;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationException;
import org.nuxeo.ecm.automation.OperationType;
import org.nuxeo.ecm.automation.context.ContextService;
import org.nuxeo.ecm.automation.core.scripting.DateWrapper;
import org.nuxeo.ecm.automation.core.scripting.DocumentWrapper;
import org.nuxeo.ecm.automation.core.scripting.PrincipalWrapper;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.runtime.api.Framework;

public class AutomationScriptingServiceImpl
implements AutomationScriptingService {
    protected String jsWrapper = null;
    protected ScriptOperationContext operationContext;
    protected final ThreadLocal<ScriptEngine> engines = new ThreadLocal<ScriptEngine>(){

        @Override
        protected ScriptEngine initialValue() {
            return ((ScriptEngineManager)Framework.getService(ScriptEngineManager.class)).getEngineByName("nx-nashorn");
        }
    };
    protected final ThreadLocal<ScriptOperationContext> operationContexts = new ThreadLocal<ScriptOperationContext>(){

        @Override
        protected ScriptOperationContext initialValue() {
            return new ScriptOperationContext();
        }
    };

    protected String getJSWrapper(boolean refresh) throws OperationException {
        if (this.jsWrapper == null || refresh) {
            StringBuffer sb = new StringBuffer();
            AutomationService as = (AutomationService)Framework.getService(AutomationService.class);
            HashMap<String, List<String>> opMap = new HashMap<String, List<String>>();
            ArrayList<String> flatOps = new ArrayList<String>();
            ArrayList<String> ids = new ArrayList<String>();
            for (OperationType op : as.getOperations()) {
                ids.add(op.getId());
                if (op.getAliases() == null) continue;
                Collections.addAll(ids, op.getAliases());
            }
            for (String id : ids) {
                this.parseAutomationIDSForScripting(opMap, flatOps, id);
            }
            for (String obName : opMap.keySet()) {
                List ops = (List)opMap.get(obName);
                sb.append("\nvar ").append(obName).append("={};");
                for (String opId : ops) {
                    this.generateFunction(sb, opId);
                }
            }
            for (String opId : flatOps) {
                this.generateFlatFunction(sb, opId);
            }
            this.jsWrapper = sb.toString();
        }
        return this.jsWrapper;
    }

    @Override
    public void setOperationContext(ScriptOperationContext ctx) {
        this.operationContext = this.operationContexts.get();
        this.operationContext = this.wrapContext(ctx);
    }

    protected ScriptOperationContext wrapContext(ScriptOperationContext ctx) {
        for (String entryId : ctx.keySet()) {
            Object entry = ctx.get(entryId);
            if (entry instanceof DocumentModel) {
                ctx.put(entryId, new DocumentWrapper(ctx.getCoreSession(), (DocumentModel)entry));
            }
            if (!(entry instanceof DocumentModelList)) continue;
            ArrayList<DocumentWrapper> docs = new ArrayList<DocumentWrapper>();
            for (DocumentModel doc : (DocumentModelList)entry) {
                docs.add(new DocumentWrapper(ctx.getCoreSession(), doc));
            }
            ctx.put(entryId, docs);
        }
        return ctx;
    }

    @Override
    public String getJSWrapper() throws OperationException {
        return this.getJSWrapper(false);
    }

    @Override
    public void run(InputStream in, CoreSession session) throws ScriptException, OperationException {
        try {
            this.run(IOUtils.toString((InputStream)in, (String)"UTF-8"), session);
        }
        catch (IOException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    @Override
    public void run(String script, CoreSession session) throws ScriptException, OperationException {
        ScriptEngine engine = this.engines.get();
        engine.setContext(new SimpleScriptContext());
        engine.eval(this.getJSWrapper());
        if (this.operationContext == null) {
            this.operationContext = this.operationContexts.get();
            this.operationContext.setCoreSession(session);
        }
        AutomationMapper automationMapper = new AutomationMapper(session, this.operationContext);
        engine.put("automation", automationMapper);
        engine.put("ctx", automationMapper.ctx.getVars());
        engine.put("Session", automationMapper.ctx.getCoreSession());
        PrincipalWrapper principalWrapper = new PrincipalWrapper((NuxeoPrincipal)automationMapper.ctx.getPrincipal());
        engine.put("CurrentUser", principalWrapper);
        engine.put("currentUser", principalWrapper);
        engine.put("Env", Framework.getProperties());
        engine.put("CurrentDate", new DateWrapper());
        if (automationMapper.ctx.get("WorkflowVariables") != null) {
            engine.put("WorkflowVariables", automationMapper.ctx.get("WorkflowVariables"));
        }
        if (automationMapper.ctx.get("NodeVariables") != null) {
            engine.put("NodeVariables", automationMapper.ctx.get("NodeVariables"));
        }
        ContextService contextService = (ContextService)Framework.getService(ContextService.class);
        Map helperFunctions = contextService.getHelperFunctions();
        for (String helperFunctionsId : helperFunctions.keySet()) {
            engine.put(helperFunctionsId, helperFunctions.get(helperFunctionsId));
        }
        engine.eval(script);
    }

    @Override
    public <T> T getInterface(Class<T> scriptingOperationInterface, String script, CoreSession session) throws ScriptException, OperationException {
        this.run(script, session);
        Invocable inv = (Invocable)((Object)this.engines.get());
        return inv.getInterface(scriptingOperationInterface);
    }

    protected void parseAutomationIDSForScripting(Map<String, List<String>> opMap, List<String> flatOps, String id) {
        if (id.split("\\.").length > 2) {
            return;
        }
        int idx = id.indexOf(".");
        if (idx > 0) {
            String obName = id.substring(0, idx);
            List<String> ops = opMap.get(obName);
            if (ops == null) {
                ops = new ArrayList<String>();
            }
            ops.add(id);
            opMap.put(obName, ops);
        } else {
            flatOps.add(id);
        }
    }

    protected void generateFunction(StringBuffer sb, String opId) {
        sb.append("\n" + AutomationScriptingServiceImpl.replaceDashByUnderscore(opId) + " = function(input,params) {");
        sb.append("\nreturn automation.executeOperation('" + opId + "', input , params);");
        sb.append("\n};");
    }

    protected void generateFlatFunction(StringBuffer sb, String opId) {
        sb.append("\nvar " + AutomationScriptingServiceImpl.replaceDashByUnderscore(opId) + " = function(input,params) {");
        sb.append("\nreturn automation.executeOperation('" + opId + "', input , params);");
        sb.append("\n};");
    }

    public static String replaceDashByUnderscore(String id) {
        return id.replaceAll("[\\s\\-()]", "_");
    }
}

