/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.filter;

import java.util.Map;
import org.apache.directory.shared.ldap.filter.AbstractExprNode;
import org.apache.directory.shared.ldap.filter.AssertionEnum;
import org.apache.directory.shared.ldap.filter.FilterVisitor;
import org.apache.directory.shared.ldap.message.DerefAliasesEnum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeNode
extends AbstractExprNode {
    private final int scope;
    private final String baseDn;
    private final DerefAliasesEnum derefAliases;

    public ScopeNode(DerefAliasesEnum derefAliases, String baseDn, int scope) {
        super(AssertionEnum.SCOPE);
        this.scope = scope;
        this.baseDn = baseDn;
        this.derefAliases = derefAliases;
    }

    public ScopeNode(Map<String, DerefAliasesEnum> env, String baseDn, int scope) {
        super(AssertionEnum.SCOPE);
        this.scope = scope;
        this.baseDn = baseDn;
        this.derefAliases = DerefAliasesEnum.getEnum(env);
    }

    @Override
    public boolean isLeaf() {
        return true;
    }

    public int getScope() {
        return this.scope;
    }

    public String getBaseDn() {
        return this.baseDn;
    }

    public DerefAliasesEnum getDerefAliases() {
        return this.derefAliases;
    }

    @Override
    public StringBuffer printToBuffer(StringBuffer buf) {
        switch (this.scope) {
            case 0: {
                buf.append("OBJECT_SCOPE");
                break;
            }
            case 1: {
                buf.append("ONELEVEL_SCOPE");
                break;
            }
            case 2: {
                buf.append("SUBTREE_SCOPE (Estimated)");
                break;
            }
            default: {
                buf.append("UNKNOWN");
            }
        }
        if (this.getAnnotations().containsKey("count")) {
            buf.append(" [");
            buf.append(this.getAnnotations().get("count").toString());
            buf.append(']');
        }
        return buf;
    }

    @Override
    public StringBuffer printRefinementToBuffer(StringBuffer a_buf) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("ScopeNode can't be part of a refinement");
    }

    @Override
    public void accept(FilterVisitor visitor) {
        if (visitor.canVisit(this)) {
            visitor.visit(this);
        }
    }
}

