/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.shared.ldap.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import org.apache.directory.shared.ldap.message.AttributeImpl;

public class AttributeSerializerUtils {
    private static final long serialVersionUID = -3756830073760754086L;
    static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    static final byte STRING_TYPE = 0;
    static final byte BYTE_ARRAY_TYPE = 1;

    public static final Object deserialize(byte[] buf) throws IOException {
        String id = AttributeSerializerUtils.readString(buf);
        AttributeImpl attr = new AttributeImpl(id);
        int pos = (id.length() << 1) + 4;
        if (buf[pos] == 0) {
            ++pos;
            while (pos < buf.length) {
                String value = AttributeSerializerUtils.readString(buf, pos);
                pos += (value.length() << 1) + 4;
                attr.add(value);
            }
        } else {
            ++pos;
            while (pos < buf.length) {
                byte[] value = AttributeSerializerUtils.readBytes(buf, pos);
                pos += value.length + 4;
                attr.add(value);
            }
        }
        return attr;
    }

    public static final DeserializedAttribute deserialize(byte[] buf, int offset) throws IOException {
        String id = AttributeSerializerUtils.readString(buf, offset);
        AttributeImpl attr = new AttributeImpl(id);
        int pos = (id.length() << 1) + 4 + offset;
        if (buf[pos] == 0) {
            ++pos;
            while (pos < buf.length) {
                String value = AttributeSerializerUtils.readString(buf, pos);
                pos += (value.length() << 1) + 4;
                attr.add(value);
            }
        } else {
            ++pos;
            while (pos < buf.length) {
                byte[] value = AttributeSerializerUtils.readBytes(buf, pos);
                pos += value.length + 4;
                attr.add(value);
            }
        }
        return new DeserializedAttribute(attr, pos);
    }

    static final String readString(byte[] buf) {
        int length = AttributeSerializerUtils.getLength(buf);
        if (length == 0) {
            return "";
        }
        char[] strchars = new char[length >> 1];
        int ch = 0;
        int jj = 0;
        for (int ii = 0; ii < strchars.length; ++ii) {
            jj = (ii << 1) + 4;
            ch = buf[jj] << 8 & 0xFF00;
            strchars[ii] = (char)(ch |= buf[jj + 1] & 0xFF);
        }
        return new String(strchars);
    }

    static final String readString(byte[] buf, int offset) {
        int length = AttributeSerializerUtils.getLength(buf, offset);
        if (length == 0) {
            return "";
        }
        char[] strchars = new char[length >> 1];
        int ch = 0;
        int jj = 0;
        for (int ii = 0; ii < strchars.length; ++ii) {
            jj = (ii << 1) + 4 + offset;
            ch = buf[jj] << 8 & 0xFF00;
            strchars[ii] = (char)(ch |= buf[jj + 1] & 0xFF);
        }
        return new String(strchars);
    }

    static final byte[] readBytes(byte[] buf, int offset) {
        int length = AttributeSerializerUtils.getLength(buf, offset);
        if (length == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] bites = new byte[length];
        System.arraycopy(buf, offset + 4, bites, 0, length);
        return bites;
    }

    public static final byte[] serialize(Object obj) throws IOException {
        Attribute attr = (Attribute)obj;
        ByteBuffer bb = ByteBuffer.allocate(4096);
        bb.hasRemaining();
        byte[] buf = new byte[AttributeSerializerUtils.calculateSize(attr)];
        int pos = AttributeSerializerUtils.write(buf, attr.getID());
        try {
            Object first = attr.get();
            if (first instanceof String) {
                buf[pos] = 0;
                ++pos;
                NamingEnumeration<?> ii = attr.getAll();
                while (ii.hasMore()) {
                    String value = (String)ii.next();
                    pos = AttributeSerializerUtils.write(buf, value, pos);
                }
            } else {
                buf[pos] = 1;
                ++pos;
                NamingEnumeration<?> ii = attr.getAll();
                while (ii.hasMore()) {
                    byte[] value = (byte[])ii.next();
                    pos = AttributeSerializerUtils.write(buf, value, pos);
                }
            }
        }
        catch (NamingException e) {
            IOException ioe = new IOException("Failed while accesssing attribute values.");
            ioe.initCause(e);
            throw ioe;
        }
        return buf;
    }

    static final int calculateSize(Attribute attr) throws IOException {
        int size = 4;
        size += attr.getID().length() << 1;
        ++size;
        try {
            NamingEnumeration<?> ii = attr.getAll();
            while (ii.hasMore()) {
                Object value = ii.next();
                size = value instanceof String ? (size += ((String)value).length() << 1) : (size += ((byte[])value).length);
                size += 4;
            }
        }
        catch (NamingException e) {
            IOException ioe = new IOException("Failed while accesssing attribute values.");
            ioe.initCause(e);
            throw ioe;
        }
        return size;
    }

    static final byte[] getLengthBytes(String str) {
        return AttributeSerializerUtils.getLengthBytes(str.length() << 1);
    }

    static final byte[] getLengthBytes(byte[] bites) {
        return AttributeSerializerUtils.getLengthBytes(bites.length);
    }

    static final byte[] getLengthBytes(int length) {
        byte[] lengthBytes = new byte[]{(byte)(length >> 24 & 0xFF), (byte)(length >> 16 & 0xFF), (byte)(length >> 8 & 0xFF), (byte)(length & 0xFF)};
        return lengthBytes;
    }

    static final int getLength(byte[] bites) {
        int length = bites[0] << 24 & 0xFF000000;
        length |= bites[1] << 16 & 0xFF0000;
        length |= bites[2] << 8 & 0xFF00;
        return length |= bites[3] & 0xFF;
    }

    static final int getLength(byte[] bites, int offset) {
        int length = bites[offset] << 24 & 0xFF000000;
        length |= bites[offset + 1] << 16 & 0xFF0000;
        length |= bites[offset + 2] << 8 & 0xFF00;
        return length |= bites[offset + 3] & 0xFF;
    }

    static final int write(byte[] buf, String value) {
        int pos = AttributeSerializerUtils.writeLengthBytes(buf, value.length() << 1);
        return AttributeSerializerUtils.writeValueBytes(buf, value, pos);
    }

    static final int write(byte[] buf, byte[] value) {
        int pos = AttributeSerializerUtils.writeLengthBytes(buf, value.length);
        return AttributeSerializerUtils.writeValueBytes(buf, value, pos);
    }

    static final int write(byte[] buf, String value, int offset) {
        offset = AttributeSerializerUtils.writeLengthBytes(buf, value.length() << 1, offset);
        return AttributeSerializerUtils.writeValueBytes(buf, value, offset);
    }

    static final int write(byte[] buf, byte[] value, int offset) {
        offset = AttributeSerializerUtils.writeLengthBytes(buf, value.length, offset);
        return AttributeSerializerUtils.writeValueBytes(buf, value, offset);
    }

    static final int writeValueBytes(byte[] buf, String value) {
        if (value.length() == 0) {
            return 0;
        }
        char[] strchars = value.toCharArray();
        int jj = 0;
        int ii = 0;
        while (ii < strchars.length) {
            buf[jj] = (byte)(strchars[ii] >> 8 & 0xFF);
            buf[jj + 1] = (byte)(strchars[ii] & 0xFF);
            jj = ++ii << 1;
        }
        return jj + 2;
    }

    static final int writeValueBytes(byte[] buf, String value, int offset) {
        if (value.length() == 0) {
            return offset;
        }
        char[] strchars = value.toCharArray();
        int jj = 0;
        int ii = 0;
        while (ii < strchars.length) {
            buf[jj + offset] = (byte)(strchars[ii] >> 8 & 0xFF);
            buf[jj + offset + 1] = (byte)(strchars[ii] & 0xFF);
            jj = ++ii << 1;
        }
        return jj + offset;
    }

    static final int writeValueBytes(byte[] buf, byte[] value, int offset) {
        if (value.length == 0) {
            return offset;
        }
        System.arraycopy(value, 0, buf, offset, value.length);
        return offset + value.length;
    }

    static final int writeLengthBytes(byte[] buf, int length) {
        buf[0] = (byte)(length >> 24 & 0xFF);
        buf[1] = (byte)(length >> 16 & 0xFF);
        buf[2] = (byte)(length >> 8 & 0xFF);
        buf[3] = (byte)(length & 0xFF);
        return 4;
    }

    static final int writeLengthBytes(byte[] buf, int length, int offset) {
        buf[0 + offset] = (byte)(length >> 24 & 0xFF);
        buf[1 + offset] = (byte)(length >> 16 & 0xFF);
        buf[2 + offset] = (byte)(length >> 8 & 0xFF);
        buf[3 + offset] = (byte)(length & 0xFF);
        return offset + 4;
    }

    static final class DeserializedAttribute {
        private final int pos;
        private final Attribute attr;

        private DeserializedAttribute(Attribute attr, int pos) {
            this.pos = pos;
            this.attr = attr;
        }

        public int getPos() {
            return this.pos;
        }

        public Attribute getAttr() {
            return this.attr;
        }
    }
}

