/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteException;

public interface GraphNode {
    public static final String MERGE_ONE = "one";
    public static final String MERGE_ALL = "all";
    public static final String PROP_NODE_ID = "rnode:nodeId";
    public static final String PROP_TITLE = "dc:title";
    public static final String PROP_START = "rnode:start";
    public static final String PROP_STOP = "rnode:stop";
    public static final String PROP_MERGE = "rnode:merge";
    public static final String PROP_COUNT = "rnode:count";
    public static final String PROP_CANCELED = "rnode:canceled";
    public static final String PROP_INPUT_CHAIN = "rnode:inputChain";
    public static final String PROP_OUTPUT_CHAIN = "rnode:outputChain";
    public static final String PROP_HAS_TASK = "rnode:hasTask";
    public static final String PROP_VARIABLES_FACET = "rnode:variablesFacet";
    public static final String PROP_TRANSITIONS = "rnode:transitions";
    public static final String PROP_TRANS_NAME = "name";
    public static final String PROP_TRANS_TARGET = "targetId";
    public static final String PROP_TRANS_CONDITION = "condition";
    public static final String PROP_TRANS_RESULT = "result";
    public static final String PROP_TRANS_CHAIN = "chain";
    public static final String PROP_TRANS_LABEL = "label";
    public static final String PROP_TRANS_PATH = "path";
    public static final String PROP_TASK_ASSIGNEES = "rnode:taskAssignees";
    public static final String PROP_TASK_ASSIGNEES_VAR = "rnode:taskAssigneesExpr";
    public static final String PROP_TASK_ASSIGNEES_PERMISSION = "rnode:taskAssigneesPermission";
    public static final String PROP_TASK_DUE_DATE = "rnode:taskDueDate";
    public static final String PROP_TASK_DIRECTIVE = "rnode:taskDirective";
    public static final String PROP_TASK_LAYOUT = "rnode:taskLayout";
    public static final String PROP_TASK_BUTTONS = "rnode:taskButtons";
    public static final String PROP_BTN_NAME = "name";
    public static final String PROP_BTN_LABEL = "label";
    public static final String PROP_BTN_FILTER = "filter";
    public static final String PROP_NODE_X_COORDINATE = "rnode:taskX";
    public static final String PROP_NODE_Y_COORDINATE = "rnode:taskY";
    public static final String PROP_NODE_BUTTON = "rnode:button";
    public static final String PROP_NODE_START_DATE = "rnode:startDate";
    public static final String PROP_NODE_END_DATE = "rnode:endDate";
    public static final String PROP_NODE_LAST_ACTOR = "rnode:lastActor";
    public static final String PROP_TASK_DOC_TYPE = "rnode:taskDocType";
    public static final String PROP_TASK_NOTIFICATION_TEMPLATE = "rnode:taskNotificationTemplate";
    public static final String PROP_TASK_DUE_DATE_EXPR = "rnode:taskDueDateExpr";
    public static final String PROP_EXECUTE_ONLY_FIRST_TRANSITION = "rnode:executeOnlyFirstTransition";
    public static final String PROP_SUB_ROUTE_MODEL_EXPR = "rnode:subRouteModelExpr";
    public static final String PROP_SUB_ROUTE_INSTANCE_ID = "rnode:subRouteInstanceId";
    public static final String PROP_SUB_ROUTE_VARS = "rnode:subRouteVariables";
    public static final String PROP_KEYVALUE_KEY = "key";
    public static final String PROP_KEYVALUE_VALUE = "value";
    public static final String PROP_ESCALATION_RULES = "rnode:escalationRules";
    public static final String PROP_ESCALATION_RULE_ID = "name";
    public static final String PROP_ESCALATION_RULE_LABEL = "label";
    public static final String PROP_ESCALATION_RULE_MULTIPLE_EXECUTION = "multipleExecution";
    public static final String PROP_ESCALATION_RULE_CONDITION = "condition";
    public static final String PROP_ESCALATION_RULE_CHAIN = "chain";
    public static final String PROP_ESCALATION_RULE_EXECUTED = "executed";
    public static final String PROP_LAST_EXECUTION_TIME = "executionDate";
    public static final String PROP_HAS_MULTIPLE_TASKS = "rnode:hasMultipleTasks";
    public static final String PROP_TASKS_INFO = "rnode:tasksInfo";
    public static final String PROP_TASK_INFO_ACTOR = "actor";
    public static final String PROP_TASK_INFO_COMMENT = "comment";
    public static final String PROP_TASK_INFO_STATUS = "status";
    public static final String PROP_TASK_INFO_ENDED = "ended";
    public static final String PROP_TASK_INFO_TASK_DOC_ID = "taskDocId";
    public static final String PROP_ALLOW_TASK_REASSIGNMENT = "rnode:allowTaskReassignment";
    public static final String NODE_VARIABLE_COMMENT = "comment";

    public String getId();

    public State getState();

    public void setState(State var1);

    public boolean isStart();

    public boolean isStop();

    public boolean isMerge();

    public boolean canMerge();

    public void setCanceled();

    public long getCanceledCount();

    public void cancelTasks();

    public String getInputChain();

    public String getOutputChain();

    public boolean hasTask();

    public List<String> getTaskAssignees();

    public Date getTaskDueDate();

    public String getTaskDirective();

    public String getTaskAssigneesPermission();

    public String getTaskLayout();

    public String getTaskDocType();

    public String getTaskNotificationTemplate();

    public void starting();

    public void ending();

    public void executeChain(String var1) throws DocumentRouteException;

    public void initAddInputTransition(Transition var1);

    public List<Transition> getInputTransitions();

    public List<Transition> getOutputTransitions();

    public String getTaskDueDateExpr();

    public void executeTransitionChain(Transition var1) throws DocumentRouteException;

    public List<Transition> evaluateTransitions() throws DocumentRouteException;

    public void setAllVariables(Map<String, Object> var1);

    public void setAllVariables(Map<String, Object> var1, boolean var2);

    public List<Button> getTaskButtons();

    public boolean hasTaskButton(String var1);

    public DocumentModel getDocument();

    public Map<String, Serializable> getVariables();

    public Map<String, Serializable> getJsonVariables();

    public void setButton(String var1);

    public void setLastActor(String var1);

    public List<String> evaluateTaskAssignees() throws DocumentRouteException;

    public Date computeTaskDueDate() throws DocumentRouteException;

    public Map<String, Serializable> getWorkflowContextualInfo(CoreSession var1, boolean var2);

    public boolean executeOnlyFirstTransition();

    public boolean hasSubRoute() throws DocumentRouteException;

    public String getSubRouteModelId() throws DocumentRouteException;

    public DocumentRoute startSubRoute() throws DocumentRouteException;

    public void cancelSubRoute() throws DocumentRouteException;

    public List<EscalationRule> evaluateEscalationRules();

    public List<EscalationRule> getEscalationRules();

    public boolean hasMultipleTasks();

    public List<TaskInfo> getTasksInfo();

    public void addTaskInfo(String var1);

    public void updateTaskInfo(String var1, boolean var2, String var3, String var4, String var5);

    public List<TaskInfo> getEndedTasksInfo();

    public List<TaskInfo> getProcessedTasksInfo();

    public boolean hasOpenTasks();

    public boolean allowTaskReassignment();

    public void setVariable(String var1, String var2);

    public void setVariables(Map<String, Serializable> var1);

    public void setJSONVariables(Map<String, String> var1);

    public void removeTaskInfo(String var1);

    public static class TaskInfo
    implements Comparable<TaskInfo>,
    Serializable {
        protected String taskDocId;
        protected String actor;
        protected String comment;
        protected String status;
        protected boolean ended;
        protected MapProperty prop;
        protected GraphNode node;

        public TaskInfo(GraphNode node, Property p) {
            this.prop = (MapProperty)p;
            this.node = node;
            this.taskDocId = (String)((Object)p.get(GraphNode.PROP_TASK_INFO_TASK_DOC_ID).getValue());
            this.status = (String)((Object)p.get(GraphNode.PROP_TASK_INFO_STATUS).getValue());
            this.actor = (String)((Object)p.get(GraphNode.PROP_TASK_INFO_ACTOR).getValue());
            this.comment = (String)((Object)p.get("comment").getValue());
            Property ended = this.prop.get(GraphNode.PROP_TASK_INFO_ENDED);
            if (ended != null) {
                this.ended = BooleanUtils.isTrue((Boolean)((Boolean)ended.getValue(Boolean.class)));
            }
        }

        public TaskInfo(GraphNode node, String taskDocId) {
            this.node = node;
            this.prop = (MapProperty)((ListProperty)node.getDocument().getProperty(GraphNode.PROP_TASKS_INFO)).addEmpty();
            this.prop.get(GraphNode.PROP_TASK_INFO_TASK_DOC_ID).setValue((Object)taskDocId);
            this.taskDocId = taskDocId;
        }

        @Override
        public int compareTo(TaskInfo o) {
            return this.taskDocId.compareTo(o.taskDocId);
        }

        public String getTaskDocId() {
            return this.taskDocId;
        }

        public String getActor() {
            return this.actor;
        }

        public String getComment() {
            return this.comment;
        }

        public String getStatus() {
            return this.status;
        }

        public GraphNode getNode() {
            return this.node;
        }

        public boolean isEnded() {
            return this.ended;
        }

        public void setComment(String comment) {
            this.comment = comment;
            this.prop.get("comment").setValue((Object)comment);
        }

        public void setStatus(String status) {
            this.status = status;
            this.prop.get(GraphNode.PROP_TASK_INFO_STATUS).setValue((Object)status);
        }

        public void setActor(String actor) {
            this.actor = actor;
            this.prop.get(GraphNode.PROP_TASK_INFO_ACTOR).setValue((Object)actor);
        }

        public void setEnded(boolean ended) {
            this.ended = ended;
            this.prop.get(GraphNode.PROP_TASK_INFO_ENDED).setValue((Object)ended);
        }
    }

    public static class EscalationRule
    implements Comparable<EscalationRule> {
        protected String id;
        protected String label;
        protected boolean multipleExecution;
        protected String condition;
        protected boolean executed;
        protected String chain;
        protected MapProperty prop;
        protected GraphNode node;
        protected Calendar lastExcutionTime;

        public EscalationRule(GraphNode node, Property p) {
            this.prop = (MapProperty)p;
            this.node = node;
            this.id = (String)((Object)p.get("name").getValue());
            this.label = (String)((Object)p.get("label").getValue());
            Property multipleEvaluationProp = this.prop.get(GraphNode.PROP_ESCALATION_RULE_MULTIPLE_EXECUTION);
            if (multipleEvaluationProp != null) {
                this.multipleExecution = BooleanUtils.isTrue((Boolean)((Boolean)multipleEvaluationProp.getValue(Boolean.class)));
            }
            this.condition = (String)((Object)p.get("condition").getValue());
            Property evaluatedProp = this.prop.get(GraphNode.PROP_ESCALATION_RULE_EXECUTED);
            if (evaluatedProp != null) {
                this.executed = BooleanUtils.isTrue((Boolean)((Boolean)evaluatedProp.getValue(Boolean.class)));
            }
            this.chain = (String)((Object)p.get("chain").getValue());
            this.lastExcutionTime = (Calendar)p.get(GraphNode.PROP_LAST_EXECUTION_TIME).getValue();
        }

        @Override
        public int compareTo(EscalationRule o) {
            return this.id.compareTo(o.id);
        }

        public String getLabel() {
            return this.label;
        }

        public String getChain() {
            return this.chain;
        }

        public GraphNode getNode() {
            return this.node;
        }

        public void setExecuted(boolean executed) {
            this.executed = executed;
            this.prop.get(GraphNode.PROP_ESCALATION_RULE_EXECUTED).setValue((Object)executed);
            if (executed) {
                this.setExecutionTime(Calendar.getInstance());
            }
        }

        protected void setExecutionTime(Calendar time) {
            this.prop.get(GraphNode.PROP_LAST_EXECUTION_TIME).setValue((Object)time);
            this.lastExcutionTime = time;
        }

        public boolean isExecuted() {
            return this.executed;
        }

        public String getId() {
            return this.id;
        }

        public boolean isMultipleExecution() {
            return this.multipleExecution;
        }

        public Calendar getLastExecutionTime() {
            if (this.executed && this.lastExcutionTime != null) {
                return this.lastExcutionTime;
            }
            return null;
        }
    }

    public static class Button
    implements Comparable<Button> {
        public GraphNode source;
        public String name;
        public String label;
        public String filter;
        public MapProperty prop;

        public Button(GraphNode source, Property p) {
            this.source = source;
            this.prop = (MapProperty)p;
            this.name = (String)((Object)this.prop.get("name").getValue());
            this.label = (String)((Object)this.prop.get("label").getValue());
            this.filter = (String)((Object)this.prop.get(GraphNode.PROP_BTN_FILTER).getValue());
        }

        @Override
        public int compareTo(Button other) {
            return this.name.compareTo(other.name);
        }

        public String getLabel() {
            return this.label;
        }

        public String getName() {
            return this.name;
        }

        public String getFilter() {
            return this.filter;
        }
    }

    public static class Transition
    implements Comparable<Transition>,
    Serializable {
        public GraphNode source;
        public MapProperty prop;
        public String id;
        public String condition;
        public String chain;
        public String target;
        public String label;
        public boolean result;
        public List<Point> path;
        public boolean loop;

        protected Transition(GraphNode source, Property p) {
            this.source = source;
            this.prop = (MapProperty)p;
            this.id = (String)((Object)this.prop.get("name").getValue());
            this.condition = (String)((Object)this.prop.get("condition").getValue());
            this.chain = (String)((Object)this.prop.get("chain").getValue());
            this.target = (String)((Object)this.prop.get(GraphNode.PROP_TRANS_TARGET).getValue());
            this.label = (String)((Object)this.prop.get("label").getValue());
            Property resultProp = this.prop.get(GraphNode.PROP_TRANS_RESULT);
            if (resultProp != null) {
                this.result = BooleanUtils.isTrue((Boolean)((Boolean)resultProp.getValue(Boolean.class)));
            }
        }

        protected void setResult(boolean bool) {
            this.result = bool;
            this.prop.get(GraphNode.PROP_TRANS_RESULT).setValue((Object)bool);
        }

        @Override
        public int compareTo(Transition other) {
            return this.id.compareTo(other.id);
        }

        public String toString() {
            return new ToStringBuilder((Object)this).append("id", (Object)this.id).append("condition", (Object)this.condition).append(GraphNode.PROP_TRANS_RESULT, this.result).toString();
        }

        public String getTarget() {
            return this.target;
        }

        public String getId() {
            return this.id;
        }

        public String getLabel() {
            return this.label;
        }

        public List<Point> getPath() {
            if (this.path == null) {
                this.path = this.computePath();
            }
            return this.path;
        }

        protected List<Point> computePath() {
            ListProperty props = (ListProperty)this.prop.get(GraphNode.PROP_TRANS_PATH);
            ArrayList<Point> points = new ArrayList<Point>(props.size());
            for (Property p : props) {
                points.add(new Point((Double)p.get("x").getValue(), (Double)p.get("y").getValue()));
            }
            return points;
        }
    }

    public static class Point {
        public double x;
        public double y;

        public Point(double x, double y) {
            this.x = x;
            this.y = y;
        }
    }

    public static enum State {
        READY("ready", "toReady"),
        WAITING("waiting", "toWaiting"),
        RUNNING_INPUT,
        SUSPENDED("suspended", "toSuspended"),
        RUNNING_OUTPUT;

        private final String lifeCycleState;
        private final String transition;

        private State() {
            this.lifeCycleState = null;
            this.transition = null;
        }

        private State(String lifeCycleState, String transition) {
            this.lifeCycleState = lifeCycleState;
            this.transition = transition;
        }

        public String getLifeCycleState() {
            return this.lifeCycleState;
        }

        public String getTransition() {
            return this.transition;
        }

        public static State fromString(String s) {
            try {
                return State.valueOf(s.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(s);
            }
        }
    }
}

