/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.web.auth.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginProviderLink;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginProviderLinkComputer;
import org.nuxeo.ecm.platform.ui.web.auth.service.LoginVideo;
import org.nuxeo.runtime.api.Framework;

@XObject(value="loginScreenConfig")
public class LoginScreenConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XNodeList(value="loginProviders/loginProvider", type=ArrayList.class, componentType=LoginProviderLink.class)
    protected List<LoginProviderLink> providers;
    @XNodeList(value="videos/video", type=ArrayList.class, componentType=LoginVideo.class)
    protected List<LoginVideo> videos;
    @XNode(value="videos@muted")
    protected Boolean muted;
    @XNode(value="videos@loop")
    protected Boolean loop;
    protected String backgroundImage;
    @XNode(value="removeNews")
    protected Boolean removeNews = false;
    protected String headerStyle;
    protected String footerStyle;
    protected String newsIframeUrl = "//www.nuxeo.com/standalone-login-page/";
    protected String newsIframeFullUrl = null;
    protected String bodyBackgroundStyle;
    protected String loginBoxBackgroundStyle;
    @XNode(value="loginBoxWidth")
    protected String loginBoxWidth;
    protected String logoUrl;
    @XNode(value="logoAlt")
    protected String logoAlt;
    @XNode(value="logoWidth")
    protected String logoWidth;
    @XNode(value="logoHeight")
    protected String logoHeight;
    @XNode(value="fieldAutocomplete")
    protected Boolean fieldAutocomplete;
    @XNode(value="disableBackgroundSizeCover")
    protected Boolean disableBackgroundSizeCover;
    @XNode(value="loginButtonBackgroundColor")
    protected String loginButtonBackgroundColor;

    public List<LoginProviderLink> getProviders() {
        return this.providers;
    }

    public void setProviders(List<LoginProviderLink> providers) {
        this.providers = providers;
    }

    public LoginProviderLink getProvider(String name) {
        if (this.getProviders() == null) {
            return null;
        }
        for (LoginProviderLink provider : this.getProviders()) {
            if (!name.equals(provider.getName())) continue;
            return provider;
        }
        return null;
    }

    public void registerLoginProvider(String name, String iconUrl, String link, String label, String description, LoginProviderLinkComputer computer) {
        LoginProviderLink existingProvider;
        LoginProviderLink newProvider = new LoginProviderLink();
        newProvider.name = name;
        newProvider.iconPath = iconUrl;
        newProvider.link = link;
        newProvider.label = label;
        newProvider.description = description;
        if (computer != null) {
            newProvider.urlComputer = computer;
        }
        if ((existingProvider = this.getProvider(name)) != null) {
            existingProvider.merge(newProvider);
        } else {
            if (this.providers == null) {
                this.providers = new ArrayList<LoginProviderLink>();
            }
            this.providers.add(newProvider);
        }
    }

    public String getHeaderStyle() {
        return this.headerStyle;
    }

    public String getFooterStyle() {
        return this.footerStyle;
    }

    public String getBodyBackgroundStyle() {
        return this.bodyBackgroundStyle;
    }

    public String getLoginBoxBackgroundStyle() {
        return this.loginBoxBackgroundStyle;
    }

    public String getLoginBoxWidth() {
        return this.loginBoxWidth;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public String getLogoAlt() {
        return this.logoAlt;
    }

    public String getLogoWidth() {
        return this.logoWidth;
    }

    public String getLogoHeight() {
        return this.logoHeight;
    }

    public List<LoginVideo> getVideos() {
        return this.videos;
    }

    public Boolean getVideoMuted() {
        return this.muted == null ? false : this.muted;
    }

    public Boolean getVideoLoop() {
        return this.loop == null ? true : this.loop;
    }

    public boolean hasVideos() {
        return this.videos != null && !this.videos.isEmpty();
    }

    public boolean getDisplayNews() {
        return this.removeNews == false && !StringUtils.isBlank((String)this.newsIframeUrl);
    }

    public Boolean getFieldAutocomplete() {
        return this.fieldAutocomplete == null ? true : this.fieldAutocomplete;
    }

    @XNode(value="headerStyle")
    public void setHeaderStyle(String headerStyle) {
        this.headerStyle = Framework.expandVars((String)headerStyle);
    }

    @XNode(value="footerStyle")
    public void setFooterStyle(String footerStyle) {
        this.footerStyle = Framework.expandVars((String)footerStyle);
    }

    @XNode(value="bodyBackgroundStyle")
    public void setBodyBackgroundStyle(String bodyBackgroundStyle) {
        this.bodyBackgroundStyle = Framework.expandVars((String)bodyBackgroundStyle);
    }

    @XNode(value="backgroundImage")
    public void setBackgroundImage(String backgroundImage) {
        this.backgroundImage = Framework.expandVars((String)backgroundImage);
    }

    public String getBackgroundImage() {
        return this.backgroundImage;
    }

    public String getLoginButtonBackgroundColor() {
        return this.loginButtonBackgroundColor;
    }

    @XNode(value="loginBoxBackgroundStyle")
    public void setLoginBoxBackgroundStyle(String loginBoxBackgroundStyle) {
        this.loginBoxBackgroundStyle = Framework.expandVars((String)loginBoxBackgroundStyle);
    }

    @XNode(value="logoUrl")
    public void setLogoUrl(String logoUrl) {
        this.logoUrl = Framework.expandVars((String)logoUrl);
    }

    @XNode(value="newsIframeUrl")
    public void setNewsIframeUrl(String newsIframeUrl) {
        this.newsIframeUrl = newsIframeUrl;
        this.newsIframeFullUrl = null;
    }

    public String getNewsIframeUrl() {
        if (this.newsIframeFullUrl == null) {
            this.newsIframeFullUrl = UriBuilder.fromPath((String)this.newsIframeUrl).queryParam("org.nuxeo.ecm.product.version", new Object[]{Framework.getProperty((String)"org.nuxeo.ecm.product.version")}).queryParam("org.nuxeo.distribution.version", new Object[]{Framework.getProperty((String)"org.nuxeo.distribution.version")}).build(new Object[0]).toString();
        }
        return this.newsIframeFullUrl;
    }

    public Boolean getDisableBackgroundSizeCover() {
        return this.disableBackgroundSizeCover;
    }

    protected void merge(LoginScreenConfig newConfig) {
        if (newConfig.newsIframeUrl != null) {
            this.setNewsIframeUrl(newConfig.newsIframeUrl);
        }
        if (newConfig.headerStyle != null) {
            this.headerStyle = newConfig.headerStyle;
        }
        if (newConfig.footerStyle != null) {
            this.footerStyle = newConfig.footerStyle;
        }
        if (newConfig.bodyBackgroundStyle != null) {
            this.bodyBackgroundStyle = newConfig.bodyBackgroundStyle;
        }
        if (newConfig.loginBoxBackgroundStyle != null) {
            this.loginBoxBackgroundStyle = newConfig.loginBoxBackgroundStyle;
        }
        if (newConfig.loginBoxWidth != null) {
            this.loginBoxWidth = newConfig.loginBoxWidth;
        }
        if (newConfig.disableBackgroundSizeCover != null) {
            this.disableBackgroundSizeCover = newConfig.disableBackgroundSizeCover;
        }
        if (newConfig.logoAlt != null) {
            this.logoAlt = newConfig.logoAlt;
        }
        if (newConfig.logoHeight != null) {
            this.logoHeight = newConfig.logoHeight;
        }
        if (newConfig.logoUrl != null) {
            this.logoUrl = newConfig.logoUrl;
        }
        if (newConfig.logoWidth != null) {
            this.logoWidth = newConfig.logoWidth;
        }
        if (newConfig.fieldAutocomplete != null) {
            this.fieldAutocomplete = newConfig.fieldAutocomplete;
        }
        if (newConfig.videos != null) {
            this.videos = newConfig.videos;
        }
        if (newConfig.loop != null) {
            this.loop = newConfig.loop;
        }
        if (newConfig.removeNews.booleanValue()) {
            this.removeNews = newConfig.removeNews;
        }
        if (newConfig.muted != null) {
            this.muted = newConfig.muted;
        }
        if (newConfig.loginButtonBackgroundColor != null) {
            this.loginButtonBackgroundColor = newConfig.loginButtonBackgroundColor;
        }
        if (newConfig.backgroundImage != null) {
            this.backgroundImage = newConfig.backgroundImage;
        }
        if (this.providers == null) {
            this.providers = newConfig.providers;
        } else if (newConfig.providers != null && newConfig.providers.size() > 0) {
            for (LoginProviderLink link : newConfig.providers) {
                int idx = this.providers.indexOf(link);
                if (idx >= 0) {
                    if (link.remove) {
                        this.providers.remove(idx);
                        continue;
                    }
                    this.providers.get(idx).merge(link);
                    continue;
                }
                this.providers.add(link);
            }
        }
    }

    public LoginScreenConfig clone() {
        LoginScreenConfig clone = new LoginScreenConfig();
        clone.bodyBackgroundStyle = this.bodyBackgroundStyle;
        clone.disableBackgroundSizeCover = this.disableBackgroundSizeCover;
        clone.fieldAutocomplete = this.fieldAutocomplete;
        clone.footerStyle = this.footerStyle;
        clone.headerStyle = this.headerStyle;
        clone.loginBoxBackgroundStyle = this.loginBoxBackgroundStyle;
        clone.loginBoxWidth = this.loginBoxWidth;
        clone.loginButtonBackgroundColor = this.loginButtonBackgroundColor;
        clone.logoAlt = this.logoAlt;
        clone.logoHeight = this.logoHeight;
        clone.logoUrl = this.logoUrl;
        clone.logoWidth = this.logoWidth;
        clone.loop = this.loop;
        clone.muted = this.muted;
        clone.newsIframeUrl = this.newsIframeUrl;
        if (this.providers != null) {
            clone.providers = new ArrayList<LoginProviderLink>();
            for (LoginProviderLink l : this.providers) {
                clone.providers.add(l.clone());
            }
        }
        clone.removeNews = this.removeNews;
        if (this.videos != null) {
            clone.videos = new ArrayList<LoginVideo>();
            for (LoginVideo v : this.videos) {
                clone.videos.add(v.clone());
            }
        }
        return clone;
    }
}

