/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.profile;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.annotation.Experimental;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.impl.blob.FileBlob;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.core.schema.types.Field;
import org.nuxeo.ecm.core.schema.types.ListType;
import org.nuxeo.ecm.core.schema.types.SimpleTypeImpl;
import org.nuxeo.ecm.core.schema.types.Type;
import org.nuxeo.ecm.core.schema.types.primitives.BooleanType;
import org.nuxeo.ecm.core.schema.types.primitives.DateType;
import org.nuxeo.ecm.core.schema.types.primitives.DoubleType;
import org.nuxeo.ecm.core.schema.types.primitives.IntegerType;
import org.nuxeo.ecm.core.schema.types.primitives.LongType;
import org.nuxeo.ecm.core.schema.types.primitives.StringType;
import org.nuxeo.ecm.user.center.profile.ImporterConfig;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.transaction.TransactionHelper;

@Experimental(comment="https://jira.nuxeo.com/browse/NXP-12200")
public class UserProfileImporter {
    private static final Log log = LogFactory.getLog(UserProfileImporter.class);
    public static final String CONTENT_FILED_TYPE_NAME = "content";
    public static final String USER_PROFILE_IMPORTER_USERNAME_COL = "username";
    protected Character escapeCharacter = Character.valueOf('\\');
    protected ImporterConfig config;
    protected String dataFileName;
    protected transient DateFormat dateformat;
    protected final Date startDate = new Date();
    protected long totalRecords = 0L;
    protected long currentRecord = 0L;
    public static final String BLOB_FOLDER_PROPERTY = "nuxeo.csv.blobs.folder";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImport(CoreSession session) {
        UserProfileService ups = (UserProfileService)Framework.getLocalService(UserProfileService.class);
        this.config = ups.getImporterConfig();
        if (this.config == null) {
            log.error((Object)"No importer configuration could be found");
            return;
        }
        this.dataFileName = this.config.getDataFileName();
        if (this.dataFileName == null) {
            log.error((Object)"No importer dataFileName was supplied");
            return;
        }
        InputStream is = this.getResourceAsStream(this.dataFileName);
        if (is == null) {
            log.error((Object)("Error locating CSV data file: " + this.dataFileName));
            return;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(is));
        CSVParser parser = null;
        try {
            parser = CSVFormat.DEFAULT.withEscape(this.escapeCharacter).withHeader(new String[0]).parse((Reader)in);
            this.doImport(session, parser, ups);
        }
        catch (IOException e) {
            log.error((Object)"Unable to read CSV file", (Throwable)e);
        }
        finally {
            if (parser != null) {
                try {
                    parser.close();
                }
                catch (IOException e) {
                    log.debug((Object)e, (Throwable)e);
                }
            }
        }
    }

    protected InputStream getResourceAsStream(String resource) {
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(resource);
        if (is == null && (is = Framework.getResourceLoader().getResourceAsStream(resource)) == null) {
            return null;
        }
        return is;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doImport(CoreSession session, CSVParser parser, UserProfileService userProfileService) throws IOException {
        log.info((Object)String.format("Importing CSV file: %s", this.dataFileName));
        DocumentType docType = ((SchemaManager)Framework.getLocalService(SchemaManager.class)).getDocumentType("UserProfile");
        if (docType == null) {
            log.error((Object)"The type UserProfile does not exist");
            return;
        }
        Map header = parser.getHeaderMap();
        if (header == null) {
            log.error((Object)"No header line, empty file?");
            return;
        }
        Integer nameIndex = (Integer)header.get(USER_PROFILE_IMPORTER_USERNAME_COL);
        if (nameIndex == null) {
            log.error((Object)"Missing 'username' column");
            return;
        }
        long docsUpdatedCount = 0L;
        this.totalRecords = parser.getRecordNumber();
        try {
            int batchSize = this.config.getBatchSize();
            long lineNumber = 0L;
            for (CSVRecord record : parser.getRecords()) {
                this.currentRecord = ++lineNumber;
                try {
                    if (!this.importLine(record, lineNumber, nameIndex, docType, session, userProfileService, header) || ++docsUpdatedCount % (long)batchSize != 0L) continue;
                    this.commitOrRollbackTransaction();
                    this.startTransaction();
                }
                catch (NuxeoException e) {
                    Throwable unwrappedException = UserProfileImporter.unwrapException(e);
                    this.logImportError(lineNumber, "Error while importing line: %s", unwrappedException.getMessage());
                    log.debug((Object)unwrappedException, unwrappedException);
                }
            }
            session.save();
        }
        finally {
            this.commitOrRollbackTransaction();
            this.startTransaction();
        }
        log.info((Object)String.format("Done importing %s entries from CSV file: %s", docsUpdatedCount, this.dataFileName));
    }

    protected boolean importLine(CSVRecord record, long lineNumber, Integer nameIndex, DocumentType docType, CoreSession session, UserProfileService userProfileService, Map<String, Integer> headerValues) {
        String name = record.get(nameIndex.intValue());
        if (StringUtils.isBlank((String)name)) {
            this.logImportError(lineNumber, "Missing 'name' value", "label.csv.importer.missingNameValue");
            return false;
        }
        Map<String, Serializable> values = this.computePropertiesMap(lineNumber, docType, headerValues, record);
        if (values == null) {
            return false;
        }
        return this.updateDocument(lineNumber, name, docType, session, userProfileService, values);
    }

    protected Map<String, Serializable> computePropertiesMap(long lineNumber, DocumentType docType, Map<String, Integer> headerValues, CSVRecord record) {
        HashMap<String, Serializable> values = new HashMap<String, Serializable>();
        for (String headerValue : headerValues.keySet()) {
            String lineValue = record.get(headerValue);
            lineValue = lineValue.trim();
            String fieldName = headerValue;
            if (USER_PROFILE_IMPORTER_USERNAME_COL.equals(headerValue)) continue;
            if (!docType.hasField(fieldName)) {
                fieldName = fieldName.split(":")[1];
            }
            if (!docType.hasField(fieldName) || StringUtils.isBlank((String)lineValue)) continue;
            Serializable convertedValue = this.convertValue(docType, fieldName, headerValue, lineValue, lineNumber);
            if (convertedValue == null) {
                return null;
            }
            values.put(headerValue, convertedValue);
        }
        return values;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Serializable convertValue(DocumentType docType, String fieldName, String headerValue, String stringValue, long lineNumber) {
        if (docType.hasField(fieldName)) {
            Field field = docType.getField(fieldName);
            if (field == null) return null;
            try {
                FileBlob fieldValue = null;
                Type fieldType = field.getType();
                if (fieldType.isComplexType()) {
                    if (!fieldType.getName().equals(CONTENT_FILED_TYPE_NAME)) return fieldValue;
                    String blobsFolderPath = Framework.getProperty((String)BLOB_FOLDER_PROPERTY);
                    String path = FilenameUtils.normalize((String)(blobsFolderPath + "/" + stringValue));
                    File file = new File(path);
                    if (file.exists()) {
                        FileBlob blob = new FileBlob(file);
                        blob.setFilename(file.getName());
                        return blob;
                    }
                    this.logImportError(lineNumber, "The file '%s' does not exist", stringValue);
                    return null;
                }
                if (fieldType.isListType()) {
                    Type listFieldType = ((ListType)fieldType).getFieldType();
                    if (!listFieldType.isSimpleType()) return (Serializable)((Object)Arrays.asList(stringValue.split(this.config.getListSeparatorRegex())));
                    return stringValue.split(this.config.getListSeparatorRegex());
                }
                Type type = field.getType();
                if (type instanceof SimpleTypeImpl) {
                    type = type.getSuperType();
                }
                if (!type.isSimpleType()) return fieldValue;
                if (type instanceof StringType) {
                    return stringValue;
                }
                if (type instanceof IntegerType) {
                    return Integer.valueOf(stringValue);
                }
                if (type instanceof LongType) {
                    return Long.valueOf(stringValue);
                }
                if (type instanceof DoubleType) {
                    return Double.valueOf(stringValue);
                }
                if (type instanceof BooleanType) {
                    return Boolean.valueOf(stringValue);
                }
                if (!(type instanceof DateType)) return fieldValue;
                return this.getDateFormat().parse(stringValue);
            }
            catch (ParseException pe) {
                this.logImportError(lineNumber, "Unable to convert field '%s' with value '%s'", headerValue, stringValue);
                log.debug((Object)pe, (Throwable)pe);
                return null;
            }
            catch (NumberFormatException nfe) {
                this.logImportError(lineNumber, "Unable to convert field '%s' with value '%s'", headerValue, stringValue);
                log.debug((Object)nfe, (Throwable)nfe);
                return null;
            }
        } else {
            this.logImportError(lineNumber, "Field '%s' does not exist on type '%s'", headerValue, docType.getName());
        }
        return null;
    }

    protected DateFormat getDateFormat() {
        if (this.dateformat == null) {
            this.dateformat = new SimpleDateFormat(this.config.getDateFormat());
        }
        return this.dateformat;
    }

    protected boolean updateDocument(long lineNumber, String name, DocumentType docType, CoreSession session, UserProfileService userProfileService, Map<String, Serializable> properties) {
        DocumentModel doc = userProfileService.getUserProfileDocument(name, session);
        Calendar createdDate = (Calendar)doc.getPropertyValue("dc:created");
        boolean isCreated = createdDate.getTime().after(this.startDate);
        if (!isCreated && !this.config.isUpdateExisting()) {
            this.logImportInfo(lineNumber, "Document already exists for user: %s", name);
            return false;
        }
        for (Map.Entry<String, Serializable> entry : properties.entrySet()) {
            doc.setPropertyValue(entry.getKey(), entry.getValue());
        }
        try {
            session.saveDocument(doc);
        }
        catch (NuxeoException e) {
            Throwable unwrappedException = UserProfileImporter.unwrapException(e);
            this.logImportError(lineNumber, "Unable to update document for user: %s: %s", name, unwrappedException.getMessage());
            log.debug((Object)unwrappedException, unwrappedException);
            return false;
        }
        return true;
    }

    protected void commitOrRollbackTransaction() {
        if (TransactionHelper.isTransactionActiveOrMarkedRollback()) {
            TransactionHelper.commitOrRollbackTransaction();
        }
    }

    protected boolean startTransaction() {
        return TransactionHelper.startTransaction();
    }

    protected void logImportError(long lineNumber, String message, String ... params) {
        String lineMessage = String.format("Line %d", lineNumber);
        String errorMessage = String.format(message, params);
        log.error((Object)String.format("%s: %s", lineMessage, errorMessage));
    }

    protected void logImportInfo(long lineNumber, String message, String ... params) {
        String lineMessage = String.format("Line %d", lineNumber);
        String infoMessage = String.format(message, params);
        log.info((Object)String.format("%s: %s", lineMessage, infoMessage));
    }

    public static Throwable unwrapException(Throwable t) {
        Throwable cause = null;
        if (t != null) {
            cause = t.getCause();
        }
        if (cause == null) {
            return t;
        }
        return UserProfileImporter.unwrapException(cause);
    }

    public long getTotalRecords() {
        return this.totalRecords;
    }

    public long getCurrentRecord() {
        return this.currentRecord;
    }
}

