/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.profile;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.platform.userworkspace.api.UserWorkspaceService;
import org.nuxeo.ecm.user.center.profile.ImporterConfig;
import org.nuxeo.ecm.user.center.profile.UserProfileImporterWork;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class UserProfileServiceImpl
extends DefaultComponent
implements UserProfileService {
    private static final Log log = LogFactory.getLog(UserProfileServiceImpl.class);
    protected static final Integer CACHE_CONCURRENCY_LEVEL = 10;
    protected static final Integer CACHE_TIMEOUT = 10;
    protected static final Integer CACHE_MAXIMUM_SIZE = 1000;
    public static final String CONFIG_EP = "config";
    private ImporterConfig config;
    private UserWorkspaceService userWorkspaceService;
    protected final Cache<String, String> profileUidCache = CacheBuilder.newBuilder().concurrencyLevel(CACHE_CONCURRENCY_LEVEL.intValue()).maximumSize((long)CACHE_MAXIMUM_SIZE.intValue()).expireAfterWrite((long)CACHE_TIMEOUT.intValue(), TimeUnit.MINUTES).build();

    @Override
    public DocumentModel getUserProfileDocument(CoreSession session) {
        DocumentModel userWorkspace = this.getUserWorkspaceService().getCurrentUserPersonalWorkspace(session, null);
        String uid = (String)this.profileUidCache.getIfPresent((Object)session.getPrincipal().getName());
        IdRef ref = new IdRef(uid);
        if (uid != null && session.exists((DocumentRef)ref)) {
            return session.getDocument((DocumentRef)ref);
        }
        DocumentModel profile = new UserProfileDocumentGetter(session, userWorkspace).getOrCreate();
        this.profileUidCache.put((Object)session.getPrincipal().getName(), (Object)profile.getId());
        return profile;
    }

    @Override
    public DocumentModel getUserProfileDocument(String userName, CoreSession session) {
        DocumentModel userWorkspace = this.getUserWorkspaceService().getUserPersonalWorkspace(userName, session.getRootDocument());
        String uid = (String)this.profileUidCache.getIfPresent((Object)userName);
        IdRef ref = new IdRef(uid);
        if (uid != null && session.exists((DocumentRef)ref)) {
            return session.getDocument((DocumentRef)ref);
        }
        DocumentModel profile = new UserProfileDocumentGetter(session, userWorkspace).getOrCreate();
        this.profileUidCache.put((Object)userName, (Object)profile.getId());
        return profile;
    }

    @Override
    public DocumentModel getUserProfile(DocumentModel userModel, CoreSession session) {
        DocumentModel userProfileDoc = this.getUserProfileDocument(userModel.getId(), session);
        userProfileDoc.detach(true);
        userProfileDoc.getDataModels().putAll((Map)userModel.getDataModels());
        return userProfileDoc;
    }

    private UserWorkspaceService getUserWorkspaceService() {
        if (this.userWorkspaceService == null) {
            this.userWorkspaceService = (UserWorkspaceService)Framework.getLocalService(UserWorkspaceService.class);
        }
        return this.userWorkspaceService;
    }

    @Override
    public void clearCache() {
        this.profileUidCache.invalidateAll();
    }

    @Override
    public ImporterConfig getImporterConfig() {
        return this.config;
    }

    public void applicationStarted(ComponentContext context) {
        if (this.config == null || this.config.getDataFileName() == null) {
            return;
        }
        WorkManager wm = (WorkManager)Framework.getService(WorkManager.class);
        if (wm != null) {
            wm.schedule((Work)new UserProfileImporterWork(), WorkManager.Scheduling.IF_NOT_RUNNING_OR_SCHEDULED, true);
        }
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIG_EP.equals(extensionPoint)) {
            if (this.config != null) {
                log.warn((Object)"Overriding existing user profile importer config");
            }
            this.config = (ImporterConfig)contribution;
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (CONFIG_EP.equals(extensionPoint) && this.config != null && this.config.equals(contribution)) {
            this.config = null;
        }
    }

    private class UserProfileDocumentGetter
    extends UnrestrictedSessionRunner {
        private DocumentModel userWorkspace;
        private DocumentRef userProfileDocRef;

        public UserProfileDocumentGetter(CoreSession session, DocumentModel userWorkspace) {
            super(session);
            this.userWorkspace = userWorkspace;
        }

        public void run() {
            String query = "select * from UserProfile where ecm:parentId='" + this.userWorkspace.getId() + "' " + " AND ecm:isProxy = 0 " + " AND ecm:isCheckedInVersion = 0 AND ecm:currentLifeCycleState != 'deleted'";
            DocumentModelList children = this.session.query(query);
            if (!children.isEmpty()) {
                this.userProfileDocRef = ((DocumentModel)children.get(0)).getRef();
            } else {
                DocumentModel userProfileDoc = this.session.createDocumentModel(this.userWorkspace.getPathAsString(), String.valueOf(System.currentTimeMillis()), "UserProfile");
                userProfileDoc = this.session.createDocument(userProfileDoc);
                this.userProfileDocRef = userProfileDoc.getRef();
                ACP acp = this.session.getACP(this.userProfileDocRef);
                ACL acl = acp.getOrCreateACL();
                acl.add(new ACE("Everyone", "Read", true));
                acp.addACL(acl);
                this.session.setACP(this.userProfileDocRef, acp, true);
                this.session.save();
            }
        }

        public DocumentModel getOrCreate() {
            if (this.session.hasPermission(this.userWorkspace.getRef(), "AddChildren")) {
                this.run();
            } else {
                this.runUnrestricted();
            }
            return this.session.getDocument(this.userProfileDocRef);
        }
    }
}

