/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.user.center.profile.localeProvider;

import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang.LocaleUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.web.common.locale.LocaleProvider;
import org.nuxeo.ecm.user.center.profile.UserProfileService;
import org.nuxeo.runtime.api.Framework;

public class UserLocaleProvider
implements LocaleProvider {
    public static final Log log = LogFactory.getLog(UserLocaleProvider.class);

    public Locale getLocale(CoreSession repo) {
        UserProfileService userProfileService = (UserProfileService)Framework.getLocalService(UserProfileService.class);
        DocumentModel userProfileDoc = userProfileService.getUserProfileDocument(repo);
        return this.getLocale(userProfileDoc);
    }

    public Locale getLocale(DocumentModel userProfileDoc) {
        String locale = (String)((Object)userProfileDoc.getPropertyValue("userprofile:locale"));
        if (locale == null || locale.trim().length() == 0) {
            return null;
        }
        try {
            return LocaleUtils.toLocale((String)locale);
        }
        catch (IllegalArgumentException e) {
            log.error((Object)("Locale parse exception:  \"" + locale + "\""), (Throwable)e);
            return null;
        }
    }

    public TimeZone getTimeZone(CoreSession repo) {
        return null;
    }
}

