/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.event;

import org.nuxeo.ecm.core.event.EventProducer;
import org.nuxeo.ecm.core.event.EventService;
import org.nuxeo.ecm.core.event.EventServiceAdmin;
import org.nuxeo.ecm.core.event.impl.EventListenerDescriptor;
import org.nuxeo.ecm.core.event.impl.EventServiceImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;

public class EventServiceComponent
extends DefaultComponent {
    public static final int APPLICATION_STARTED_ORDER = -500;
    public static final String EVENT_LISTENER_XP = "listener";
    public static final long DEFAULT_SHUTDOWN_TIMEOUT = 5000L;
    protected EventServiceImpl service;

    public void activate(ComponentContext context) {
        this.service = new EventServiceImpl();
    }

    public void deactivate(ComponentContext context) {
        if (this.service != null) {
            String s = Framework.getProperty((String)"org.nuxeo.ecm.core.event.shutdown.timeoutMillis");
            long timeout = s == null ? 5000L : Long.parseLong(s);
            try {
                this.service.shutdown(timeout);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
            this.service = null;
        }
    }

    public int getApplicationStartedOrder() {
        return -500;
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (EVENT_LISTENER_XP.equals(extensionPoint)) {
            EventListenerDescriptor descriptor = (EventListenerDescriptor)contribution;
            descriptor.setRuntimeContext(contributor.getRuntimeContext());
            this.service.addEventListener(descriptor);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (EVENT_LISTENER_XP.equals(extensionPoint)) {
            this.service.removeEventListener((EventListenerDescriptor)contribution);
        }
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (EventService.class == adapter || EventProducer.class == adapter || EventServiceAdmin.class == adapter) {
            return (T)this.service;
        }
        return null;
    }
}

