/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.work;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import com.codahale.metrics.Timer;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.work.MemoryWorkQueuing;
import org.nuxeo.ecm.core.work.NuxeoBlockingQueue;
import org.nuxeo.ecm.core.work.WorkHolder;
import org.nuxeo.ecm.core.work.WorkQueueDescriptorRegistry;
import org.nuxeo.ecm.core.work.WorkQueuing;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.ecm.core.work.api.WorkQueueDescriptor;
import org.nuxeo.ecm.core.work.api.WorkQueuingImplDescriptor;
import org.nuxeo.ecm.core.work.api.WorkSchedulePath;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.RuntimeServiceListener;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.metrics.MetricsService;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.transaction.TransactionHelper;

public class WorkManagerImpl
extends DefaultComponent
implements WorkManager {
    public static final String NAME = "org.nuxeo.ecm.core.work.service";
    private static final Log log = LogFactory.getLog(WorkManagerImpl.class);
    protected static final String QUEUES_EP = "queues";
    protected static final String IMPL_EP = "implementation";
    public static final String DEFAULT_QUEUE_ID = "default";
    public static final String DEFAULT_CATEGORY = "default";
    protected static final String THREAD_PREFIX = "Nuxeo-Work-";
    protected final MetricRegistry registry = SharedMetricRegistries.getOrCreate((String)MetricsService.class.getName());
    protected final WorkQueueDescriptorRegistry workQueueDescriptors = new WorkQueueDescriptorRegistry(this);
    protected final Map<String, WorkThreadPoolExecutor> executors = new HashMap<String, WorkThreadPoolExecutor>();
    protected final WorkCompletionSynchronizer completionSynchronizer = new WorkCompletionSynchronizer("all");
    protected WorkQueuing queuing = this.newWorkQueuing(MemoryWorkQueuing.class);
    protected volatile boolean started = false;

    public void activate(ComponentContext context) {
        Framework.addListener((RuntimeServiceListener)new ShutdownListener());
    }

    public void registerContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (QUEUES_EP.equals(extensionPoint)) {
            this.registerWorkQueueDescriptor((WorkQueueDescriptor)contribution);
        } else if (IMPL_EP.equals(extensionPoint)) {
            this.registerWorkQueuingDescriptor((WorkQueuingImplDescriptor)contribution);
        } else {
            throw new RuntimeException("Unknown extension point: " + extensionPoint);
        }
    }

    public void unregisterContribution(Object contribution, String extensionPoint, ComponentInstance contributor) {
        if (QUEUES_EP.equals(extensionPoint)) {
            this.unregisterWorkQueueDescriptor((WorkQueueDescriptor)contribution);
        } else if (IMPL_EP.equals(extensionPoint)) {
            this.unregisterWorkQueuingDescriptor((WorkQueuingImplDescriptor)contribution);
        } else {
            throw new RuntimeException("Unknown extension point: " + extensionPoint);
        }
    }

    public void registerWorkQueueDescriptor(WorkQueueDescriptor workQueueDescriptor) {
        String queueId = workQueueDescriptor.id;
        if ("*".equals(queueId)) {
            Boolean processing = workQueueDescriptor.processing;
            Boolean queuing = workQueueDescriptor.queuing;
            if (processing == null && queuing == null) {
                log.error((Object)"Ignoring work queue descriptor * with no processing/queuing");
                return;
            }
            String what = processing == null ? "" : " processing=" + processing;
            what = what + (queuing == null ? "" : " queuing=" + queuing);
            log.info((Object)("Setting on all work queues:" + what));
            ArrayList<String> queueIds = new ArrayList<String>(this.workQueueDescriptors.getQueueIds());
            for (String id : queueIds) {
                WorkQueueDescriptor wqd = new WorkQueueDescriptor();
                wqd.id = id;
                wqd.processing = processing;
                wqd.queuing = queuing;
                this.registerWorkQueueDescriptor(wqd);
            }
            return;
        }
        this.workQueueDescriptors.addContribution(workQueueDescriptor);
        WorkQueueDescriptor wqd = this.workQueueDescriptors.get(queueId);
        log.info((Object)("Registered work queue " + queueId + " " + wqd.toString()));
    }

    public void unregisterWorkQueueDescriptor(WorkQueueDescriptor workQueueDescriptor) {
        String id = workQueueDescriptor.id;
        if ("*".equals(id)) {
            return;
        }
        this.workQueueDescriptors.removeContribution(workQueueDescriptor);
        log.info((Object)("Unregistered work queue " + id));
    }

    protected void activateQueue(WorkQueueDescriptor workQueueDescriptor) {
        String id = workQueueDescriptor.id;
        WorkThreadPoolExecutor executor = this.executors.get(id);
        if (executor == null) {
            NamedThreadFactory threadFactory = new NamedThreadFactory(THREAD_PREFIX + id + "-");
            int maxPoolSize = workQueueDescriptor.getMaxThreads();
            executor = new WorkThreadPoolExecutor(id, maxPoolSize, maxPoolSize, 0L, TimeUnit.SECONDS, threadFactory);
            executor.prestartAllCoreThreads();
            this.executors.put(id, executor);
        }
        NuxeoBlockingQueue queue = (NuxeoBlockingQueue)executor.getQueue();
        queue.setActive(workQueueDescriptor.isProcessingEnabled());
        log.info((Object)("Activated work queue " + id + " " + workQueueDescriptor.toEffectiveString()));
    }

    public void deactivateQueue(WorkQueueDescriptor workQueueDescriptor) {
        if ("*".equals(workQueueDescriptor.id)) {
            return;
        }
        WorkThreadPoolExecutor executor = this.executors.get(workQueueDescriptor.id);
        executor.shutdownAndSuspend();
        log.info((Object)("Deactivated work queue " + workQueueDescriptor.id));
    }

    public void registerWorkQueuingDescriptor(WorkQueuingImplDescriptor descr) {
        WorkQueuing q = this.newWorkQueuing(descr.getWorkQueuingClass());
        this.registerWorkQueuing(q);
    }

    public void registerWorkQueuing(WorkQueuing q) {
        this.closeQueuing();
        this.queuing = q;
    }

    public void unregisterWorkQueuingDescriptor(WorkQueuingImplDescriptor descr) {
        this.unregisterWorkQueing();
    }

    public void unregisterWorkQueing() {
        this.closeQueuing();
        this.queuing = this.newWorkQueuing(MemoryWorkQueuing.class);
    }

    protected WorkQueuing newWorkQueuing(Class<? extends WorkQueuing> klass) {
        WorkQueuing q;
        try {
            Constructor<? extends WorkQueuing> ctor = klass.getConstructor(WorkManagerImpl.class, WorkQueueDescriptorRegistry.class);
            q = ctor.newInstance(new Object[]{this, this.workQueueDescriptors});
        }
        catch (ReflectiveOperationException | SecurityException e) {
            throw new RuntimeException(e);
        }
        return q;
    }

    protected void closeQueuing() {
        try {
            this.shutdown(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    protected boolean isQueuingEnabled(String queueId) {
        WorkQueueDescriptor wqd = this.getWorkQueueDescriptor(queueId);
        return wqd == null ? false : wqd.isQueuingEnabled();
    }

    protected boolean isProcessingEnabled(String queueId) {
        WorkQueueDescriptor wqd = this.getWorkQueueDescriptor(queueId);
        return wqd == null ? false : wqd.isProcessingEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getWorkQueueIds() {
        WorkQueueDescriptorRegistry workQueueDescriptorRegistry = this.workQueueDescriptors;
        synchronized (workQueueDescriptorRegistry) {
            return this.workQueueDescriptors.getQueueIds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WorkQueueDescriptor getWorkQueueDescriptor(String queueId) {
        WorkQueueDescriptorRegistry workQueueDescriptorRegistry = this.workQueueDescriptors;
        synchronized (workQueueDescriptorRegistry) {
            return this.workQueueDescriptors.get(queueId);
        }
    }

    @Override
    public String getCategoryQueueId(String category) {
        String queueId;
        if (category == null) {
            category = "default";
        }
        if ((queueId = this.workQueueDescriptors.getQueueId(category)) == null) {
            queueId = "default";
        }
        return queueId;
    }

    public int getApplicationStartedOrder() {
        return -501;
    }

    public void applicationStarted(ComponentContext context) {
        this.init();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() {
        if (this.started) {
            return;
        }
        WorkManagerImpl workManagerImpl = this;
        synchronized (workManagerImpl) {
            if (this.started) {
                return;
            }
            this.started = true;
            this.queuing.init();
            for (String id : this.workQueueDescriptors.getQueueIds()) {
                this.activateQueue(this.workQueueDescriptors.get(id));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WorkThreadPoolExecutor getExecutor(String queueId) {
        WorkQueueDescriptor workQueueDescriptor;
        if (!this.started) {
            if (Framework.isTestModeSet() && !Framework.getRuntime().isShuttingDown()) {
                LogFactory.getLog(WorkManagerImpl.class).warn((Object)"Lazy starting of work manager in test mode");
                this.init();
            } else {
                throw new IllegalStateException("Work manager not started, could not access to executors");
            }
        }
        WorkQueueDescriptorRegistry workQueueDescriptorRegistry = this.workQueueDescriptors;
        synchronized (workQueueDescriptorRegistry) {
            workQueueDescriptor = this.workQueueDescriptors.get(queueId);
        }
        if (workQueueDescriptor == null) {
            throw new IllegalArgumentException("No such work queue: " + queueId);
        }
        return this.executors.get(queueId);
    }

    @Override
    public boolean shutdownQueue(String queueId, long timeout, TimeUnit unit) throws InterruptedException {
        WorkThreadPoolExecutor executor = this.getExecutor(queueId);
        boolean terminated = this.shutdownExecutors(Collections.singleton(executor), timeout, unit);
        this.removeExecutor(queueId);
        return terminated;
    }

    protected boolean shutdownExecutors(Collection<WorkThreadPoolExecutor> list, long timeout, TimeUnit unit) throws InterruptedException {
        for (WorkThreadPoolExecutor executor : list) {
            executor.shutdownAndSuspend();
        }
        long t0 = System.currentTimeMillis();
        long delay = unit.toMillis(timeout);
        boolean terminated = true;
        for (WorkThreadPoolExecutor executor : list) {
            long remaining;
            if (executor.awaitTerminationOrSave(remaining = this.remainingMillis(t0, delay), TimeUnit.MILLISECONDS)) continue;
            terminated = false;
            executor.shutdownNow();
        }
        return terminated;
    }

    protected long remainingMillis(long t0, long delay) {
        long d = System.currentTimeMillis() - t0;
        if (d > delay) {
            return 0L;
        }
        return delay - d;
    }

    protected synchronized void removeExecutor(String queueId) {
        this.executors.remove(queueId);
    }

    @Override
    public boolean shutdown(long timeout, TimeUnit unit) throws InterruptedException {
        ArrayList<WorkThreadPoolExecutor> executorList = new ArrayList<WorkThreadPoolExecutor>(this.executors.values());
        this.executors.clear();
        this.started = false;
        return this.shutdownExecutors(executorList, timeout, unit);
    }

    @Override
    public void schedule(Work work) {
        this.schedule(work, WorkManager.Scheduling.ENQUEUE, false);
    }

    @Override
    public void schedule(Work work, boolean afterCommit) {
        this.schedule(work, WorkManager.Scheduling.ENQUEUE, afterCommit);
    }

    @Override
    public void schedule(Work work, WorkManager.Scheduling scheduling) {
        this.schedule(work, scheduling, false);
    }

    @Override
    public void schedule(Work work, WorkManager.Scheduling scheduling, boolean afterCommit) {
        String workId = work.getId();
        String queueId = this.getCategoryQueueId(work.getCategory());
        if (!this.isQueuingEnabled(queueId)) {
            work.setWorkInstanceState(Work.State.CANCELED);
            return;
        }
        if (afterCommit && this.scheduleAfterCommit(work, scheduling)) {
            return;
        }
        work.setWorkInstanceState(Work.State.SCHEDULED);
        WorkSchedulePath.newInstance(work);
        if (log.isTraceEnabled()) {
            log.trace((Object)("Scheduling work: " + work + " using queue: " + queueId), (Throwable)work.getSchedulePath().getStack());
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("Scheduling work: " + work + " using queue: " + queueId));
        }
        switch (scheduling) {
            case ENQUEUE: {
                break;
            }
            case CANCEL_SCHEDULED: {
                Work w = this.getExecutor(queueId).removeScheduled(workId);
                if (w == null) break;
                w.setWorkInstanceState(Work.State.CANCELED);
                if (!log.isDebugEnabled()) break;
                log.debug((Object)("Canceling existing scheduled work before scheduling (" + this.completionSynchronizer.scheduledOrRunning.get() + ")"));
                break;
            }
            case IF_NOT_SCHEDULED: 
            case IF_NOT_RUNNING: 
            case IF_NOT_RUNNING_OR_SCHEDULED: {
                boolean disabled = Boolean.TRUE;
                if (disabled || !this.hasWorkInState(workId, scheduling.state)) break;
                work.setWorkInstanceState(Work.State.CANCELED);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Canceling schedule because found: " + (Object)((Object)scheduling)));
                }
                return;
            }
        }
        this.getExecutor(queueId).execute(work);
    }

    protected boolean scheduleAfterCommit(Work work, WorkManager.Scheduling scheduling) {
        TransactionManager transactionManager;
        try {
            transactionManager = TransactionHelper.lookupTransactionManager();
        }
        catch (NamingException e) {
            transactionManager = null;
        }
        if (transactionManager == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Not scheduling work after commit because of missing transaction manager: " + work));
            }
            return false;
        }
        try {
            Transaction transaction = transactionManager.getTransaction();
            if (transaction == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Not scheduling work after commit because of missing transaction: " + work));
                }
                return false;
            }
            int status = transaction.getStatus();
            if (status == 0) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Scheduling work after commit: " + work));
                }
                transaction.registerSynchronization((Synchronization)new WorkScheduling(work, scheduling));
                return true;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Not scheduling work after commit because transaction is in status " + status + ": " + work));
            }
            return false;
        }
        catch (RollbackException | SystemException e) {
            log.error((Object)"Cannot schedule after commit", e);
            return false;
        }
    }

    @Override
    @Deprecated
    public Work find(Work work, Work.State state, boolean useEquals, int[] pos) {
        if (pos != null) {
            pos[0] = 0;
        }
        String workId = work.getId();
        return this.queuing.find(workId, state);
    }

    @Override
    public Work find(String workId, Work.State state) {
        return this.queuing.find(workId, state);
    }

    @Override
    public String findResult(String workId) {
        Work work = this.find(workId, Work.State.COMPLETED);
        return work != null ? work.getWorkInstanceResult() : null;
    }

    protected boolean hasWorkInState(String workId, Work.State state) {
        return this.queuing.isWorkInState(workId, state);
    }

    @Override
    public Work.State getWorkState(String workId) {
        return this.queuing.getWorkState(workId);
    }

    @Override
    public List<Work> listWork(String queueId, Work.State state) {
        return this.queuing.listWork(queueId, state);
    }

    @Override
    public List<String> listWorkIds(String queueId, Work.State state) {
        return this.queuing.listWorkIds(queueId, state);
    }

    @Override
    public int getQueueSize(String queueId, Work.State state) {
        if (state == null) {
            return this.getScheduledOrRunningSize(queueId);
        }
        if (state == Work.State.SCHEDULED) {
            return this.getScheduledSize(queueId);
        }
        if (state == Work.State.RUNNING) {
            return this.getRunningSize(queueId);
        }
        if (state == Work.State.COMPLETED) {
            return this.getCompletedSize(queueId);
        }
        throw new IllegalArgumentException(String.valueOf((Object)state));
    }

    @Override
    @Deprecated
    public int getNonCompletedWorkSize(String queueId) {
        return this.getScheduledOrRunningSize(queueId);
    }

    protected int getScheduledSize(String queueId) {
        return this.queuing.getQueueSize(queueId, Work.State.SCHEDULED);
    }

    protected int getRunningSize(String queueId) {
        return this.queuing.getQueueSize(queueId, Work.State.RUNNING);
    }

    protected int getScheduledOrRunningSize(String queueId) {
        return this.getExecutor(queueId).getScheduledOrRunningSize();
    }

    protected int getCompletedSize(String queueId) {
        return this.queuing.getQueueSize(queueId, Work.State.COMPLETED);
    }

    @Override
    public boolean awaitCompletion(String queueId, long duration, TimeUnit unit) throws InterruptedException {
        return this.getExecutor((String)queueId).completionSynchronizer.await(unit.toNanos(duration)) > 0L;
    }

    @Override
    public boolean awaitCompletion(long duration, TimeUnit unit) throws InterruptedException {
        return this.completionSynchronizer.await(unit.toNanos(duration)) > 0L;
    }

    @Override
    public synchronized void clearCompletedWork(String queueId) {
        this.queuing.clearCompletedWork(queueId, 0L);
    }

    @Override
    public synchronized void clearCompletedWork(long completionTime) {
        for (String queueId : this.queuing.getCompletedQueueIds()) {
            this.queuing.clearCompletedWork(queueId, completionTime);
        }
    }

    @Override
    public synchronized void cleanup() {
        log.debug((Object)"Clearing old completed work");
        for (String queueId : this.queuing.getCompletedQueueIds()) {
            long delay;
            WorkQueueDescriptor workQueueDescriptor = this.workQueueDescriptors.get(queueId);
            if (workQueueDescriptor == null || (delay = (long)workQueueDescriptor.getClearCompletedAfterSeconds() * 1000L) <= 0L) continue;
            long completionTime = System.currentTimeMillis() - delay;
            this.queuing.clearCompletedWork(queueId, completionTime);
        }
    }

    @Override
    public boolean isStarted() {
        return this.started;
    }

    protected class WorkThreadPoolExecutor
    extends ThreadPoolExecutor {
        protected final String queueId;
        protected final WorkCompletionSynchronizer completionSynchronizer;
        protected final List<Work> running;
        protected final Counter scheduledCount;
        protected final Counter scheduledMax;
        protected final Counter runningCount;
        protected final Counter completedCount;
        protected final Timer workTimer;

        protected WorkThreadPoolExecutor(String queueId, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, WorkManagerImpl.this.queuing.initScheduleQueue(queueId), threadFactory);
            this.queueId = queueId;
            this.completionSynchronizer = new WorkCompletionSynchronizer(queueId);
            this.running = new LinkedList<Work>();
            this.scheduledCount = WorkManagerImpl.this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"works", queueId, "scheduled", "count"}));
            this.scheduledMax = WorkManagerImpl.this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"works", queueId, "scheduled", "max"}));
            this.runningCount = WorkManagerImpl.this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"works", queueId, "running"}));
            this.completedCount = WorkManagerImpl.this.registry.counter(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"works", queueId, "completed"}));
            this.workTimer = WorkManagerImpl.this.registry.timer(MetricRegistry.name((String)"nuxeo", (String[])new String[]{"works", queueId, "total"}));
        }

        public int getScheduledOrRunningSize() {
            return this.completionSynchronizer.scheduledOrRunning.get();
        }

        @Override
        public void execute(Runnable r) {
            throw new UnsupportedOperationException("use other api");
        }

        public void execute(Work work) {
            this.scheduledCount.inc();
            if (this.scheduledCount.getCount() > this.scheduledMax.getCount()) {
                this.scheduledMax.inc();
            }
            this.completionSynchronizer.signalSchedule();
            boolean ok = false;
            try {
                this.submit(work);
                ok = true;
            }
            finally {
                if (!ok) {
                    this.completionSynchronizer.signalCompletion();
                }
            }
        }

        protected void submit(Work work) throws RuntimeException {
            BlockingQueue<Runnable> queue = WorkManagerImpl.this.queuing.getScheduledQueue(this.queueId);
            boolean added = queue.offer(new WorkHolder(work));
            if (!added) {
                throw new RuntimeException("queue should have blocked");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            Work work = WorkHolder.getWork(r);
            work.setWorkInstanceState(Work.State.RUNNING);
            WorkManagerImpl.this.queuing.workRunning(this.queueId, work);
            List<Work> list = this.running;
            synchronized (list) {
                this.running.add(work);
            }
            this.scheduledCount.dec();
            this.runningCount.inc();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            try {
                Work work = WorkHolder.getWork(r);
                List<Work> list = this.running;
                synchronized (list) {
                    this.running.remove(work);
                }
                Work.State state = t == null ? (work.isWorkInstanceSuspended() ? Work.State.SCHEDULED : Work.State.COMPLETED) : Work.State.FAILED;
                work.setWorkInstanceState(state);
                WorkManagerImpl.this.queuing.workCompleted(this.queueId, work);
                this.runningCount.dec();
                this.completedCount.inc();
                this.workTimer.update(work.getCompletionTime() - work.getStartTime(), TimeUnit.MILLISECONDS);
            }
            finally {
                this.completionSynchronizer.signalCompletion();
            }
        }

        protected void removedFromQueue(Runnable r) {
            Work work = WorkHolder.getWork(r);
            work.setWorkInstanceState(Work.State.CANCELED);
            this.completionSynchronizer.signalCompletion();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void shutdownAndSuspend() {
            this.setRejectedExecutionHandler(CancelingPolicy.INSTANCE);
            this.shutdown();
            int n = WorkManagerImpl.this.queuing.setSuspending(this.queueId);
            this.completionSynchronizer.scheduledOrRunning.addAndGet(-n);
            List<Work> list = this.running;
            synchronized (list) {
                for (Work work : this.running) {
                    work.setWorkInstanceSuspending();
                }
            }
        }

        public boolean awaitTerminationOrSave(long timeout, TimeUnit unit) throws InterruptedException {
            boolean terminated = super.awaitTermination(timeout, unit);
            if (!terminated) {
                ArrayList drained = new ArrayList();
                this.getQueue().drainTo(drained);
                for (Runnable r : drained) {
                    this.removedFromQueue(r);
                }
            }
            return terminated;
        }

        public Work removeScheduled(String workId) {
            Work w = WorkManagerImpl.this.queuing.removeScheduled(this.queueId, workId);
            if (w != null) {
                this.completionSynchronizer.signalCompletion();
            }
            return w;
        }
    }

    public class WorkCompletionSynchronizer {
        protected final AtomicInteger scheduledOrRunning = new AtomicInteger(0);
        protected final ReentrantLock completionLock = new ReentrantLock();
        protected final Condition completion = this.completionLock.newCondition();
        protected final Log log = LogFactory.getLog(WorkCompletionSynchronizer.class);
        protected final String queueid;

        protected WorkCompletionSynchronizer(String id) {
            this.queueid = id;
        }

        protected long await(long timeout) throws InterruptedException {
            this.completionLock.lock();
            try {
                while (timeout > 0L && this.scheduledOrRunning.get() > 0) {
                    timeout = this.completion.awaitNanos(timeout);
                }
            }
            finally {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)"returning from await");
                }
                this.completionLock.unlock();
            }
            return timeout;
        }

        protected void signalSchedule() {
            int value = this.scheduledOrRunning.incrementAndGet();
            if (this.log.isTraceEnabled()) {
                this.logScheduleAndRunning("scheduled", value);
            }
            if (WorkManagerImpl.this.completionSynchronizer != this) {
                WorkManagerImpl.this.completionSynchronizer.signalSchedule();
            }
        }

        protected void signalCompletion() {
            int value = this.scheduledOrRunning.decrementAndGet();
            if (value == 0) {
                this.completionLock.lock();
                try {
                    this.completion.signalAll();
                }
                finally {
                    this.completionLock.unlock();
                }
            }
            if (this.log.isTraceEnabled()) {
                this.logScheduleAndRunning("completed", value);
            }
            if (WorkManagerImpl.this.completionSynchronizer != this) {
                WorkManagerImpl.this.completionSynchronizer.signalCompletion();
            }
        }

        protected void logScheduleAndRunning(String event, int value) {
            this.log.trace((Object)(event + " [" + this.queueid + "," + value + "]"), new Throwable("stack trace"));
        }
    }

    public static class CancelingPolicy
    implements RejectedExecutionHandler {
        public static final CancelingPolicy INSTANCE = new CancelingPolicy();

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            ((WorkThreadPoolExecutor)executor).removedFromQueue(r);
        }
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger();
        private final ThreadGroup group;
        private final String prefix;

        public NamedThreadFactory(String prefix) {
            SecurityManager sm = System.getSecurityManager();
            this.group = sm == null ? Thread.currentThread().getThreadGroup() : sm.getThreadGroup();
            this.prefix = prefix;
        }

        @Override
        public Thread newThread(Runnable r) {
            String name = this.prefix + this.threadNumber.incrementAndGet();
            Thread thread = new Thread(this.group, r, name);
            thread.setPriority(5);
            thread.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                @Override
                public void uncaughtException(Thread t, Throwable e) {
                    LogFactory.getLog(WorkManagerImpl.class).error((Object)("Uncaught error on thread " + t.getName()), e);
                }
            });
            return thread;
        }
    }

    public class WorkScheduling
    implements Synchronization {
        public final Work work;
        public final WorkManager.Scheduling scheduling;

        public WorkScheduling(Work work, WorkManager.Scheduling scheduling) {
            this.work = work;
            this.scheduling = scheduling;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int status) {
            if (status == 3) {
                WorkManagerImpl.this.schedule(this.work, this.scheduling, false);
            } else if (status == 4) {
                this.work.setWorkInstanceState(Work.State.CANCELED);
            } else {
                throw new IllegalArgumentException("Unsupported transaction status " + status);
            }
        }
    }

    protected class ShutdownListener
    implements RuntimeServiceListener {
        protected ShutdownListener() {
        }

        public void handleEvent(RuntimeServiceEvent event) {
            if (2 != event.id) {
                return;
            }
            Framework.removeListener((RuntimeServiceListener)this);
            WorkManagerImpl.this.closeQueuing();
        }
    }
}

