/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.coremodel;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.nuxeo.ecm.core.api.repository.RepositoryManager;
import org.nuxeo.ecm.core.repository.RepositoryFactory;
import org.nuxeo.ecm.core.repository.RepositoryService;
import org.nuxeo.ecm.core.storage.FulltextConfiguration;
import org.nuxeo.ecm.core.storage.FulltextParser;
import org.nuxeo.ecm.core.storage.sql.Repository;
import org.nuxeo.ecm.core.storage.sql.RepositoryDescriptor;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.RepositoryManagement;
import org.nuxeo.ecm.core.storage.sql.coremodel.SQLRepository;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.ComponentInstance;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.SimpleContributionRegistry;

public class SQLRepositoryService
extends DefaultComponent {
    private static final String XP_REPOSITORY = "repository";
    protected static final String CONNECTIONFACTORYIMPL_CLASS = "org.nuxeo.ecm.core.storage.sql.ra.ConnectionFactoryImpl";
    protected RepositoryDescriptorRegistry registry = new RepositoryDescriptorRegistry();
    protected final Map<String, RepositoryImpl> testRepositories = new HashMap<String, RepositoryImpl>();

    public void activate(ComponentContext context) {
        this.registry.clear();
    }

    public void deactivate(ComponentContext context) {
        this.registry.clear();
    }

    public void registerContribution(Object contrib, String xpoint, ComponentInstance contributor) {
        if (!XP_REPOSITORY.equals(xpoint)) {
            throw new RuntimeException("Unknown extension point: " + xpoint);
        }
        this.addContribution((RepositoryDescriptor)contrib);
    }

    public void unregisterContribution(Object contrib, String xpoint, ComponentInstance contributor) {
        if (!XP_REPOSITORY.equals(xpoint)) {
            throw new RuntimeException("Unknown extension point: " + xpoint);
        }
        this.removeContribution((RepositoryDescriptor)contrib);
    }

    protected void addContribution(RepositoryDescriptor descriptor) {
        this.registry.addContribution(descriptor);
        this.updateRegistration(descriptor.name);
    }

    protected void removeContribution(RepositoryDescriptor descriptor) {
        this.registry.removeContribution(descriptor);
        this.updateRegistration(descriptor.name);
    }

    protected void updateRegistration(String repositoryName) {
        RepositoryFactory repositoryFactory;
        RepositoryManager repositoryManager = (RepositoryManager)Framework.getLocalService(RepositoryManager.class);
        RepositoryDescriptor descriptor = this.registry.getRepositoryDescriptor(repositoryName);
        if (descriptor == null) {
            repositoryManager.removeRepository(repositoryName);
            return;
        }
        Class<? extends RepositoryFactory> repositoryFactoryClass = descriptor.getRepositoryFactoryClass();
        if (repositoryFactoryClass == null) {
            repositoryManager.removeRepository(repositoryName);
            return;
        }
        try {
            repositoryFactory = repositoryFactoryClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Cannot instantiate repository: " + repositoryName, e);
        }
        repositoryFactory.init(repositoryName);
        org.nuxeo.ecm.core.api.repository.Repository repository = new org.nuxeo.ecm.core.api.repository.Repository(repositoryName, descriptor.label, descriptor.isDefault(), (Callable)repositoryFactory);
        repositoryManager.addRepository(repository);
    }

    public RepositoryDescriptor getRepositoryDescriptor(String name) {
        return this.registry.getRepositoryDescriptor(name);
    }

    public List<String> getRepositoryNames() {
        return this.registry.getRepositoryIds();
    }

    public void registerTestRepository(RepositoryImpl repository) {
        this.testRepositories.put(repository.getName(), repository);
    }

    public RepositoryManagement getRepository(String repositoryName) {
        RepositoryImpl repo;
        RepositoryService repositoryService = (RepositoryService)Framework.getLocalService(RepositoryService.class);
        org.nuxeo.ecm.core.model.Repository repository = repositoryService.getRepository(repositoryName);
        if (repository == null && (repo = this.testRepositories.get(repositoryName)) != null) {
            return repo;
        }
        if (repository == null) {
            throw new RuntimeException("Unknown repository: " + repositoryName);
        }
        if (repository instanceof Repository) {
            return (Repository)repository;
        }
        if (repository instanceof SQLRepository) {
            return ((SQLRepository)repository).repository;
        }
        throw new RuntimeException("Unknown repository class: " + repository.getClass().getName());
    }

    public RepositoryImpl getRepositoryImpl(String repositoryName) {
        RepositoryManagement repository = this.getRepository(repositoryName);
        if (repository instanceof RepositoryImpl) {
            return (RepositoryImpl)repository;
        }
        if (!CONNECTIONFACTORYIMPL_CLASS.equals(repository.getClass().getName())) {
            throw new RuntimeException("Unknown repository class: " + repository.getClass());
        }
        try {
            Field f1 = repository.getClass().getDeclaredField("managedConnectionFactory");
            f1.setAccessible(true);
            Object factory = f1.get(repository);
            Field f2 = factory.getClass().getDeclaredField(XP_REPOSITORY);
            f2.setAccessible(true);
            return (RepositoryImpl)f2.get(factory);
        }
        catch (IllegalAccessException | NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public List<RepositoryManagement> getRepositories() {
        ArrayList<RepositoryManagement> repositories = new ArrayList<RepositoryManagement>();
        for (String repositoryName : this.getRepositoryNames()) {
            repositories.add(this.getRepository(repositoryName));
        }
        return repositories;
    }

    public Class<? extends FulltextParser> getFulltextParserClass(String repositoryName) {
        return this.getRepositoryImpl(repositoryName).getFulltextParserClass();
    }

    public FulltextConfiguration getFulltextConfiguration(String repositoryName) {
        return this.getRepositoryImpl(repositoryName).getModel().getFulltextConfiguration();
    }

    public String getRepositoryDataSourceAndProperties(String repositoryName, Map<String, String> properties) {
        RepositoryDescriptor desc = this.getRepositoryImpl(repositoryName).getRepositoryDescriptor();
        if (desc.properties != null) {
            properties.putAll(desc.properties);
        }
        return desc.xaDataSourceName;
    }

    protected static class RepositoryDescriptorRegistry
    extends SimpleContributionRegistry<RepositoryDescriptor> {
        protected RepositoryDescriptorRegistry() {
        }

        public String getContributionId(RepositoryDescriptor contrib) {
            return contrib.name;
        }

        public RepositoryDescriptor clone(RepositoryDescriptor orig) {
            return new RepositoryDescriptor(orig);
        }

        public void merge(RepositoryDescriptor src, RepositoryDescriptor dst) {
            dst.merge(src);
        }

        public boolean isSupportingMerge() {
            return true;
        }

        public void clear() {
            this.currentContribs.clear();
        }

        public RepositoryDescriptor getRepositoryDescriptor(String id) {
            return (RepositoryDescriptor)this.getCurrentContribution(id);
        }

        public List<String> getRepositoryIds() {
            return new ArrayList<String>(this.currentContribs.keySet());
        }
    }
}

