/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql.jdbc;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Array;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.common.utils.StringUtils;
import org.nuxeo.ecm.core.api.IterableQueryResult;
import org.nuxeo.ecm.core.api.Lock;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.api.PartialList;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.model.LockManager;
import org.nuxeo.ecm.core.query.QueryFilter;
import org.nuxeo.ecm.core.storage.sql.ClusterInvalidator;
import org.nuxeo.ecm.core.storage.sql.ColumnType;
import org.nuxeo.ecm.core.storage.sql.Invalidations;
import org.nuxeo.ecm.core.storage.sql.Mapper;
import org.nuxeo.ecm.core.storage.sql.Model;
import org.nuxeo.ecm.core.storage.sql.RepositoryImpl;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowId;
import org.nuxeo.ecm.core.storage.sql.Session;
import org.nuxeo.ecm.core.storage.sql.jdbc.JDBCRowMapper;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMaker;
import org.nuxeo.ecm.core.storage.sql.jdbc.QueryMakerService;
import org.nuxeo.ecm.core.storage.sql.jdbc.ResultSetQueryResult;
import org.nuxeo.ecm.core.storage.sql.jdbc.SQLInfo;
import org.nuxeo.ecm.core.storage.sql.jdbc.TableUpgrader;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Column;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Database;
import org.nuxeo.ecm.core.storage.sql.jdbc.db.Table;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.Dialect;
import org.nuxeo.ecm.core.storage.sql.jdbc.dialect.DialectOracle;
import org.nuxeo.runtime.api.Framework;

public class JDBCMapper
extends JDBCRowMapper
implements Mapper {
    private static final Log log = LogFactory.getLog(JDBCMapper.class);
    public static Map<String, Serializable> testProps = new HashMap<String, Serializable>();
    public static final String TEST_UPGRADE = "testUpgrade";
    public static final String TEST_UPGRADE_VERSIONS = "testUpgradeVersions";
    public static final String TEST_UPGRADE_LAST_CONTRIBUTOR = "testUpgradeLastContributor";
    public static final String TEST_UPGRADE_LOCKS = "testUpgradeLocks";
    public static final String TEST_UPGRADE_FULLTEXT = "testUpgradeFulltext";
    protected TableUpgrader tableUpgrader;
    private final QueryMakerService queryMakerService;
    private final Session.PathResolver pathResolver;
    private final RepositoryImpl repository;
    protected boolean clusteringEnabled;

    public JDBCMapper(Model model, Session.PathResolver pathResolver, SQLInfo sqlInfo, XADataSource xadatasource, ClusterInvalidator clusterInvalidator, boolean noSharing, RepositoryImpl repository) {
        super(model, sqlInfo, xadatasource, clusterInvalidator, repository.getInvalidationsPropagator(), noSharing);
        this.pathResolver = pathResolver;
        this.repository = repository;
        this.clusteringEnabled = clusterInvalidator != null;
        this.queryMakerService = (QueryMakerService)Framework.getService(QueryMakerService.class);
        this.tableUpgrader = new TableUpgrader(this);
        this.tableUpgrader.add("versions", "islatest", "upgradeVersions", TEST_UPGRADE_VERSIONS);
        this.tableUpgrader.add("dublincore", "lastContributor", "upgradeLastContributor", TEST_UPGRADE_LAST_CONTRIBUTOR);
        this.tableUpgrader.add("locks", "owner", "upgradeLocks", TEST_UPGRADE_LOCKS);
    }

    @Override
    public int getTableSize(String tableName) {
        return this.sqlInfo.getDatabase().getTable(tableName).getColumns().size();
    }

    @Override
    public void createDatabase() {
        try {
            this.createTables();
        }
        catch (SQLException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    protected String getTableName(String origName) {
        if (this.dialect instanceof DialectOracle && origName.length() > 30) {
            StringBuilder sb = new StringBuilder(origName.length());
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                sb.append(origName.substring(0, 15));
                sb.append('_');
                digest.update(origName.getBytes());
                sb.append(Dialect.toHexString(digest.digest()).substring(0, 12));
                return sb.toString();
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException("Error", e);
            }
        }
        return origName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createTables() throws SQLException {
        this.sqlInfo.executeSQLStatements(null, this);
        this.sqlInfo.executeSQLStatements("first", this);
        this.sqlInfo.executeSQLStatements("beforeTableCreation", this);
        if (testProps.containsKey(TEST_UPGRADE)) {
            this.sqlInfo.executeSQLStatements(TEST_UPGRADE, this);
        }
        String schemaName = this.dialect.getConnectionSchema(this.connection);
        DatabaseMetaData metadata = this.connection.getMetaData();
        Set<String> tableNames = JDBCMapper.findTableNames(metadata, schemaName);
        Database database = this.sqlInfo.getDatabase();
        HashMap added = new HashMap();
        Statement st = null;
        ResultSet rs = null;
        try {
            st = this.connection.createStatement();
            for (Table table : database.getTables()) {
                String tableName = this.getTableName(table.getPhysicalName());
                if (tableNames.contains(tableName.toUpperCase())) {
                    this.dialect.existingTableDetected(this.connection, table, this.model, this.sqlInfo.database);
                } else {
                    boolean create = this.dialect.preCreateTable(this.connection, table, this.model, this.sqlInfo.database);
                    if (!create) {
                        log.warn((Object)("Creation skipped for table: " + tableName));
                        continue;
                    }
                    String sql = table.getCreateSql();
                    this.logger.log(sql);
                    try {
                        st.execute(sql);
                        this.countExecute();
                    }
                    catch (SQLException e) {
                        try {
                            this.closeStatement(st);
                        }
                        finally {
                            throw new SQLException("Error creating table: " + sql + " : " + e.getMessage(), e);
                        }
                    }
                    for (String s : table.getPostCreateSqls(this.model)) {
                        this.logger.log(s);
                        try {
                            st.execute(s);
                            this.countExecute();
                        }
                        catch (SQLException e) {
                            throw new SQLException("Error post creating table: " + s + " : " + e.getMessage(), e);
                        }
                    }
                    for (String s : this.dialect.getPostCreateTableSqls(table, this.model, this.sqlInfo.database)) {
                        this.logger.log(s);
                        try {
                            st.execute(s);
                            this.countExecute();
                        }
                        catch (SQLException e) {
                            throw new SQLException("Error post creating table: " + s + " : " + e.getMessage(), e);
                        }
                    }
                    added.put(table.getKey(), null);
                }
                rs = metadata.getColumns(null, schemaName, tableName, "%");
                HashMap<String, Integer> columnTypes = new HashMap<String, Integer>();
                HashMap<String, String> columnTypeNames = new HashMap<String, String>();
                HashMap<String, Integer> columnTypeSizes = new HashMap<String, Integer>();
                while (rs.next()) {
                    String schema = rs.getString("TABLE_SCHEM");
                    if (schema != null && "INFORMATION_SCHEMA".equals(schema.toUpperCase())) continue;
                    String columnName = rs.getString("COLUMN_NAME").toUpperCase();
                    columnTypes.put(columnName, rs.getInt("DATA_TYPE"));
                    columnTypeNames.put(columnName, rs.getString("TYPE_NAME"));
                    columnTypeSizes.put(columnName, rs.getInt("COLUMN_SIZE"));
                }
                rs.close();
                LinkedList<Column> addedColumns = new LinkedList<Column>();
                for (Column column : table.getColumns()) {
                    Integer actualSize;
                    String actualName;
                    String upperName = column.getPhysicalName().toUpperCase();
                    Integer type = (Integer)columnTypes.remove(upperName);
                    if (type == null) {
                        log.warn((Object)("Adding missing column in database: " + column.getFullQuotedName()));
                        String sql = table.getAddColumnSql(column);
                        this.logger.log(sql);
                        try {
                            st.execute(sql);
                            this.countExecute();
                        }
                        catch (SQLException e) {
                            throw new SQLException("Error adding column: " + sql + " : " + e.getMessage(), e);
                        }
                        for (String s : table.getPostAddSqls(column, this.model)) {
                            this.logger.log(s);
                            try {
                                st.execute(s);
                                this.countExecute();
                            }
                            catch (SQLException e) {
                                throw new SQLException("Error post adding column: " + s + " : " + e.getMessage(), e);
                            }
                        }
                        addedColumns.add(column);
                        continue;
                    }
                    int expected = column.getJdbcType();
                    int actual = type;
                    if (column.setJdbcType(actual, actualName = (String)columnTypeNames.get(upperName), actualSize = (Integer)columnTypeSizes.get(upperName))) continue;
                    log.error((Object)String.format("SQL type mismatch for %s: expected %s, database has %s / %s (%s)", column.getFullQuotedName(), expected, type, actualName, actualSize));
                }
                for (String col : this.dialect.getIgnoredColumns(table)) {
                    columnTypes.remove(col.toUpperCase());
                }
                if (!columnTypes.isEmpty()) {
                    log.warn((Object)("Database contains additional unused columns for table " + table.getQuotedName() + ": " + StringUtils.join(new ArrayList(columnTypes.keySet()), (String)", ")));
                }
                if (addedColumns.isEmpty()) continue;
                if (added.containsKey(table.getKey())) {
                    throw new AssertionError();
                }
                added.put(table.getKey(), addedColumns);
            }
        }
        finally {
            try {
                this.closeStatement(st, rs);
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (testProps.containsKey(TEST_UPGRADE)) {
            this.sqlInfo.executeSQLStatements("testUpgradeOldTables", this);
        }
        for (Map.Entry entry : added.entrySet()) {
            List addedColumns = (List)entry.getValue();
            String tableKey = (String)entry.getKey();
            this.upgradeTable(tableKey, addedColumns);
        }
        this.sqlInfo.executeSQLStatements("afterTableCreation", this);
        this.sqlInfo.executeSQLStatements("last", this);
        this.dialect.performAdditionalStatements(this.connection);
    }

    protected void upgradeTable(String tableKey, List<Column> addedColumns) throws SQLException {
        this.tableUpgrader.upgrade(tableKey, addedColumns);
    }

    protected static Set<String> findTableNames(DatabaseMetaData metadata, String schemaName) throws SQLException {
        HashSet<String> tableNames = new HashSet<String>();
        ResultSet rs = metadata.getTables(null, schemaName, "%", new String[]{"TABLE"});
        while (rs.next()) {
            String tableName = rs.getString("TABLE_NAME");
            tableNames.add(tableName.toUpperCase());
        }
        rs.close();
        return tableNames;
    }

    @Override
    public int getClusterNodeIdType() {
        return this.sqlInfo.getClusterNodeIdType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createClusterNode(Serializable nodeId) {
        Calendar now = Calendar.getInstance();
        try {
            String sql = this.sqlInfo.getCreateClusterNodeSql();
            List<Column> columns = this.sqlInfo.getCreateClusterNodeColumns();
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                if (this.logger.isLogEnabled()) {
                    this.logger.logSQL(sql, Arrays.asList(nodeId, now));
                }
                columns.get(0).setToPreparedStatement(ps, 1, nodeId);
                columns.get(1).setToPreparedStatement(ps, 2, now);
                ps.execute();
            }
            finally {
                this.closeStatement(ps);
            }
        }
        catch (SQLException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeClusterNode(Serializable nodeId) {
        try {
            String sql = this.sqlInfo.getDeleteClusterNodeSql();
            Column column = this.sqlInfo.getDeleteClusterNodeColumn();
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                if (this.logger.isLogEnabled()) {
                    this.logger.logSQL(sql, Arrays.asList(nodeId));
                }
                column.setToPreparedStatement(ps, 1, nodeId);
                ps.execute();
            }
            finally {
                this.closeStatement(ps);
            }
            this.deleteClusterInvals(nodeId);
        }
        catch (SQLException e) {
            throw new NuxeoException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteClusterInvals(Serializable nodeId) throws SQLException {
        String sql = this.sqlInfo.getDeleteClusterInvalsSql();
        Column column = this.sqlInfo.getDeleteClusterInvalsColumn();
        PreparedStatement ps = this.connection.prepareStatement(sql);
        try {
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(sql, Arrays.asList(nodeId));
            }
            column.setToPreparedStatement(ps, 1, nodeId);
            int n = ps.executeUpdate();
            this.countExecute();
            if (this.logger.isLogEnabled()) {
                this.logger.logCount(n);
            }
        }
        finally {
            try {
                this.closeStatement(ps);
            }
            catch (SQLException e) {
                log.error((Object)("deleteClusterInvals: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    @Override
    public void insertClusterInvalidations(Serializable nodeId, Invalidations invalidations) {
        String sql = this.dialect.getClusterInsertInvalidations();
        List<Column> columns = this.sqlInfo.getClusterInvalidationsColumns();
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement(sql);
            int kind = 1;
            while (true) {
                Set<RowId> rowIds = invalidations.getKindSet(kind);
                HashMap<Serializable, HashSet<String>> res = new HashMap<Serializable, HashSet<String>>();
                for (RowId rowId : rowIds) {
                    HashSet<String> tableNames = (HashSet<String>)res.get(rowId.id);
                    if (tableNames == null) {
                        tableNames = new HashSet<String>();
                        res.put(rowId.id, tableNames);
                    }
                    tableNames.add(rowId.tableName);
                }
                for (Map.Entry entry : res.entrySet()) {
                    Serializable id = (Serializable)entry.getKey();
                    String[] fragments = JDBCMapper.join((Collection)entry.getValue(), ' ');
                    if (this.logger.isLogEnabled()) {
                        this.logger.logSQL(sql, Arrays.asList(nodeId, id, fragments, Long.valueOf(kind)));
                    }
                    String[] frags = this.dialect.supportsArrays() && columns.get(2).getJdbcType() == 2003 ? fragments.split(" ") : fragments;
                    columns.get(0).setToPreparedStatement(ps, 1, nodeId);
                    columns.get(1).setToPreparedStatement(ps, 2, id);
                    columns.get(2).setToPreparedStatement(ps, 3, (Serializable)frags);
                    columns.get(3).setToPreparedStatement(ps, 4, Long.valueOf(kind));
                    ps.execute();
                    this.countExecute();
                }
                if (kind == 1) {
                    kind = 2;
                    continue;
                }
                break;
            }
        }
        catch (SQLException e) {
            throw new NuxeoException("Could not invalidate", (Throwable)e);
        }
        finally {
            try {
                this.closeStatement(ps);
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    protected static final String join(Collection<String> strings, char sep) {
        if (strings.isEmpty()) {
            throw new RuntimeException();
        }
        if (strings.size() == 1) {
            return strings.iterator().next();
        }
        int size = 0;
        for (String word : strings) {
            size += word.length() + 1;
        }
        StringBuilder buf = new StringBuilder(size);
        for (String word : strings) {
            buf.append(word);
            buf.append(sep);
        }
        buf.setLength(size - 1);
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Invalidations getClusterInvalidations(Serializable nodeId) {
        Invalidations invalidations = new Invalidations();
        String sql = this.dialect.getClusterGetInvalidations();
        List<Column> columns = this.sqlInfo.getClusterInvalidationsColumns();
        try {
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(sql, Arrays.asList(nodeId));
            }
            PreparedStatement ps = this.connection.prepareStatement(sql);
            ResultSet rs = null;
            try {
                this.setToPreparedStatement(ps, 1, nodeId);
                rs = ps.executeQuery();
                this.countExecute();
                while (rs.next()) {
                    Serializable id = columns.get(1).getFromResultSet(rs, 1);
                    Serializable frags = columns.get(2).getFromResultSet(rs, 2);
                    int kind = ((Long)columns.get(3).getFromResultSet(rs, 3)).intValue();
                    String[] fragments = this.dialect.supportsArrays() && frags instanceof String[] ? (String[])frags : ((String)((Object)frags)).split(" ");
                    invalidations.add(id, fragments, kind);
                }
            }
            catch (Throwable throwable) {
                this.closeStatement(ps, rs);
                throw throwable;
            }
            this.closeStatement(ps, rs);
            if (this.logger.isLogEnabled()) {
                this.logger.log("  -> " + invalidations);
            }
            if (this.dialect.isClusteringDeleteNeeded()) {
                this.deleteClusterInvals(nodeId);
            }
            return invalidations;
        }
        catch (SQLException e) {
            throw new NuxeoException("Could not invalidate", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Serializable getRootId(String repositoryId) {
        String sql = this.sqlInfo.getSelectRootIdSql();
        try {
            ResultSet rs;
            PreparedStatement ps;
            block9: {
                Serializable serializable;
                if (this.logger.isLogEnabled()) {
                    this.logger.logSQL(sql, Collections.singletonList(repositoryId));
                }
                ps = this.connection.prepareStatement(sql);
                rs = null;
                try {
                    ps.setString(1, repositoryId);
                    rs = ps.executeQuery();
                    this.countExecute();
                    if (rs.next()) break block9;
                    if (this.logger.isLogEnabled()) {
                        this.logger.log("  -> (none)");
                    }
                    serializable = null;
                }
                catch (Throwable throwable) {
                    this.closeStatement(ps, rs);
                    throw throwable;
                }
                this.closeStatement(ps, rs);
                return serializable;
            }
            Column column = this.sqlInfo.getSelectRootIdWhatColumn();
            Serializable id = column.getFromResultSet(rs, 1);
            if (this.logger.isLogEnabled()) {
                this.logger.log("  -> id=" + id);
            }
            if (rs.next()) {
                throw new NuxeoException("Row query for " + repositoryId + " returned several rows: " + sql);
            }
            Serializable serializable = id;
            this.closeStatement(ps, rs);
            return serializable;
        }
        catch (SQLException e) {
            throw new NuxeoException("Could not select: " + sql, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setRootId(Serializable repositoryId, Serializable id) {
        String sql = this.sqlInfo.getInsertRootIdSql();
        try {
            PreparedStatement ps = this.connection.prepareStatement(sql);
            try {
                List<Column> columns = this.sqlInfo.getInsertRootIdColumns();
                ArrayList<Serializable> debugValues = null;
                if (this.logger.isLogEnabled()) {
                    debugValues = new ArrayList<Serializable>(2);
                }
                int i = 0;
                for (Column column : columns) {
                    Serializable v;
                    ++i;
                    String key = column.getKey();
                    if (key.equals("id")) {
                        v = id;
                    } else if (key.equals("name")) {
                        v = repositoryId;
                    } else {
                        throw new RuntimeException(key);
                    }
                    column.setToPreparedStatement(ps, i, v);
                    if (debugValues == null) continue;
                    debugValues.add(v);
                }
                if (debugValues != null) {
                    this.logger.logSQL(sql, debugValues);
                    debugValues.clear();
                }
                ps.execute();
                this.countExecute();
            }
            finally {
                this.closeStatement(ps);
            }
        }
        catch (SQLException e) {
            throw new NuxeoException("Could not insert: " + sql, (Throwable)e);
        }
    }

    protected QueryMaker findQueryMaker(String queryType) {
        for (Class<? extends QueryMaker> klass : this.queryMakerService.getQueryMakers()) {
            QueryMaker queryMaker;
            try {
                queryMaker = klass.newInstance();
            }
            catch (ReflectiveOperationException e) {
                throw new NuxeoException((Throwable)e);
            }
            if (!queryMaker.accepts(queryType)) continue;
            return queryMaker;
        }
        return null;
    }

    protected void prepareUserReadAcls(QueryFilter queryFilter) {
        String sql = this.dialect.getPrepareUserReadAclsSql();
        Object principals = queryFilter.getPrincipals();
        if (sql == null || principals == null) {
            return;
        }
        if (!this.dialect.supportsArrays()) {
            principals = StringUtils.join((Object[])principals, (String)"|");
        }
        PreparedStatement ps = null;
        try {
            ps = this.connection.prepareStatement(sql);
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(sql, Collections.singleton(principals));
            }
            this.setToPreparedStatement(ps, 1, (Serializable)principals);
            ps.execute();
            this.countExecute();
        }
        catch (SQLException e) {
            throw new NuxeoException("Failed to prepare user read acl cache", (Throwable)e);
        }
        finally {
            try {
                this.closeStatement(ps);
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public PartialList<Serializable> query(String query, String queryType, QueryFilter queryFilter, boolean countTotal) {
        return this.query(query, queryType, queryFilter, countTotal ? -1L : 0L);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public PartialList<Serializable> query(String query, String queryType, QueryFilter queryFilter, long countUpTo) {
        PartialList partialList;
        String sql;
        QueryMaker queryMaker;
        if (this.dialect.needsPrepareUserReadAcls()) {
            this.prepareUserReadAcls(queryFilter);
        }
        if ((queryMaker = this.findQueryMaker(queryType)) == null) {
            throw new NuxeoException("No QueryMaker accepts query: " + queryType + ": " + query);
        }
        QueryMaker.Query q = queryMaker.buildQuery(this.sqlInfo, this.model, this.pathResolver, query, queryFilter, new Object[0]);
        if (q == null) {
            this.logger.log("Query cannot return anything due to conflicting clauses");
            return new PartialList(Collections.emptyList(), 0L);
        }
        long limit = queryFilter.getLimit();
        long offset = queryFilter.getOffset();
        if (this.logger.isLogEnabled()) {
            sql = q.selectInfo.sql;
            if (limit != 0L) {
                sql = sql + " -- LIMIT " + limit + " OFFSET " + offset;
            }
            if (countUpTo != 0L) {
                sql = sql + " -- COUNT TOTAL UP TO " + countUpTo;
            }
            this.logger.logSQL(sql, q.selectParams);
        }
        sql = q.selectInfo.sql;
        if (countUpTo == 0L && limit > 0L && this.dialect.supportsPaging()) {
            sql = this.dialect.addPagingClause(sql, limit, offset);
            limit = 0L;
            offset = 0L;
        } else if (countUpTo > 0L && this.dialect.supportsPaging()) {
            sql = this.dialect.addPagingClause(sql, Math.max(countUpTo + 1L, limit + offset), 0L);
        }
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            boolean available;
            ps = this.connection.prepareStatement(sql, 1004, 1007);
            int i = 1;
            for (Serializable object : q.selectParams) {
                this.setToPreparedStatement(ps, i++, object);
            }
            rs = ps.executeQuery();
            this.countExecute();
            long totalSize = -1L;
            if (limit == 0L || offset == 0L) {
                available = rs.first();
                if (!available) {
                    totalSize = 0L;
                }
                if (limit == 0L) {
                    limit = -1L;
                }
            } else {
                available = rs.absolute((int)offset + 1);
            }
            Column column = q.selectInfo.whatColumns.get(0);
            LinkedList<Serializable> ids = new LinkedList<Serializable>();
            int rowNum = 0;
            while (available && limit != 0L) {
                Serializable id = column.getFromResultSet(rs, 1);
                ids.add(id);
                rowNum = rs.getRow();
                available = rs.next();
                --limit;
            }
            if (countUpTo != 0L && totalSize == -1L) {
                if (!available && rowNum != 0) {
                    totalSize = rowNum;
                } else {
                    rs.last();
                    totalSize = rs.getRow();
                }
                if (countUpTo > 0L && totalSize > countUpTo) {
                    totalSize = -2L;
                }
            }
            if (this.logger.isLogEnabled()) {
                this.logger.logIds(ids, countUpTo != 0L, totalSize);
            }
            partialList = new PartialList(ids, totalSize);
        }
        catch (SQLException e) {
            try {
                throw new NuxeoException("Invalid query: " + query, (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    this.closeStatement(ps, rs);
                    throw throwable;
                }
                catch (SQLException e2) {
                    log.error((Object)"Cannot close connection", (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            this.closeStatement(ps, rs);
            return partialList;
        }
        catch (SQLException e) {
            log.error((Object)"Cannot close connection", (Throwable)e);
        }
        return partialList;
    }

    public int setToPreparedStatement(PreparedStatement ps, int i, Serializable object) throws SQLException {
        if (object instanceof Calendar) {
            Calendar cal = (Calendar)object;
            ps.setTimestamp(i, this.dialect.getTimestampFromCalendar(cal), cal);
        } else if (object instanceof Date) {
            ps.setDate(i, (Date)object);
        } else if (object instanceof Long) {
            ps.setLong(i, (Long)object);
        } else if (object instanceof ColumnType.WrappedId) {
            this.dialect.setId(ps, i, (Serializable)((Object)object.toString()));
        } else if (object instanceof Object[]) {
            int jdbcType;
            if (object instanceof String[]) {
                jdbcType = this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.STRING).jdbcType;
            } else if (object instanceof Boolean[]) {
                jdbcType = this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.BOOLEAN).jdbcType;
            } else if (object instanceof Long[]) {
                jdbcType = this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.LONG).jdbcType;
            } else if (object instanceof Double[]) {
                jdbcType = this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.DOUBLE).jdbcType;
            } else if (object instanceof Date[]) {
                jdbcType = 91;
            } else if (object instanceof Clob[]) {
                jdbcType = 2005;
            } else if (object instanceof Calendar[]) {
                jdbcType = this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.TIMESTAMP).jdbcType;
                object = this.dialect.getTimestampFromCalendar((Calendar)object);
            } else {
                jdbcType = object instanceof Integer[] ? this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.INTEGER).jdbcType : this.dialect.getJDBCTypeAndString((ColumnType)ColumnType.CLOB).jdbcType;
            }
            Array array = this.dialect.createArrayOf(jdbcType, (Object[])object, this.connection);
            ps.setArray(i, array);
        } else {
            ps.setObject(i, object);
        }
        return i;
    }

    @Override
    public IterableQueryResult queryAndFetch(String query, String queryType, QueryFilter queryFilter, Object ... params) {
        QueryMaker queryMaker;
        if (this.dialect.needsPrepareUserReadAcls()) {
            this.prepareUserReadAcls(queryFilter);
        }
        if ((queryMaker = this.findQueryMaker(queryType)) == null) {
            throw new NuxeoException("No QueryMaker accepts query: " + queryType + ": " + query);
        }
        try {
            return new ResultSetQueryResult(queryMaker, query, queryFilter, this.pathResolver, this, params);
        }
        catch (SQLException e) {
            throw new NuxeoException("Invalid query: " + queryType + ": " + query, (Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Set<Serializable> getAncestorsIds(Collection<Serializable> ids) {
        HashSet<Serializable> hashSet;
        SQLInfo.SQLInfoSelect select = this.sqlInfo.getSelectAncestorsIds();
        if (select == null) {
            return this.getAncestorsIdsIterative(ids);
        }
        Serializable whereIds = this.newIdArray(ids);
        HashSet<Serializable> res = new HashSet<Serializable>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            if (this.logger.isLogEnabled()) {
                this.logger.logSQL(select.sql, Collections.singleton(whereIds));
            }
            Column what = select.whatColumns.get(0);
            ps = this.connection.prepareStatement(select.sql);
            this.setToPreparedStatementIdArray(ps, 1, whereIds);
            rs = ps.executeQuery();
            this.countExecute();
            LinkedList<Serializable> debugIds = null;
            if (this.logger.isLogEnabled()) {
                debugIds = new LinkedList<Serializable>();
            }
            while (rs.next()) {
                if (this.dialect.supportsArraysReturnInsteadOfRows()) {
                    Serializable[] resultIds;
                    for (Serializable id : resultIds = this.dialect.getArrayResult(rs.getArray(1))) {
                        if (id == null) continue;
                        res.add(id);
                        if (!this.logger.isLogEnabled()) continue;
                        debugIds.add(id);
                    }
                    continue;
                }
                Serializable id = what.getFromResultSet(rs, 1);
                if (id == null) continue;
                res.add(id);
                if (!this.logger.isLogEnabled()) continue;
                debugIds.add(id);
            }
            if (this.logger.isLogEnabled()) {
                this.logger.logIds(debugIds, false, 0L);
            }
            hashSet = res;
        }
        catch (SQLException e) {
            try {
                throw new NuxeoException("Failed to get ancestors ids", (Throwable)e);
            }
            catch (Throwable throwable) {
                try {
                    this.closeStatement(ps, rs);
                    throw throwable;
                }
                catch (SQLException e2) {
                    log.error((Object)e2.getMessage(), (Throwable)e2);
                }
                throw throwable;
            }
        }
        try {
            this.closeStatement(ps, rs);
            return hashSet;
        }
        catch (SQLException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return hashSet;
    }

    protected Set<Serializable> getAncestorsIdsIterative(Collection<Serializable> ids) {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            LinkedList<Serializable> todo = new LinkedList<Serializable>(ids);
            HashSet<Serializable> done = new HashSet<Serializable>();
            HashSet<Serializable> res = new HashSet<Serializable>();
            while (!todo.isEmpty()) {
                done.addAll(todo);
                SQLInfo.SQLInfoSelect select = this.sqlInfo.getSelectParentIds(todo.size());
                if (this.logger.isLogEnabled()) {
                    this.logger.logSQL(select.sql, todo);
                }
                Column what = select.whatColumns.get(0);
                Column where = select.whereColumns.get(0);
                ps = this.connection.prepareStatement(select.sql);
                int i = 1;
                for (Serializable id : todo) {
                    where.setToPreparedStatement(ps, i++, id);
                }
                rs = ps.executeQuery();
                this.countExecute();
                todo = new LinkedList();
                LinkedList<Serializable> debugIds = null;
                if (this.logger.isLogEnabled()) {
                    debugIds = new LinkedList<Serializable>();
                }
                while (rs.next()) {
                    Serializable id;
                    id = what.getFromResultSet(rs, 1);
                    if (id == null) continue;
                    res.add(id);
                    if (!done.contains(id)) {
                        todo.add(id);
                    }
                    if (!this.logger.isLogEnabled()) continue;
                    debugIds.add(id);
                }
                if (this.logger.isLogEnabled()) {
                    this.logger.logIds(debugIds, false, 0L);
                }
                rs.close();
                ps.close();
            }
            HashSet<Serializable> hashSet = res;
            return hashSet;
        }
        catch (SQLException e) {
            throw new NuxeoException("Failed to get ancestors ids", (Throwable)e);
        }
        finally {
            try {
                this.closeStatement(ps, rs);
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void updateReadAcls() {
        if (!this.dialect.supportsReadAcl()) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateReadAcls: updating");
        }
        Statement st = null;
        try {
            st = this.connection.createStatement();
            String sql = this.dialect.getUpdateReadAclsSql();
            if (this.logger.isLogEnabled()) {
                this.logger.log(sql);
            }
            st.execute(sql);
            this.countExecute();
        }
        catch (SQLException e) {
            throw new NuxeoException("Failed to update read acls", (Throwable)e);
        }
        finally {
            try {
                this.closeStatement(st);
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"updateReadAcls: done.");
        }
    }

    @Override
    public void rebuildReadAcls() {
        if (!this.dialect.supportsReadAcl()) {
            return;
        }
        log.debug((Object)"rebuildReadAcls: rebuilding ...");
        Statement st = null;
        try {
            st = this.connection.createStatement();
            String sql = this.dialect.getRebuildReadAclsSql();
            this.logger.log(sql);
            st.execute(sql);
            this.countExecute();
        }
        catch (SQLException e) {
            throw new NuxeoException("Failed to rebuild read acls", (Throwable)e);
        }
        finally {
            try {
                this.closeStatement(st);
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        log.debug((Object)"rebuildReadAcls: done.");
    }

    protected Connection connection(boolean autocommit) {
        try {
            this.connection.setAutoCommit(autocommit);
        }
        catch (SQLException e) {
            throw new NuxeoException("Cannot set auto commit mode onto " + this + "'s connection", (Throwable)e);
        }
        return this.connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Lock callInTransaction(LockCallable callable, boolean tx) {
        boolean ok = false;
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("callInTransaction setAutoCommit " + !tx));
            }
            this.connection.setAutoCommit(!tx);
        }
        catch (SQLException e) {
            throw new NuxeoException("Cannot set auto commit mode onto " + this + "'s connection", (Throwable)e);
        }
        try {
            Lock result = callable.call();
            ok = true;
            Lock lock = result;
            return lock;
        }
        finally {
            if (tx) {
                try {
                    try {
                        if (ok) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"callInTransaction commit");
                            }
                            this.connection.commit();
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)"callInTransaction rollback");
                            }
                            this.connection.rollback();
                        }
                    }
                    finally {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"callInTransaction restoring autoCommit=true");
                        }
                        this.connection.setAutoCommit(true);
                    }
                }
                catch (SQLException e) {
                    throw new NuxeoException((Throwable)e);
                }
            }
        }
    }

    @Override
    public Lock getLock(Serializable id) {
        RowId rowId;
        Row row;
        if (log.isDebugEnabled()) {
            try {
                log.debug((Object)("getLock " + id + " while autoCommit=" + this.connection.getAutoCommit()));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return (row = this.readSimpleRow(rowId = new RowId("locks", id))) == null ? null : new Lock((String)((Object)row.get("owner")), (Calendar)row.get("created"));
    }

    @Override
    public Lock setLock(Serializable id, Lock lock) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setLock " + id + " owner=" + lock.getOwner()));
        }
        SetLock call = new SetLock(id, lock);
        return this.callInTransaction(call, this.clusteringEnabled);
    }

    @Override
    public Lock removeLock(Serializable id, String owner, boolean force) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("removeLock " + id + " owner=" + owner + " force=" + force));
        }
        RemoveLock call = new RemoveLock(id, owner, force);
        return this.callInTransaction(call, !force);
    }

    @Override
    public void markReferencedBinaries() {
        log.debug((Object)"Starting binaries GC mark");
        Statement st = null;
        ResultSet rs = null;
        BlobManager blobManager = (BlobManager)Framework.getService(BlobManager.class);
        String repositoryName = this.getRepositoryName();
        try {
            st = this.connection.createStatement();
            int i = -1;
            for (String sql : this.sqlInfo.getBinariesSql) {
                Column col = this.sqlInfo.getBinariesColumns.get(++i);
                if (this.logger.isLogEnabled()) {
                    this.logger.log(sql);
                }
                rs = st.executeQuery(sql);
                this.countExecute();
                int n = 0;
                while (rs.next()) {
                    ++n;
                    String key = (String)((Object)col.getFromResultSet(rs, 1));
                    if (key == null) continue;
                    blobManager.markReferencedBinary(key, repositoryName);
                }
                if (this.logger.isLogEnabled()) {
                    this.logger.logCount(n);
                }
                rs.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException("Failed to mark binaries for gC", e);
        }
        finally {
            try {
                this.closeStatement(st, rs);
            }
            catch (SQLException e) {
                log.error((Object)e.getMessage(), (Throwable)e);
            }
        }
        log.debug((Object)"End of binaries GC mark");
    }

    protected static String systemToString(Object o) {
        return o.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(o));
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        try {
            this.xaresource.start(xid, flags);
            if (this.logger.isLogEnabled()) {
                this.logger.log("XA start on " + JDBCMapper.systemToString(xid));
            }
        }
        catch (NuxeoException e) {
            throw (XAException)new XAException(-3).initCause(e);
        }
        catch (XAException e) {
            this.logger.error("XA start error on " + JDBCMapper.systemToString(xid), e);
            throw e;
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        try {
            this.xaresource.end(xid, flags);
            if (this.logger.isLogEnabled()) {
                this.logger.log("XA end on " + JDBCMapper.systemToString(xid));
            }
        }
        catch (NullPointerException e) {
            this.logger.error("XA end error on " + JDBCMapper.systemToString(xid), e);
            throw (XAException)new XAException(-3).initCause(e);
        }
        catch (XAException e) {
            if (flags != 0x20000000) {
                this.logger.error("XA end error on " + JDBCMapper.systemToString(xid), e);
            }
            throw e;
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        try {
            return this.xaresource.prepare(xid);
        }
        catch (XAException e) {
            this.logger.error("XA prepare error on  " + JDBCMapper.systemToString(xid), e);
            throw e;
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        try {
            this.xaresource.commit(xid, onePhase);
        }
        catch (XAException e) {
            this.logger.error("XA commit error on  " + JDBCMapper.systemToString(xid), e);
            throw e;
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        this.xaresource.forget(xid);
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        return this.xaresource.recover(flag);
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        return this.xaresource.setTransactionTimeout(seconds);
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        return this.xaresource.getTransactionTimeout();
    }

    @Override
    public boolean isSameRM(XAResource xares) throws XAException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isConnected() {
        return this.connection != null;
    }

    @Override
    public void connect() {
        this.openConnections();
    }

    @Override
    public void disconnect() {
        this.closeConnections();
    }

    protected class RemoveLock
    implements LockCallable {
        protected final Serializable id;
        protected final String owner;
        protected final boolean force;

        protected RemoveLock(Serializable id, String owner, boolean force) {
            this.id = id;
            this.owner = owner;
            this.force = force;
        }

        @Override
        public Lock call() {
            Lock oldLock;
            Lock lock = oldLock = this.force ? null : JDBCMapper.this.getLock(this.id);
            if (!this.force && this.owner != null) {
                if (oldLock == null) {
                    return null;
                }
                if (!LockManager.canLockBeRemoved((String)oldLock.getOwner(), (String)this.owner)) {
                    return new Lock(oldLock, true);
                }
            }
            if (this.force || oldLock != null) {
                JDBCMapper.this.deleteRows("locks", Collections.singleton(this.id));
            }
            return oldLock;
        }
    }

    protected class SetLock
    implements LockCallable {
        protected final Serializable id;
        protected final Lock lock;

        protected SetLock(Serializable id, Lock lock) {
            this.id = id;
            this.lock = lock;
        }

        @Override
        public Lock call() {
            Lock oldLock = JDBCMapper.this.getLock(this.id);
            if (oldLock == null) {
                Row row = new Row("locks", this.id);
                row.put("owner", (Serializable)((Object)this.lock.getOwner()));
                row.put("created", this.lock.getCreated());
                JDBCMapper.this.insertSimpleRows("locks", Collections.singletonList(row));
            }
            return oldLock;
        }
    }

    public static interface LockCallable
    extends Callable<Lock> {
        @Override
        public Lock call();
    }
}

